/*
 * Decompiled with CFR 0.152.
 */
package alexthw.ars_elemental.common.blocks;

import alexthw.ars_elemental.api.item.ISchoolFocus;
import alexthw.ars_elemental.common.blocks.ElementalSpellTurretTile;
import com.hollingsworth.arsnouveau.api.ANFakePlayer;
import com.hollingsworth.arsnouveau.api.spell.EntitySpellResolver;
import com.hollingsworth.arsnouveau.api.spell.ISpellCaster;
import com.hollingsworth.arsnouveau.api.spell.ITurretBehavior;
import com.hollingsworth.arsnouveau.api.spell.SpellContext;
import com.hollingsworth.arsnouveau.api.spell.SpellResolver;
import com.hollingsworth.arsnouveau.api.spell.SpellSchool;
import com.hollingsworth.arsnouveau.api.spell.SpellSchools;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.IWrappedCaster;
import com.hollingsworth.arsnouveau.api.spell.wrapped_caster.TileCaster;
import com.hollingsworth.arsnouveau.api.util.SourceUtil;
import com.hollingsworth.arsnouveau.common.block.BasicSpellTurret;
import com.hollingsworth.arsnouveau.common.network.Networking;
import com.hollingsworth.arsnouveau.common.network.PacketOneShotAnimation;
import com.hollingsworth.arsnouveau.setup.registry.ItemsRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.BlockSourceImpl;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ElementalTurret
extends BasicSpellTurret {
    public final SpellSchool school;

    public ElementalTurret(BlockBehaviour.Properties properties, SpellSchool school) {
        super(properties.m_60955_());
        this.school = school;
    }

    public void shootSpell(ServerLevel world, BlockPos pos) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (!(blockEntity instanceof ElementalSpellTurretTile)) {
            return;
        }
        ElementalSpellTurretTile tile = (ElementalSpellTurretTile)blockEntity;
        ISpellCaster caster = tile.getSpellCaster();
        if (caster.getSpell().isEmpty()) {
            return;
        }
        int manaCost = tile.getManaCost();
        if (manaCost > 0 && SourceUtil.takeSourceWithParticles((BlockPos)pos, (Level)world, (int)10, (int)manaCost) == null) {
            return;
        }
        Networking.sendToNearby((Level)world, (BlockPos)pos, (Object)new PacketOneShotAnimation(pos));
        Position iposition = ElementalTurret.getDispensePosition((BlockSource)new BlockSourceImpl(world, pos));
        Direction direction = (Direction)world.m_8055_(pos).m_61143_((Property)FACING);
        ANFakePlayer fakePlayer = ANFakePlayer.getPlayer((ServerLevel)world);
        fakePlayer.m_6034_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        TurretSpellResolver resolver = new TurretSpellResolver(new SpellContext((Level)world, caster.getSpell(), (LivingEntity)fakePlayer, (IWrappedCaster)new TileCaster((BlockEntity)tile, SpellContext.CasterType.TURRET)), tile);
        if (resolver.castType != null && TURRET_BEHAVIOR_MAP.containsKey(resolver.castType)) {
            ((ITurretBehavior)TURRET_BEHAVIOR_MAP.get(resolver.castType)).onCast((SpellResolver)resolver, world, pos, (Player)fakePlayer, iposition, direction);
            caster.playSound(pos, (Level)world, null, caster.getCurrentSound(), SoundSource.BLOCKS);
        }
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ElementalSpellTurretTile(pos, state).setSchool(this.school);
    }

    static class TurretSpellResolver
    extends EntitySpellResolver {
        ElementalSpellTurretTile tile;

        public TurretSpellResolver(SpellContext context, ElementalSpellTurretTile tile) {
            super(context);
            this.tile = tile;
        }

        public boolean hasFocus(ItemStack stack) {
            Item item = stack.m_41720_();
            if (item instanceof ISchoolFocus) {
                ISchoolFocus focus = (ISchoolFocus)item;
                return this.tile.getSchool() == focus.getSchool();
            }
            if (stack.m_41720_() == ItemsRegistry.SHAPERS_FOCUS.get()) {
                return this.tile.getSchool() == SpellSchools.MANIPULATION;
            }
            return super.hasFocus(stack);
        }

        public SpellResolver getNewResolver(SpellContext context) {
            return new TurretSpellResolver(context, this.tile);
        }
    }
}

