/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.guidebook.compiler;

import appeng.client.guidebook.PageAnchor;
import appeng.client.guidebook.compiler.IdUtils;
import appeng.client.guidebook.compiler.PageCompiler;
import java.net.URI;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;

public final class LinkParser {
    private LinkParser() {
    }

    public static void parseLink(PageCompiler compiler, String href, Visitor visitor) {
        ResourceLocation pageId;
        URI uri;
        try {
            uri = URI.create(href);
        }
        catch (Exception ignored) {
            visitor.handleError("Invalid URL");
            return;
        }
        if (uri.isAbsolute()) {
            visitor.handleExternal(uri);
            return;
        }
        try {
            pageId = IdUtils.resolveLink(uri.getPath(), compiler.getPageId());
        }
        catch (ResourceLocationException ignored) {
            visitor.handleError("Invalid link");
            return;
        }
        if (!compiler.getPageCollection().pageExists(pageId)) {
            visitor.handleError("Page does not exist");
            return;
        }
        visitor.handlePage(new PageAnchor(pageId, uri.getFragment()));
    }

    public static interface Visitor {
        default public void handlePage(PageAnchor page) {
        }

        default public void handleExternal(URI uri) {
        }

        default public void handleError(String error) {
        }
    }
}

