/*
 * Decompiled with CFR 0.152.
 */
package appeng.siteexport;

import appeng.api.features.P2PTunnelAttunement;
import appeng.api.features.P2PTunnelAttunementInternal;
import appeng.api.util.AEColor;
import appeng.client.guidebook.Guide;
import appeng.client.guidebook.GuidePage;
import appeng.client.guidebook.compiler.PageCompiler;
import appeng.client.guidebook.compiler.ParsedGuidePage;
import appeng.client.guidebook.indices.CategoryIndex;
import appeng.client.guidebook.indices.ItemIndex;
import appeng.client.guidebook.navigation.NavigationNode;
import appeng.core.AppEngClient;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEParts;
import appeng.core.definitions.ColoredItemDefinition;
import appeng.recipes.entropy.EntropyRecipe;
import appeng.recipes.handlers.ChargerRecipe;
import appeng.recipes.handlers.InscriberRecipe;
import appeng.recipes.mattercannon.MatterCannonAmmo;
import appeng.recipes.transform.TransformRecipe;
import appeng.siteexport.CacheBusting;
import appeng.siteexport.ExportableResourceProvider;
import appeng.siteexport.FabricClientCommandSource;
import appeng.siteexport.ModVersion;
import appeng.siteexport.OffScreenRenderer;
import appeng.siteexport.ResourceExporter;
import appeng.siteexport.SiteExportWriter;
import appeng.siteexport.WebPExporter;
import appeng.siteexport.mdastpostprocess.PageExportPostProcessor;
import appeng.siteexport.model.P2PTypeInfo;
import appeng.util.CraftingRecipeUtil;
import appeng.util.Platform;
import com.google.common.io.MoreFiles;
import com.google.common.io.RecursiveDeleteOption;
import com.google.gson.stream.JsonWriter;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.DetectedVersion;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.LoadingOverlay;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.SmithingTransformRecipe;
import net.minecraft.world.item.crafting.SmithingTrimRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.SingleThreadedRandomSource;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.fluids.FluidStack;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

@OnlyIn(value=Dist.CLIENT)
public final class SiteExporter
implements ResourceExporter {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int ICON_DIMENSION = 128;
    private final Minecraft client;
    private final Map<ResourceLocation, String> exportedTextures = new HashMap<ResourceLocation, String>();
    private final Path outputFolder;
    private final Guide guide;
    private ParsedGuidePage currentPage;
    private final Set<Recipe<?>> recipes = new HashSet();
    private final Set<Item> items = new HashSet<Item>();
    private final Set<Fluid> fluids = new HashSet<Fluid>();

    public SiteExporter(Minecraft client, Path outputFolder, Guide guide) {
        this.client = client;
        this.outputFolder = outputFolder;
        this.guide = guide;
        this.referenceItem((ItemLike)Items.f_41962_);
        this.referenceItem(AEBlocks.INSCRIBER);
        this.referenceFluid((Fluid)Fluids.f_76193_);
        this.referenceFluid((Fluid)Fluids.f_76195_);
        this.referenceItem((ItemLike)Items.f_41996_);
        this.referenceItem((ItemLike)Blocks.f_50625_);
    }

    public static void initialize() {
        if (Boolean.getBoolean("appeng.runGuideExportAndExit")) {
            Path outputFolder = Paths.get(System.getProperty("appeng.guideExportFolder"), new String[0]);
            MinecraftForge.EVENT_BUS.addListener(evt -> {
                if (evt.phase == TickEvent.Phase.END) {
                    Minecraft client = Minecraft.m_91087_();
                    if (client.m_91265_() instanceof LoadingOverlay) {
                        return;
                    }
                    Guide guide = AppEngClient.instance().getGuide();
                    try {
                        SiteExporter.export(client, outputFolder, guide);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        System.exit(1);
                    }
                    System.exit(0);
                }
            });
        }
    }

    public static void export(FabricClientCommandSource source) {
        Guide guide = AppEngClient.instance().getGuide();
        try {
            Path outputFolder = Paths.get("guide-export", new String[0]).toAbsolutePath();
            SiteExporter.export(Minecraft.m_91087_(), outputFolder, guide);
            source.sendFeedback((Component)Component.m_237113_((String)"Guide data exported to ").m_7220_((Component)Component.m_237113_((String)("[" + outputFolder.getFileName().toString() + "]")).m_130938_(style -> style.m_131142_(new ClickEvent(ClickEvent.Action.OPEN_FILE, outputFolder.toString())).m_131144_(new HoverEvent(HoverEvent.Action.f_130831_, (Object)Component.m_237113_((String)"Click to open export folder"))).m_131152_(new ChatFormatting[]{ChatFormatting.UNDERLINE, ChatFormatting.GREEN}))));
        }
        catch (Exception e) {
            e.printStackTrace();
            source.sendError((Component)Component.m_237113_((String)e.toString()));
        }
    }

    private static void export(Minecraft client, Path outputFolder, Guide guide) throws Exception {
        new SiteExporter(client, outputFolder, guide).export();
    }

    @Override
    public void referenceItem(ItemStack stack) {
        if (!stack.m_41619_()) {
            this.items.add(stack.m_41720_());
            if (stack.m_41782_()) {
                LOGGER.error("Couldn't handle stack with NBT tag: {}", (Object)stack);
            }
        }
    }

    @Override
    public void referenceFluid(Fluid fluid) {
        this.fluids.add(fluid);
    }

    private void referenceIngredient(Ingredient ingredient) {
        for (ItemStack item : ingredient.m_43908_()) {
            this.referenceItem(item);
        }
    }

    @Override
    public void referenceRecipe(Recipe<?> recipe) {
        if (!this.recipes.add(recipe)) {
            return;
        }
        RegistryAccess registryAccess = Platform.getClientRegistryAccess();
        ItemStack resultItem = recipe.m_8043_(registryAccess);
        if (!resultItem.m_41619_()) {
            this.referenceItem(resultItem);
        }
        for (Ingredient ingredient : CraftingRecipeUtil.getIngredients(recipe)) {
            this.referenceIngredient(ingredient);
        }
    }

    private void dumpRecipes(SiteExportWriter writer) {
        for (Recipe<?> recipe : this.recipes) {
            if (recipe instanceof CraftingRecipe) {
                CraftingRecipe craftingRecipe = (CraftingRecipe)recipe;
                if (craftingRecipe.m_5598_()) continue;
                writer.addRecipe(craftingRecipe);
                continue;
            }
            if (recipe instanceof AbstractCookingRecipe) {
                AbstractCookingRecipe cookingRecipe = (AbstractCookingRecipe)recipe;
                writer.addRecipe(cookingRecipe);
                continue;
            }
            if (recipe instanceof InscriberRecipe) {
                InscriberRecipe inscriberRecipe = (InscriberRecipe)recipe;
                writer.addRecipe(inscriberRecipe);
                continue;
            }
            if (recipe instanceof TransformRecipe) {
                TransformRecipe transformRecipe = (TransformRecipe)recipe;
                writer.addRecipe(transformRecipe);
                continue;
            }
            if (recipe instanceof SmithingTransformRecipe) {
                SmithingTransformRecipe smithingTransformRecipe = (SmithingTransformRecipe)recipe;
                writer.addRecipe(smithingTransformRecipe);
                continue;
            }
            if (recipe instanceof SmithingTrimRecipe) {
                SmithingTrimRecipe smithingTrimRecipe = (SmithingTrimRecipe)recipe;
                writer.addRecipe(smithingTrimRecipe);
                continue;
            }
            if (recipe instanceof StonecutterRecipe) {
                StonecutterRecipe stonecutterRecipe = (StonecutterRecipe)recipe;
                writer.addRecipe(stonecutterRecipe);
                continue;
            }
            if (recipe instanceof EntropyRecipe) {
                EntropyRecipe entropyRecipe = (EntropyRecipe)recipe;
                writer.addRecipe(entropyRecipe);
                continue;
            }
            if (recipe instanceof MatterCannonAmmo) {
                MatterCannonAmmo ammoRecipe = (MatterCannonAmmo)recipe;
                writer.addRecipe(ammoRecipe);
                continue;
            }
            if (recipe instanceof ChargerRecipe) {
                ChargerRecipe chargerRecipe = (ChargerRecipe)recipe;
                writer.addRecipe(chargerRecipe);
                continue;
            }
            LOGGER.warn("Unable to handle recipe {} of type {}", (Object)recipe.m_6423_(), (Object)recipe.m_6671_());
        }
    }

    @Override
    public Path copyResource(ResourceLocation id) {
        try {
            Path pagePath = this.getPathForWriting(id);
            byte[] bytes = this.guide.loadAsset(id);
            if (bytes == null) {
                throw new IllegalArgumentException("Couldn't find asset " + id);
            }
            return CacheBusting.writeAsset(pagePath, bytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to copy resource " + id, e);
        }
    }

    @Override
    public Path getPathForWriting(ResourceLocation assetId) {
        try {
            Path path = this.resolvePath(assetId);
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            return path;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Path getOutputFolder() {
        return this.outputFolder;
    }

    @Override
    public ResourceLocation getPageSpecificResourceLocation(String suffix) {
        String path = this.currentPage.getId().m_135815_();
        int idx = path.lastIndexOf(46);
        if (idx != -1) {
            path = path.substring(0, idx);
        }
        return new ResourceLocation(this.currentPage.getId().m_135827_(), path + "_" + suffix);
    }

    @Override
    public Path getPageSpecificPathForWriting(String suffix) {
        String pageFilename = this.currentPage.getId().m_135815_();
        String filename = FilenameUtils.getBaseName((String)pageFilename) + "_" + suffix;
        Path pagePath = this.resolvePath(this.currentPage.getId());
        Path path = pagePath.resolveSibling(filename);
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return path;
    }

    @Override
    @Nullable
    public ResourceLocation getCurrentPageId() {
        return this.currentPage != null ? this.currentPage.getId() : null;
    }

    private void export() throws Exception {
        if (Files.isDirectory(this.outputFolder, new LinkOption[0])) {
            MoreFiles.deleteDirectoryContents((Path)this.outputFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        } else {
            Files.createDirectories(this.outputFolder, new FileAttribute[0]);
        }
        if (this.client.f_91073_ == null) {
            LOGGER.info("Reloading datapacks to get recipes");
            Guide.runDatapackReload();
            LOGGER.info("Completed datapack reload");
        }
        this.guide.getNavigationTree().getRootNodes().forEach(this::visitNavigationNodeIcons);
        SiteExportWriter indexWriter = new SiteExportWriter(this.guide);
        Iterator<ParsedGuidePage> iterator = this.guide.getPages().iterator();
        while (iterator.hasNext()) {
            ParsedGuidePage page;
            this.currentPage = page = iterator.next();
            LOGGER.debug("Compiling {}", (Object)page);
            GuidePage compiledPage = PageCompiler.compile(this.guide, this.guide.getExtensions(), page);
            this.processPage(indexWriter, page, compiledPage);
            ExportableResourceProvider.visit(compiledPage.document(), this);
        }
        this.dumpRecipes(indexWriter);
        this.processItems(this.client, indexWriter, this.outputFolder);
        this.processFluids(this.client, indexWriter, this.outputFolder);
        indexWriter.addIndex(this.guide, ItemIndex.class);
        indexWriter.addIndex(this.guide, CategoryIndex.class);
        Path guideContent = this.outputFolder.resolve("guide.json.gz");
        byte[] content = indexWriter.toByteArray();
        guideContent = CacheBusting.writeAsset(guideContent, content);
        this.writeSummary(guideContent.getFileName().toString());
    }

    private void visitNavigationNodeIcons(NavigationNode navigationNode) {
        this.referenceItem(navigationNode.icon());
        navigationNode.children().forEach(this::visitNavigationNodeIcons);
    }

    private void processPage(SiteExportWriter exportWriter, ParsedGuidePage page, GuidePage compiledPage) {
        PageExportPostProcessor.postprocess(this, page, compiledPage);
        exportWriter.addPage(page);
    }

    private void writeSummary(String guideDataFilename) throws IOException {
        String modVersion = ModVersion.get();
        long generated = Instant.now().toEpochMilli();
        String gameVersion = DetectedVersion.m_195834_().m_132493_();
        try (BufferedWriter writer = Files.newBufferedWriter(this.outputFolder.resolve("index.json"), StandardCharsets.UTF_8, new OpenOption[0]);){
            JsonWriter jsonWriter = SiteExportWriter.GSON.newJsonWriter((Writer)writer);
            jsonWriter.beginObject();
            jsonWriter.name("format").value(1L);
            jsonWriter.name("generated").value(generated);
            jsonWriter.name("gameVersion").value(gameVersion);
            jsonWriter.name("modVersion").value(modVersion);
            jsonWriter.name("guideDataPath").value(guideDataFilename);
            jsonWriter.endObject();
        }
    }

    private Path resolvePath(ResourceLocation id) {
        return this.outputFolder.resolve(id.m_135827_() + "/" + id.m_135815_());
    }

    private static void dumpP2PTypes(Set<Item> usedVanillaItems, SiteExportWriter siteExport) {
        ItemLike[] tunnelTypes;
        for (ItemLike tunnelItem : tunnelTypes = new ItemLike[]{P2PTunnelAttunement.ME_TUNNEL, P2PTunnelAttunement.ENERGY_TUNNEL, P2PTunnelAttunement.ITEM_TUNNEL, P2PTunnelAttunement.FLUID_TUNNEL, P2PTunnelAttunement.REDSTONE_TUNNEL, P2PTunnelAttunement.LIGHT_TUNNEL}) {
            P2PTypeInfo typeInfo = new P2PTypeInfo();
            typeInfo.tunnelItemId = SiteExporter.getItemId(tunnelItem.m_5456_()).toString();
            HashSet items = new HashSet();
            for (Map.Entry<TagKey<Item>, Item> entry : P2PTunnelAttunementInternal.getTagTunnels().entrySet()) {
                if (entry.getValue() != tunnelItem.m_5456_()) continue;
                BuiltInRegistries.f_257033_.m_206058_(entry.getKey()).forEach(h -> items.add((Item)h.m_203334_()));
            }
            items.stream().map(i -> SiteExporter.getItemId(i).toString()).forEach(typeInfo.attunementItemIds::add);
            P2PTunnelAttunementInternal.AttunementInfo attunementInfo = P2PTunnelAttunementInternal.getAttunementInfo(tunnelItem);
            attunementInfo.apis().stream().map(lookup -> lookup.getName()).forEach(typeInfo.attunementApiClasses::add);
            usedVanillaItems.addAll(items);
            siteExport.addP2PType(typeInfo);
        }
    }

    private static void dumpColoredItems(SiteExportWriter siteExport) {
        for (ColoredItemDefinition<?> coloredPart : AEParts.COLORED_PARTS) {
            SiteExporter.dumpColoredItem(coloredPart, siteExport);
        }
    }

    private static void dumpColoredItem(ColoredItemDefinition itemDefinition, SiteExportWriter siteExport) {
        Object baseItem = itemDefinition.item(AEColor.TRANSPARENT);
        if (baseItem == null) {
            return;
        }
        for (AEColor color : AEColor.values()) {
            Object coloredItem;
            if (color.dye == null || (coloredItem = itemDefinition.item(color)) == null) continue;
            siteExport.addColoredVersion((Item)baseItem, color.dye, (Item)coloredItem);
        }
    }

    private void processItems(Minecraft client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path iconsFolder = outputFolder.resolve("!items");
        if (Files.exists(iconsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)iconsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            GuiGraphics guiGraphics = new GuiGraphics(client, client.m_91269_().m_110104_());
            renderer.setupItemRendering();
            LOGGER.info("Exporting items...");
            for (Item item : this.items) {
                ItemStack stack = new ItemStack((ItemLike)item);
                String itemId = SiteExporter.getItemId(stack.m_41720_()).toString();
                String baseName = "!items/" + itemId.replace(':', '/');
                BakedModel itemModel = client.m_91291_().m_174264_(stack, null, null, 0);
                Set<TextureAtlasSprite> sprites = this.guessSprites(Set.of(itemModel));
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    guiGraphics.m_280480_(stack, 0, 0);
                    guiGraphics.m_280302_(client.f_91062_, stack, 0, 0, "");
                }, sprites, true);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addItem(itemId, stack, absIconUrl);
            }
        }
    }

    private Set<TextureAtlasSprite> guessSprites(Collection<BakedModel> models) {
        Set<TextureAtlasSprite> result = Collections.newSetFromMap(new IdentityHashMap());
        SingleThreadedRandomSource randomSource = new SingleThreadedRandomSource(0L);
        for (BakedModel model : models) {
            for (BakedQuad quad : model.m_213637_(null, null, (RandomSource)randomSource)) {
                result.add(quad.m_173410_());
            }
        }
        return result;
    }

    private void processFluids(Minecraft client, SiteExportWriter siteExport, Path outputFolder) throws IOException {
        Path fluidsFolder = outputFolder.resolve("!fluids");
        if (Files.exists(fluidsFolder, new LinkOption[0])) {
            MoreFiles.deleteRecursively((Path)fluidsFolder, (RecursiveDeleteOption[])new RecursiveDeleteOption[]{RecursiveDeleteOption.ALLOW_INSECURE});
        }
        try (OffScreenRenderer renderer = new OffScreenRenderer(128, 128);){
            GuiGraphics guiGraphics = new GuiGraphics(client, client.m_91269_().m_110104_());
            renderer.setupItemRendering();
            LOGGER.info("Exporting fluids...");
            for (Fluid fluid : this.fluids) {
                FluidStack fluidVariant = new FluidStack(fluid, 1);
                String fluidId = BuiltInRegistries.f_257020_.m_7981_((Object)fluid).toString();
                IClientFluidTypeExtensions props = IClientFluidTypeExtensions.of((Fluid)fluidVariant.getFluid());
                TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(InventoryMenu.f_39692_).apply(props.getStillTexture(fluidVariant));
                int color = props.getTintColor(fluidVariant);
                String baseName = "!fluids/" + fluidId.replace(':', '/');
                Path iconPath = this.renderAndWrite(renderer, baseName, () -> {
                    if (sprite != null) {
                        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
                        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
                        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
                        float a = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
                        guiGraphics.m_280565_(0, 0, 0, 16, 16, sprite, r, g, b, a);
                    }
                }, sprite != null ? Set.of(sprite) : Set.of(), false);
                String absIconUrl = "/" + outputFolder.relativize(iconPath).toString().replace('\\', '/');
                siteExport.addFluid(fluidId, fluidVariant, absIconUrl);
            }
        }
    }

    @Override
    public Path renderAndWrite(OffScreenRenderer renderer, String baseName, Runnable renderRunnable, Collection<TextureAtlasSprite> sprites, boolean withAlpha) throws IOException {
        byte[] content;
        String extension;
        if (renderer.isAnimated(sprites)) {
            extension = ".webp";
            content = renderer.captureAsWebp(renderRunnable, sprites, withAlpha ? WebPExporter.Format.LOSSLESS_ALPHA : WebPExporter.Format.LOSSLESS);
        } else {
            extension = ".png";
            content = renderer.captureAsPng(renderRunnable);
        }
        Path iconPath = this.outputFolder.resolve(baseName + extension);
        Files.createDirectories(iconPath.getParent(), new FileAttribute[0]);
        return CacheBusting.writeAsset(iconPath, content);
    }

    @Override
    public String exportTexture(ResourceLocation textureId) {
        byte[] imageContent;
        String exportedPath = this.exportedTextures.get(textureId);
        if (exportedPath != null) {
            return exportedPath;
        }
        ResourceLocation id = textureId;
        if (!id.m_135815_().endsWith(".png")) {
            id = new ResourceLocation(id.m_135827_(), id.m_135815_() + ".png");
        }
        Path outputPath = this.getPathForWriting(id);
        AbstractTexture texture = Minecraft.m_91087_().m_91097_().m_118506_(textureId);
        if (texture instanceof TextureAtlas) {
            TextureAtlas textureAtlas = (TextureAtlas)texture;
            for (SpriteContents sprite : textureAtlas.f_118263_) {
                if (sprite.f_244575_ == null) continue;
            }
        }
        texture.m_117966_();
        int[] intResult = new int[1];
        GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4096, (int[])intResult);
        int w = intResult[0];
        GL11.glGetTexLevelParameteriv((int)3553, (int)0, (int)4097, (int[])intResult);
        int h = intResult[0];
        try (NativeImage nativeImage = new NativeImage(w, h, false);){
            nativeImage.m_85045_(0, false);
            imageContent = nativeImage.m_85121_();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        try {
            outputPath = CacheBusting.writeAsset(outputPath, imageContent);
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to export texture " + textureId, e);
        }
        exportedPath = this.getPathRelativeFromOutputFolder(outputPath);
        this.exportedTextures.put(textureId, exportedPath);
        return exportedPath;
    }

    private static ResourceLocation getItemId(Item item) {
        return BuiltInRegistries.f_257033_.m_7981_((Object)item);
    }

    private static ResourceLocation getFluidId(Fluid fluid) {
        return BuiltInRegistries.f_257020_.m_7981_((Object)fluid);
    }
}

