/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.definitions;

import appeng.block.AEBaseEntityBlock;
import appeng.blockentity.AEBaseBlockEntity;
import appeng.blockentity.ClientTickingBlockEntity;
import appeng.blockentity.ServerTickingBlockEntity;
import appeng.blockentity.crafting.CraftingBlockEntity;
import appeng.blockentity.crafting.CraftingMonitorBlockEntity;
import appeng.blockentity.crafting.MolecularAssemblerBlockEntity;
import appeng.blockentity.crafting.PatternProviderBlockEntity;
import appeng.blockentity.misc.CellWorkbenchBlockEntity;
import appeng.blockentity.misc.ChargerBlockEntity;
import appeng.blockentity.misc.CondenserBlockEntity;
import appeng.blockentity.misc.CrankBlockEntity;
import appeng.blockentity.misc.GrowthAcceleratorBlockEntity;
import appeng.blockentity.misc.InscriberBlockEntity;
import appeng.blockentity.misc.InterfaceBlockEntity;
import appeng.blockentity.misc.LightDetectorBlockEntity;
import appeng.blockentity.misc.PaintSplotchesBlockEntity;
import appeng.blockentity.misc.VibrationChamberBlockEntity;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.blockentity.networking.ControllerBlockEntity;
import appeng.blockentity.networking.CreativeEnergyCellBlockEntity;
import appeng.blockentity.networking.EnergyAcceptorBlockEntity;
import appeng.blockentity.networking.EnergyCellBlockEntity;
import appeng.blockentity.networking.WirelessAccessPointBlockEntity;
import appeng.blockentity.qnb.QuantumBridgeBlockEntity;
import appeng.blockentity.spatial.SpatialAnchorBlockEntity;
import appeng.blockentity.spatial.SpatialIOPortBlockEntity;
import appeng.blockentity.spatial.SpatialPylonBlockEntity;
import appeng.blockentity.storage.ChestBlockEntity;
import appeng.blockentity.storage.DriveBlockEntity;
import appeng.blockentity.storage.IOPortBlockEntity;
import appeng.blockentity.storage.SkyChestBlockEntity;
import appeng.blockentity.storage.SkyStoneTankBlockEntity;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.debug.ChunkLoaderBlockEntity;
import appeng.debug.CubeGeneratorBlockEntity;
import appeng.debug.EnergyGeneratorBlockEntity;
import appeng.debug.ItemGenBlockEntity;
import appeng.debug.PhantomNodeBlockEntity;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public final class AEBlockEntities {
    private static final Map<ResourceLocation, BlockEntityType<?>> BLOCK_ENTITY_TYPES = new HashMap();
    public static final BlockEntityType<InscriberBlockEntity> INSCRIBER = AEBlockEntities.create("inscriber", InscriberBlockEntity.class, InscriberBlockEntity::new, AEBlocks.INSCRIBER);
    public static final BlockEntityType<WirelessAccessPointBlockEntity> WIRELESS_ACCESS_POINT = AEBlockEntities.create("wireless_access_point", WirelessAccessPointBlockEntity.class, WirelessAccessPointBlockEntity::new, AEBlocks.WIRELESS_ACCESS_POINT);
    public static final BlockEntityType<ChargerBlockEntity> CHARGER = AEBlockEntities.create("charger", ChargerBlockEntity.class, ChargerBlockEntity::new, AEBlocks.CHARGER);
    public static final BlockEntityType<QuantumBridgeBlockEntity> QUANTUM_BRIDGE = AEBlockEntities.create("quantum_ring", QuantumBridgeBlockEntity.class, QuantumBridgeBlockEntity::new, AEBlocks.QUANTUM_RING, AEBlocks.QUANTUM_LINK);
    public static final BlockEntityType<SpatialPylonBlockEntity> SPATIAL_PYLON = AEBlockEntities.create("spatial_pylon", SpatialPylonBlockEntity.class, SpatialPylonBlockEntity::new, AEBlocks.SPATIAL_PYLON);
    public static final BlockEntityType<SpatialIOPortBlockEntity> SPATIAL_IO_PORT = AEBlockEntities.create("spatial_io_port", SpatialIOPortBlockEntity.class, SpatialIOPortBlockEntity::new, AEBlocks.SPATIAL_IO_PORT);
    public static final BlockEntityType<SpatialAnchorBlockEntity> SPATIAL_ANCHOR = AEBlockEntities.create("spatial_anchor", SpatialAnchorBlockEntity.class, SpatialAnchorBlockEntity::new, AEBlocks.SPATIAL_ANCHOR);
    public static final BlockEntityType<CableBusBlockEntity> CABLE_BUS = AEBlockEntities.create("cable_bus", CableBusBlockEntity.class, CableBusBlockEntity::new, AEBlocks.CABLE_BUS);
    public static final BlockEntityType<ControllerBlockEntity> CONTROLLER = AEBlockEntities.create("controller", ControllerBlockEntity.class, ControllerBlockEntity::new, AEBlocks.CONTROLLER);
    public static final BlockEntityType<DriveBlockEntity> DRIVE = AEBlockEntities.create("drive", DriveBlockEntity.class, DriveBlockEntity::new, AEBlocks.DRIVE);
    public static final BlockEntityType<ChestBlockEntity> CHEST = AEBlockEntities.create("chest", ChestBlockEntity.class, ChestBlockEntity::new, AEBlocks.CHEST);
    public static final BlockEntityType<InterfaceBlockEntity> INTERFACE = AEBlockEntities.create("interface", InterfaceBlockEntity.class, InterfaceBlockEntity::new, AEBlocks.INTERFACE);
    public static final BlockEntityType<CellWorkbenchBlockEntity> CELL_WORKBENCH = AEBlockEntities.create("cell_workbench", CellWorkbenchBlockEntity.class, CellWorkbenchBlockEntity::new, AEBlocks.CELL_WORKBENCH);
    public static final BlockEntityType<IOPortBlockEntity> IO_PORT = AEBlockEntities.create("io_port", IOPortBlockEntity.class, IOPortBlockEntity::new, AEBlocks.IO_PORT);
    public static final BlockEntityType<CondenserBlockEntity> CONDENSER = AEBlockEntities.create("condenser", CondenserBlockEntity.class, CondenserBlockEntity::new, AEBlocks.CONDENSER);
    public static final BlockEntityType<EnergyAcceptorBlockEntity> ENERGY_ACCEPTOR = AEBlockEntities.create("energy_acceptor", EnergyAcceptorBlockEntity.class, EnergyAcceptorBlockEntity::new, AEBlocks.ENERGY_ACCEPTOR);
    public static final BlockEntityType<VibrationChamberBlockEntity> VIBRATION_CHAMBER = AEBlockEntities.create("vibration_chamber", VibrationChamberBlockEntity.class, VibrationChamberBlockEntity::new, AEBlocks.VIBRATION_CHAMBER);
    public static final BlockEntityType<GrowthAcceleratorBlockEntity> GROWTH_ACCELERATOR = AEBlockEntities.create("growth_accelerator", GrowthAcceleratorBlockEntity.class, GrowthAcceleratorBlockEntity::new, AEBlocks.GROWTH_ACCELERATOR);
    public static final BlockEntityType<EnergyCellBlockEntity> ENERGY_CELL = AEBlockEntities.create("energy_cell", EnergyCellBlockEntity.class, EnergyCellBlockEntity::new, AEBlocks.ENERGY_CELL);
    public static final BlockEntityType<EnergyCellBlockEntity> DENSE_ENERGY_CELL = AEBlockEntities.create("dense_energy_cell", EnergyCellBlockEntity.class, EnergyCellBlockEntity::new, AEBlocks.DENSE_ENERGY_CELL);
    public static final BlockEntityType<CreativeEnergyCellBlockEntity> CREATIVE_ENERGY_CELL = AEBlockEntities.create("creative_energy_cell", CreativeEnergyCellBlockEntity.class, CreativeEnergyCellBlockEntity::new, AEBlocks.CREATIVE_ENERGY_CELL);
    public static final BlockEntityType<CraftingBlockEntity> CRAFTING_UNIT = AEBlockEntities.create("crafting_unit", CraftingBlockEntity.class, CraftingBlockEntity::new, AEBlocks.CRAFTING_UNIT, AEBlocks.CRAFTING_ACCELERATOR);
    public static final BlockEntityType<CraftingBlockEntity> CRAFTING_STORAGE = AEBlockEntities.create("crafting_storage", CraftingBlockEntity.class, CraftingBlockEntity::new, AEBlocks.CRAFTING_STORAGE_1K, AEBlocks.CRAFTING_STORAGE_4K, AEBlocks.CRAFTING_STORAGE_16K, AEBlocks.CRAFTING_STORAGE_64K, AEBlocks.CRAFTING_STORAGE_256K);
    public static final BlockEntityType<CraftingMonitorBlockEntity> CRAFTING_MONITOR = AEBlockEntities.create("crafting_monitor", CraftingMonitorBlockEntity.class, CraftingMonitorBlockEntity::new, AEBlocks.CRAFTING_MONITOR);
    public static final BlockEntityType<PatternProviderBlockEntity> PATTERN_PROVIDER = AEBlockEntities.create("pattern_provider", PatternProviderBlockEntity.class, PatternProviderBlockEntity::new, AEBlocks.PATTERN_PROVIDER);
    public static final BlockEntityType<MolecularAssemblerBlockEntity> MOLECULAR_ASSEMBLER = AEBlockEntities.create("molecular_assembler", MolecularAssemblerBlockEntity.class, MolecularAssemblerBlockEntity::new, AEBlocks.MOLECULAR_ASSEMBLER);
    public static final BlockEntityType<LightDetectorBlockEntity> LIGHT_DETECTOR = AEBlockEntities.create("light_detector", LightDetectorBlockEntity.class, LightDetectorBlockEntity::new, AEBlocks.LIGHT_DETECTOR);
    public static final BlockEntityType<PaintSplotchesBlockEntity> PAINT = AEBlockEntities.create("paint", PaintSplotchesBlockEntity.class, PaintSplotchesBlockEntity::new, AEBlocks.PAINT);
    public static final BlockEntityType<SkyChestBlockEntity> SKY_CHEST = AEBlockEntities.create("sky_chest", SkyChestBlockEntity.class, SkyChestBlockEntity::new, AEBlocks.SKY_STONE_CHEST, AEBlocks.SMOOTH_SKY_STONE_CHEST);
    public static final BlockEntityType<SkyStoneTankBlockEntity> SKY_STONE_TANK = AEBlockEntities.create("sky_tank", SkyStoneTankBlockEntity.class, SkyStoneTankBlockEntity::new, AEBlocks.SKY_STONE_TANK);
    public static final BlockEntityType<ItemGenBlockEntity> DEBUG_ITEM_GEN = AEBlockEntities.create("debug_item_gen", ItemGenBlockEntity.class, ItemGenBlockEntity::new, AEBlocks.DEBUG_ITEM_GEN);
    public static final BlockEntityType<ChunkLoaderBlockEntity> DEBUG_CHUNK_LOADER = AEBlockEntities.create("debug_chunk_loader", ChunkLoaderBlockEntity.class, ChunkLoaderBlockEntity::new, AEBlocks.DEBUG_CHUNK_LOADER);
    public static final BlockEntityType<PhantomNodeBlockEntity> DEBUG_PHANTOM_NODE = AEBlockEntities.create("debug_phantom_node", PhantomNodeBlockEntity.class, PhantomNodeBlockEntity::new, AEBlocks.DEBUG_PHANTOM_NODE);
    public static final BlockEntityType<CubeGeneratorBlockEntity> DEBUG_CUBE_GEN = AEBlockEntities.create("debug_cube_gen", CubeGeneratorBlockEntity.class, CubeGeneratorBlockEntity::new, AEBlocks.DEBUG_CUBE_GEN);
    public static final BlockEntityType<EnergyGeneratorBlockEntity> DEBUG_ENERGY_GEN = AEBlockEntities.create("debug_energy_gen", EnergyGeneratorBlockEntity.class, EnergyGeneratorBlockEntity::new, AEBlocks.DEBUG_ENERGY_GEN);
    public static final BlockEntityType<CrankBlockEntity> CRANK = AEBlockEntities.create("crank", CrankBlockEntity.class, CrankBlockEntity::new, AEBlocks.CRANK);

    private AEBlockEntities() {
    }

    public static Map<ResourceLocation, BlockEntityType<?>> getBlockEntityTypes() {
        return ImmutableMap.copyOf(BLOCK_ENTITY_TYPES);
    }

    @SafeVarargs
    private static <T extends AEBaseBlockEntity> BlockEntityType<T> create(String shortId, Class<T> entityClass, BlockEntityFactory<T> factory, BlockDefinition<? extends AEBaseEntityBlock<?>> ... blockDefinitions) {
        Preconditions.checkArgument((blockDefinitions.length > 0 ? 1 : 0) != 0);
        ResourceLocation id = AppEng.makeId(shortId);
        Block[] blocks = (AEBaseEntityBlock[])Arrays.stream(blockDefinitions).map(BlockDefinition::block).toArray(AEBaseEntityBlock[]::new);
        AtomicReference<BlockEntityType> typeHolder = new AtomicReference<BlockEntityType>();
        BlockEntityType.BlockEntitySupplier supplier = (blockPos, blockState) -> factory.create((BlockEntityType)typeHolder.get(), blockPos, blockState);
        BlockEntityType type = BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)supplier, (Block[])blocks).m_58966_(null);
        typeHolder.set(type);
        BLOCK_ENTITY_TYPES.put(id, type);
        AEBaseBlockEntity.registerBlockEntityItem(type, blockDefinitions[0].m_5456_());
        BlockEntityTicker serverTicker = null;
        if (ServerTickingBlockEntity.class.isAssignableFrom(entityClass)) {
            serverTicker = (level, pos, state, entity) -> ((ServerTickingBlockEntity)((Object)entity)).serverTick();
        }
        BlockEntityTicker clientTicker = null;
        if (ClientTickingBlockEntity.class.isAssignableFrom(entityClass)) {
            clientTicker = (level, pos, state, entity) -> ((ClientTickingBlockEntity)((Object)entity)).clientTick();
        }
        Block[] blockArray = blocks;
        int n = blockArray.length;
        for (int i = 0; i < n; ++i) {
            Block block;
            Block baseBlock = block = blockArray[i];
            baseBlock.setBlockEntity(entityClass, type, clientTicker, serverTicker);
        }
        return type;
    }

    @FunctionalInterface
    static interface BlockEntityFactory<T extends AEBaseBlockEntity> {
        public T create(BlockEntityType<T> var1, BlockPos var2, BlockState var3);
    }
}

