/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.me.common;

import appeng.api.behaviors.ContainerItemStrategies;
import appeng.api.behaviors.EmptyingAction;
import appeng.api.client.AEKeyRendering;
import appeng.api.config.ActionItems;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.TerminalStyle;
import appeng.api.config.TypeFilter;
import appeng.api.config.ViewItems;
import appeng.api.implementations.blockentities.IMEChest;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AmountFormat;
import appeng.api.storage.AEKeyFilter;
import appeng.api.util.IConfigManager;
import appeng.api.util.IConfigurableObject;
import appeng.client.Hotkey;
import appeng.client.Hotkeys;
import appeng.client.Point;
import appeng.client.gui.AEBaseScreen;
import appeng.client.gui.AESubScreen;
import appeng.client.gui.Icon;
import appeng.client.gui.me.common.PendingCraftingJobs;
import appeng.client.gui.me.common.PinnedKeys;
import appeng.client.gui.me.common.Repo;
import appeng.client.gui.me.common.RepoSlot;
import appeng.client.gui.me.common.StackSizeRenderer;
import appeng.client.gui.me.common.TerminalSettingsScreen;
import appeng.client.gui.style.Blitter;
import appeng.client.gui.style.ScreenStyle;
import appeng.client.gui.widgets.AETextField;
import appeng.client.gui.widgets.ActionButton;
import appeng.client.gui.widgets.ISortSource;
import appeng.client.gui.widgets.Scrollbar;
import appeng.client.gui.widgets.SettingToggleButton;
import appeng.client.gui.widgets.TabButton;
import appeng.client.gui.widgets.ToolboxPanel;
import appeng.client.gui.widgets.UpgradesPanel;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.localization.ButtonToolTips;
import appeng.core.localization.GuiText;
import appeng.core.localization.Tooltips;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.ConfigValuePacket;
import appeng.core.sync.packets.MEInteractionPacket;
import appeng.core.sync.packets.SwitchGuisPacket;
import appeng.helpers.InventoryAction;
import appeng.items.storage.ViewCellItem;
import appeng.menu.AEBaseMenu;
import appeng.menu.SlotSemantics;
import appeng.menu.me.common.GridInventoryEntry;
import appeng.menu.me.common.MEStorageMenu;
import appeng.menu.me.crafting.CraftingStatusMenu;
import appeng.util.ExternalSearch;
import appeng.util.IConfigManagerListener;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MEStorageScreen<C extends MEStorageMenu>
extends AEBaseScreen<C>
implements ISortSource,
IConfigManagerListener {
    private static final Logger LOG = LoggerFactory.getLogger(MEStorageScreen.class);
    private static final String TEXT_ID_ENTRIES_SHOWN = "entriesShown";
    private static final int MIN_ROWS = 2;
    private static String rememberedSearch = "";
    private final appeng.client.gui.style.TerminalStyle style;
    protected final Repo repo;
    private final List<ItemStack> currentViewCells = new ArrayList<ItemStack>();
    private final IConfigManager configSrc;
    private final boolean supportsViewCells;
    private TabButton craftingStatusBtn;
    private final AETextField searchField;
    private int rows = 0;
    private SettingToggleButton<ViewItems> viewModeToggle;
    private SettingToggleButton<TypeFilter> filterTypesToggle;
    private SettingToggleButton<SortOrder> sortByToggle;
    private final SettingToggleButton<SortDir> sortDirToggle;
    private int currentMouseX = 0;
    private int currentMouseY = 0;
    private final Scrollbar scrollbar;

    public MEStorageScreen(C menu, Inventory playerInventory, Component title, ScreenStyle style) {
        super(menu, playerInventory, title, style);
        this.style = style.getTerminalStyle();
        if (this.style == null) {
            throw new IllegalStateException("Cannot construct screen " + this.getClass() + " without a terminalStyles setting");
        }
        this.searchField = this.widgets.addTextField("search");
        this.searchField.setPlaceholder((Component)GuiText.SearchPlaceholder.text());
        this.scrollbar = this.widgets.addScrollBar("scrollbar");
        this.repo = new Repo(this.scrollbar, this);
        ((MEStorageMenu)menu).setClientRepo(this.repo);
        this.repo.setUpdateViewListener(this::updateScrollbar);
        this.updateScrollbar();
        this.searchField.m_94151_(this::setSearchText);
        this.f_97726_ = this.style.getScreenWidth();
        this.f_97727_ = this.style.getScreenHeight(0);
        this.configSrc = ((IConfigurableObject)this.f_97732_).getConfigManager();
        ((MEStorageMenu)this.f_97732_).setGui(this);
        List<Slot> viewCellSlots = ((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.VIEW_CELL);
        boolean bl = this.supportsViewCells = !viewCellSlots.isEmpty();
        if (this.supportsViewCells) {
            List<MutableComponent> tooltip = Collections.singletonList(GuiText.TerminalViewCellsTooltip.text());
            this.widgets.add("viewCells", new UpgradesPanel(viewCellSlots, () -> tooltip));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.craftingStatusBtn = new TabButton(Icon.CRAFT_HAMMER, (Component)GuiText.CraftingStatus.text(), btn -> this.showCraftingStatus());
            this.craftingStatusBtn.setStyle(TabButton.Style.CORNER);
            this.widgets.add("craftingStatus", (AbstractWidget)this.craftingStatusBtn);
        }
        if (this.style.isSortable()) {
            this.sortByToggle = this.addToLeftToolbar(new SettingToggleButton<SortOrder>(Settings.SORT_BY, this.getSortBy(), Platform::isSortOrderAvailable, this::toggleServerSetting));
        }
        if (this.style.isSupportsAutoCrafting()) {
            this.viewModeToggle = this.addToLeftToolbar(new SettingToggleButton<ViewItems>(Settings.VIEW_MODE, this.getSortDisplay(), this::toggleServerSetting));
        }
        if (((MEStorageMenu)this.f_97732_).canConfigureTypeFilter()) {
            this.filterTypesToggle = this.addToLeftToolbar(new SettingToggleButton<TypeFilter>(Settings.TYPE_FILTER, this.getTypeFilter(), this::toggleServerSetting));
        }
        this.sortDirToggle = new SettingToggleButton<SortDir>(Settings.SORT_DIRECTION, this.getSortDir(), this::toggleServerSetting);
        this.addToLeftToolbar(this.sortDirToggle);
        this.addToLeftToolbar(new ActionButton(ActionItems.TERMINAL_SETTINGS, this::showSettings));
        TerminalStyle terminalStyle = this.config.getTerminalStyle();
        this.addToLeftToolbar(new SettingToggleButton<TerminalStyle>(Settings.TERMINAL_STYLE, terminalStyle, this::toggleTerminalStyle));
        this.widgets.add("upgrades", new UpgradesPanel(((AEBaseMenu)((Object)menu)).getSlots(SlotSemantics.UPGRADE), ((MEStorageMenu)menu).getHost()));
        if (((MEStorageMenu)menu).getToolbox().isPresent()) {
            this.widgets.add("toolbox", new ToolboxPanel(style, ((MEStorageMenu)menu).getToolbox().getName()));
        }
        if ((((AEBaseMenu)((Object)menu)).isReturnedFromSubScreen() || this.config.isRememberLastSearch()) && rememberedSearch != null && !rememberedSearch.isEmpty()) {
            this.searchField.m_94144_(rememberedSearch);
            this.searchField.selectAll();
            this.setSearchText(rememberedSearch);
        }
        if (!((AEBaseMenu)((Object)menu)).isReturnedFromSubScreen() && this.config.isUseExternalSearch() && this.config.isClearExternalSearchOnOpen()) {
            ExternalSearch.clearExternalSearchText();
        }
    }

    private void showSettings() {
        this.switchToScreen(new TerminalSettingsScreen(this));
    }

    @Nullable
    protected IPartitionList createPartitionList(List<ItemStack> viewCells) {
        return ViewCellItem.createFilter(AEKeyFilter.none(), viewCells);
    }

    protected void handleGridInventoryEntryMouseClick(@Nullable GridInventoryEntry entry, int mouseButton, ClickType clickType) {
        EmptyingAction emptyingAction;
        if (entry != null) {
            AELog.debug("Clicked on grid inventory entry serial=%s, key=%s", entry.getSerial(), entry.getWhat());
        }
        if (mouseButton == 1 && clickType == ClickType.PICKUP && !((MEStorageMenu)this.f_97732_).m_142621_().m_41619_() && (emptyingAction = ContainerItemStrategies.getEmptyingAction(((MEStorageMenu)this.f_97732_).m_142621_())) != null && ((MEStorageMenu)this.f_97732_).isKeyVisible(emptyingAction.what())) {
            ((MEStorageMenu)this.f_97732_).handleInteraction(-1L, InventoryAction.EMPTY_ITEM);
            return;
        }
        if (entry == null) {
            if (clickType == ClickType.PICKUP && !((MEStorageMenu)this.m_6262_()).m_142621_().m_41619_()) {
                InventoryAction action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                ((MEStorageMenu)this.f_97732_).handleInteraction(-1L, action);
            }
            return;
        }
        long serial = entry.getSerial();
        if (InputConstants.m_84830_((long)Minecraft.m_91087_().m_91268_().m_85439_(), (int)32)) {
            ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.MOVE_REGION);
        } else {
            InventoryAction action = null;
            switch (clickType) {
                case PICKUP: {
                    InventoryAction inventoryAction = action = mouseButton == 1 ? InventoryAction.SPLIT_OR_PLACE_SINGLE : InventoryAction.PICKUP_OR_SET_DOWN;
                    if (action != InventoryAction.PICKUP_OR_SET_DOWN || !this.shouldCraftOnClick(entry) || !((MEStorageMenu)this.m_6262_()).m_142621_().m_41619_()) break;
                    ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                    return;
                }
                case QUICK_MOVE: {
                    action = mouseButton == 1 ? InventoryAction.PICKUP_SINGLE : InventoryAction.SHIFT_CLICK;
                    break;
                }
                case CLONE: {
                    if (entry.isCraftable()) {
                        ((MEStorageMenu)this.f_97732_).handleInteraction(serial, InventoryAction.AUTO_CRAFT);
                        return;
                    }
                    if (!((MEStorageMenu)this.m_6262_()).getPlayer().m_150110_().f_35937_) break;
                    action = InventoryAction.CREATIVE_DUPLICATE;
                    break;
                }
            }
            if (action != null) {
                ((MEStorageMenu)this.f_97732_).handleInteraction(serial, action);
            }
        }
    }

    private boolean shouldCraftOnClick(GridInventoryEntry entry) {
        if (this.isViewOnlyCraftable()) {
            return true;
        }
        return entry.getStoredAmount() == 0L && entry.isCraftable();
    }

    private void updateScrollbar() {
        this.scrollbar.setHeight(this.rows * this.style.getRow().getSrcHeight() - 2);
        int totalRows = (this.repo.size() + this.getSlotsPerRow() - 1) / this.getSlotsPerRow();
        if (this.repo.hasPinnedRow()) {
            ++totalRows;
        }
        this.scrollbar.setRange(0, totalRows - this.rows, Math.max(1, this.rows / 6));
    }

    private void showCraftingStatus() {
        NetworkHandler.instance().sendToServer(SwitchGuisPacket.openSubMenu(CraftingStatusMenu.TYPE));
    }

    private int getSlotsPerRow() {
        return this.style.getSlotsPerRow();
    }

    @Override
    public void m_7856_() {
        int availableHeight = this.f_96544_ - 2 * AEConfig.instance().getTerminalMargin();
        this.rows = Math.max(2, this.config.getTerminalStyle().getRows(this.style.getPossibleRows(availableHeight)));
        this.f_97727_ = this.style.getScreenHeight(this.rows);
        NonNullList slots = ((MEStorageMenu)this.f_97732_).f_38839_;
        slots.removeIf(slot -> slot instanceof RepoSlot);
        int repoIndex = 0;
        for (int row = 0; row < this.rows; ++row) {
            for (int col = 0; col < this.style.getSlotsPerRow(); ++col) {
                Point pos = this.style.getSlotPos(row, col);
                slots.add(new RepoSlot(this.repo, repoIndex++, pos.getX(), pos.getY()));
            }
        }
        super.m_7856_();
        if (this.shouldAutoFocus()) {
            this.m_264313_((GuiEventListener)this.searchField);
        }
        this.updateScrollbar();
    }

    @Override
    protected void updateBeforeRender() {
        super.updateBeforeRender();
        this.repo.setPaused(MEStorageScreen.m_96638_());
        this.updateSearch();
        if (!this.f_96539_.getString().isEmpty()) {
            this.setTextContent("dialog_title", this.f_96539_);
        } else if (((MEStorageMenu)this.f_97732_).getTarget() instanceof IMEChest) {
            this.setTextContent("dialog_title", (Component)GuiText.Chest.text());
        }
    }

    private void updateSearch() {
        if (this.config.isUseExternalSearch()) {
            int visibleEntries;
            int allEntries;
            this.searchField.m_94194_(false);
            String externalSearchText = ExternalSearch.getExternalSearchText();
            if (!Objects.equals(this.repo.getSearchString(), externalSearchText)) {
                this.setSearchText(externalSearchText);
            }
            if ((allEntries = this.repo.getAllEntries().size()) != (visibleEntries = this.repo.size())) {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, false);
                this.setTextContent(TEXT_ID_ENTRIES_SHOWN, (Component)GuiText.ShowingOf.text(visibleEntries, allEntries));
            } else {
                this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
            }
        } else {
            this.searchField.m_94194_(true);
            this.setTextHidden(TEXT_ID_ENTRIES_SHOWN, true);
            this.searchField.setTooltipMessage(List.of(this.config.isSearchTooltips() ? GuiText.SearchTooltipIncludingTooltips.text() : GuiText.SearchTooltip.text(), GuiText.SearchTooltipModId.text(), GuiText.SearchTooltipItemId.text(), GuiText.SearchTooltipTag.text()));
            if (this.config.isSyncWithExternalSearch()) {
                String externalSearchText;
                if (this.searchField.m_93696_()) {
                    ExternalSearch.setExternalSearchText(this.searchField.m_94155_());
                } else if (ExternalSearch.isExternalSearchFocused() && !Objects.equals(externalSearchText = ExternalSearch.getExternalSearchText(), this.searchField.m_94155_())) {
                    this.searchField.m_94144_(externalSearchText);
                }
            }
        }
    }

    @Override
    protected <P extends AEBaseScreen<C>> void onReturnFromSubScreen(AESubScreen<C, P> subScreen) {
        if (subScreen instanceof TerminalSettingsScreen) {
            this.reinitalize();
            if (!this.config.isUseExternalSearch()) {
                this.setSearchText(this.searchField.m_94155_());
            }
        }
    }

    @Override
    public void drawFG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY) {
        this.currentMouseX = mouseX;
        this.currentMouseY = mouseY;
        if (this.repo.hasPinnedRow()) {
            this.renderPinnedRowDecorations(guiGraphics);
        }
        if (this.craftingStatusBtn != null && ((MEStorageMenu)this.f_97732_).activeCraftingJobs != -1) {
            int x = this.craftingStatusBtn.m_252754_() + (this.craftingStatusBtn.m_5711_() - 16) / 2;
            int y = this.craftingStatusBtn.m_252907_() + (this.craftingStatusBtn.m_93694_() - 16) / 2;
            StackSizeRenderer.renderSizeLabel(guiGraphics, this.f_96547_, x - this.f_97735_, y - this.f_97736_, String.valueOf(((MEStorageMenu)this.f_97732_).activeCraftingJobs));
        }
    }

    private void renderPinnedRowDecorations(GuiGraphics guiGraphics) {
        for (Slot slot : ((MEStorageMenu)this.f_97732_).f_38839_) {
            RepoSlot repoSlot;
            GridInventoryEntry entry;
            if (!(slot instanceof RepoSlot) || (entry = (repoSlot = (RepoSlot)slot).getEntry()) == null || !PendingCraftingJobs.hasPendingJob(entry.getWhat())) continue;
            int frames = 12;
            int frame = (int)(System.currentTimeMillis() / 100L % (long)frames);
            Blitter.texture("block/molecular_assembler_lights.png", 16, 192).src(2, 2 + frame * 16, 12, 12).dest(slot.f_40220_ - 1, slot.f_40221_ - 1, 18, 18).blit(guiGraphics);
        }
    }

    @Override
    public boolean m_6375_(double xCoord, double yCoord, int btn) {
        RepoSlot repoSlot;
        Slot slot;
        if (this.searchField.m_5953_(xCoord, yCoord) && btn == 1) {
            this.searchField.m_94144_("");
            this.setSearchText("");
        }
        if (Minecraft.m_91087_().f_91066_.f_92097_.m_90830_(btn) && (slot = this.m_97744_(xCoord, yCoord)) instanceof RepoSlot && (repoSlot = (RepoSlot)slot).isCraftable()) {
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), btn, ClickType.CLONE);
            return true;
        }
        return super.m_6375_(xCoord, yCoord, btn);
    }

    @Override
    public boolean m_6050_(double x, double y, double wheelDelta) {
        Slot slot;
        if (wheelDelta != 0.0 && MEStorageScreen.m_96638_() && (slot = this.m_97744_(x, y)) instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            GridInventoryEntry entry = repoSlot.getEntry();
            long serial = entry != null ? entry.getSerial() : -1L;
            InventoryAction direction = wheelDelta > 0.0 ? InventoryAction.ROLL_DOWN : InventoryAction.ROLL_UP;
            int times = (int)Math.abs(wheelDelta);
            for (int h = 0; h < times; ++h) {
                MEInteractionPacket p = new MEInteractionPacket(((MEStorageMenu)this.f_97732_).f_38840_, serial, direction);
                NetworkHandler.instance().sendToServer(p);
            }
            return true;
        }
        return super.m_6050_(x, y, wheelDelta);
    }

    @Override
    protected void m_6597_(Slot slot, int slotIdx, int mouseButton, ClickType clickType) {
        if (slot instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)slot;
            this.handleGridInventoryEntryMouseClick(repoSlot.getEntry(), mouseButton, clickType);
            return;
        }
        super.m_6597_(slot, slotIdx, mouseButton, clickType);
    }

    public void m_7861_() {
        super.m_7861_();
        this.storeState();
        for (GridInventoryEntry entry : this.repo.getPinnedEntries()) {
            PinnedKeys.PinInfo info = PinnedKeys.getPinInfo(entry.getWhat());
            if (info == null || info.reason != PinnedKeys.PinReason.CRAFTING || PendingCraftingJobs.hasPendingJob(entry.getWhat())) continue;
            info.canPrune = true;
        }
    }

    @Override
    public void drawBG(GuiGraphics guiGraphics, int offsetX, int offsetY, int mouseX, int mouseY, float partialTicks) {
        this.style.getHeader().dest(offsetX, offsetY).blit(guiGraphics);
        int y = offsetY;
        this.style.getHeader().dest(offsetX, y).blit(guiGraphics);
        y += this.style.getHeader().getSrcHeight();
        int rowsToDraw = Math.max(2, this.rows);
        for (int x = 0; x < rowsToDraw; ++x) {
            Blitter row = this.style.getRow();
            if (x == 0) {
                row = this.style.getFirstRow();
            } else if (x + 1 == rowsToDraw) {
                row = this.style.getLastRow();
            }
            row.dest(offsetX, y).blit(guiGraphics);
            y += this.style.getRow().getSrcHeight();
        }
        this.style.getBottom().dest(offsetX, y).blit(guiGraphics);
        if (this.repo.hasPinnedRow()) {
            Blitter.texture("guis/terminal.png").src(0, 204, 162, 18).dest(offsetX + 7, offsetY + this.style.getHeader().getSrcHeight()).blit(guiGraphics);
        }
        if (this.searchField != null) {
            this.searchField.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void m_280092_(GuiGraphics guiGraphics, Slot s) {
        if (s instanceof RepoSlot) {
            RepoSlot repoSlot = (RepoSlot)s;
            if (!this.repo.hasPower()) {
                guiGraphics.m_280509_(s.f_40220_, s.f_40221_, 16 + s.f_40220_, 16 + s.f_40221_, 0x66111111);
            } else {
                GridInventoryEntry entry = repoSlot.getEntry();
                if (entry != null) {
                    try {
                        AEKeyRendering.drawInGui(this.f_96541_, guiGraphics, s.f_40220_, s.f_40221_, entry.getWhat());
                    }
                    catch (Exception err) {
                        AELog.warn("[AppEng] AE prevented crash while drawing slot: " + err, new Object[0]);
                    }
                    long storedAmount = entry.getStoredAmount();
                    boolean craftable = entry.isCraftable();
                    boolean useLargeFonts = this.config.isUseLargeFonts();
                    if (craftable && (this.isViewOnlyCraftable() || storedAmount <= 0L)) {
                        String craftLabelText = useLargeFonts ? GuiText.LargeFontCraft.getLocal() : GuiText.SmallFontCraft.getLocal();
                        StackSizeRenderer.renderSizeLabel(guiGraphics, this.f_96547_, s.f_40220_, s.f_40221_, craftLabelText);
                    } else {
                        AmountFormat format = useLargeFonts ? AmountFormat.SLOT_LARGE_FONT : AmountFormat.SLOT;
                        String text = entry.getWhat().formatAmount(storedAmount, format);
                        StackSizeRenderer.renderSizeLabel(guiGraphics, this.f_96547_, (float)s.f_40220_, (float)s.f_40221_, text, useLargeFonts);
                        if (craftable) {
                            StackSizeRenderer.renderSizeLabel(guiGraphics, this.f_96547_, (float)(s.f_40220_ - 11), (float)(s.f_40221_ - 11), "+", false);
                        }
                    }
                }
            }
            return;
        }
        super.m_280092_(guiGraphics, s);
    }

    protected final boolean isViewOnlyCraftable() {
        return this.viewModeToggle != null && this.viewModeToggle.getCurrentValue() == ViewItems.CRAFTABLE;
    }

    protected void m_280072_(GuiGraphics guiGraphics, int x, int y) {
        Slot slot = this.f_97734_;
        if (slot instanceof RepoSlot) {
            GridInventoryEntry entry;
            EmptyingAction emptyingAction;
            RepoSlot repoSlot = (RepoSlot)slot;
            ItemStack carried = ((MEStorageMenu)this.f_97732_).m_142621_();
            if (!carried.m_41619_() && (emptyingAction = ContainerItemStrategies.getEmptyingAction(carried)) != null && ((MEStorageMenu)this.f_97732_).isKeyVisible(emptyingAction.what())) {
                this.drawTooltip(guiGraphics, x, y, Tooltips.getEmptyingTooltip(ButtonToolTips.StoreAction, carried, emptyingAction));
                return;
            }
            if (carried.m_41619_() && (entry = repoSlot.getEntry()) != null) {
                this.renderGridInventoryEntryTooltip(guiGraphics, entry, x, y);
            }
            return;
        }
        super.m_280072_(guiGraphics, x, y);
    }

    protected void renderGridInventoryEntryTooltip(GuiGraphics guiGraphics, GridInventoryEntry entry, int x, int y) {
        AEKey aEKey;
        long requestableAmount;
        List<Component> currentToolTip = AEKeyRendering.getTooltip(entry.getWhat());
        if (Tooltips.shouldShowAmountTooltip(entry.getWhat(), entry.getStoredAmount())) {
            currentToolTip.add(Tooltips.getAmountTooltip(ButtonToolTips.StoredAmount, entry.getWhat(), entry.getStoredAmount()));
        }
        if ((requestableAmount = entry.getRequestableAmount()) > 0L) {
            String formattedAmount = entry.getWhat().formatAmount(requestableAmount, AmountFormat.FULL);
            currentToolTip.add((Component)ButtonToolTips.RequestableAmount.text(formattedAmount));
        }
        if (entry.isCraftable() && !this.isViewOnlyCraftable() && entry.getStoredAmount() > 0L) {
            currentToolTip.add((Component)ButtonToolTips.Craftable.text().m_6881_().m_130940_(ChatFormatting.DARK_GRAY));
        }
        if (Minecraft.m_91087_().f_91066_.f_92125_) {
            currentToolTip.add((Component)ButtonToolTips.Serial.text(entry.getSerial()).m_130940_(ChatFormatting.DARK_GRAY));
        }
        if ((aEKey = entry.getWhat()) instanceof AEItemKey) {
            AEItemKey itemKey = (AEItemKey)aEKey;
            ItemStack stack = itemKey.toStack();
            guiGraphics.renderTooltip(this.f_96547_, currentToolTip, stack.m_150921_(), stack, x, y);
        } else {
            guiGraphics.m_280666_(this.f_96547_, currentToolTip, x, y);
        }
    }

    public boolean m_5534_(char character, int modifiers) {
        if (character == ' ' && this.searchField.m_94155_().isEmpty()) {
            return true;
        }
        return super.m_5534_(character, modifiers);
    }

    private boolean shouldAutoFocus() {
        return this.config.isAutoFocusSearch() && !this.config.isUseExternalSearch();
    }

    public boolean m_7933_(int keyCode, int scanCode, int p_keyPressed_3_) {
        if (this.searchField.m_93696_() && keyCode == 257) {
            this.searchField.m_93692_(false);
            this.m_7522_(null);
            return true;
        }
        if (!this.searchField.m_93696_() && this.isCloseHotkey(keyCode, scanCode)) {
            this.getPlayer().m_6915_();
            return true;
        }
        return super.m_7933_(keyCode, scanCode, p_keyPressed_3_);
    }

    private boolean isHovered() {
        return this.m_6774_(0, 0, this.f_97726_, this.f_97727_, this.currentMouseX, this.currentMouseY);
    }

    @Override
    public void m_181908_() {
        List<ItemStack> viewCells;
        this.repo.setPower(((MEStorageMenu)this.f_97732_).isPowered());
        if (this.supportsViewCells && !this.currentViewCells.equals(viewCells = ((MEStorageMenu)this.f_97732_).getViewCells())) {
            this.currentViewCells.clear();
            this.currentViewCells.addAll(viewCells);
            this.repo.setPartitionList(this.createPartitionList(viewCells));
        }
        super.m_181908_();
    }

    @Override
    public SortOrder getSortBy() {
        return this.configSrc.getSetting(Settings.SORT_BY);
    }

    @Override
    public SortDir getSortDir() {
        return this.configSrc.getSetting(Settings.SORT_DIRECTION);
    }

    @Override
    public ViewItems getSortDisplay() {
        return this.configSrc.getSetting(Settings.VIEW_MODE);
    }

    @Override
    public TypeFilter getTypeFilter() {
        return this.configSrc.getSetting(Settings.TYPE_FILTER);
    }

    @Override
    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        if (this.sortByToggle != null) {
            this.sortByToggle.set(this.getSortBy());
        }
        if (this.sortDirToggle != null) {
            this.sortDirToggle.set(this.getSortDir());
        }
        if (this.viewModeToggle != null) {
            this.viewModeToggle.set(this.getSortDisplay());
        }
        if (this.filterTypesToggle != null) {
            this.filterTypesToggle.set(this.getTypeFilter());
        }
        this.repo.updateView();
    }

    private void toggleTerminalStyle(SettingToggleButton<TerminalStyle> btn, boolean backwards) {
        TerminalStyle next = btn.getNextValue(backwards);
        this.config.setTerminalStyle(next);
        btn.set(next);
        this.reinitalize();
    }

    private <SE extends Enum<SE>> void toggleServerSetting(SettingToggleButton<SE> btn, boolean backwards) {
        SE next = btn.getNextValue(backwards);
        NetworkHandler.instance().sendToServer(new ConfigValuePacket(btn.getSetting(), next));
        btn.set(next);
    }

    private void setSearchText(String text) {
        this.repo.setSearchString(text);
        this.repo.updateView();
        this.updateScrollbar();
    }

    private void reinitalize() {
        this.storeState();
        new ArrayList<GuiEventListener>(this.m_6702_()).forEach(x$0 -> this.m_169411_((GuiEventListener)x$0));
        this.m_7856_();
    }

    private boolean isCloseHotkey(int keyCode, int scanCode) {
        String hotkeyId = ((MEStorageMenu)this.m_6262_()).getHost().getCloseHotkey();
        if (hotkeyId != null) {
            Hotkey hotkey = Hotkeys.getHotkeyMapping(hotkeyId);
            if (hotkey != null) {
                return hotkey.mapping().m_90832_(keyCode, scanCode);
            }
            LOG.warn("Terminal host returned unknown hotkey id: {}", (Object)hotkeyId);
        }
        return false;
    }

    public void storeState() {
        rememberedSearch = this.searchField.m_94155_();
    }
}

