/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Optional;
import java.util.Stack;

public class MathExpressionParser {
    public static Optional<BigDecimal> parse(String expression, DecimalFormat decimalFormat) {
        ArrayList<Comparable<BigDecimal>> output = new ArrayList<Comparable<BigDecimal>>();
        Stack<Character> operatorStack = new Stack<Character>();
        boolean wasNumberOrRightBracket = false;
        int i = 0;
        while (i < expression.length()) {
            char currentOperator;
            if (Character.isWhitespace(expression.charAt(i))) {
                ++i;
                continue;
            }
            if (!wasNumberOrRightBracket || expression.charAt(i) != '-') {
                ParsePosition position = new ParsePosition(i);
                BigDecimal bigDecimal = (BigDecimal)decimalFormat.parse(expression, position);
                if (position.getErrorIndex() == -1) {
                    output.add(bigDecimal);
                    i = position.getIndex();
                    wasNumberOrRightBracket = true;
                    continue;
                }
            }
            if ((currentOperator = expression.charAt(i)) == '-' && !wasNumberOrRightBracket) {
                currentOperator = 'u';
            }
            wasNumberOrRightBracket = false;
            switch (currentOperator) {
                case '(': 
                case 'u': {
                    operatorStack.push(Character.valueOf(currentOperator));
                    break;
                }
                case ')': {
                    while (true) {
                        if (operatorStack.isEmpty()) {
                            return Optional.empty();
                        }
                        char c = ((Character)operatorStack.pop()).charValue();
                        if (c == '(') break;
                        output.add(Character.valueOf(c));
                    }
                    wasNumberOrRightBracket = true;
                    break;
                }
                case '*': 
                case '+': 
                case '-': 
                case '/': {
                    char c;
                    while (!operatorStack.isEmpty() && (c = ((Character)operatorStack.peek()).charValue()) != '(' && MathExpressionParser.precedenceCheck(c, currentOperator)) {
                        operatorStack.pop();
                        output.add(Character.valueOf(c));
                    }
                    operatorStack.push(Character.valueOf(currentOperator));
                    break;
                }
                default: {
                    return Optional.empty();
                }
            }
            ++i;
        }
        while (!operatorStack.isEmpty()) {
            output.add((Comparable<BigDecimal>)operatorStack.pop());
        }
        Stack<BigDecimal> number = new Stack<BigDecimal>();
        for (Object e : output) {
            if (e instanceof BigDecimal) {
                BigDecimal bigDecimal = (BigDecimal)e;
                number.push(bigDecimal);
                continue;
            }
            char currentOperator = ((Character)e).charValue();
            if (currentOperator != 'u') {
                if (number.size() < 2) {
                    return Optional.empty();
                }
                BigDecimal right = (BigDecimal)number.pop();
                BigDecimal left = (BigDecimal)number.pop();
                switch (currentOperator) {
                    case '+': {
                        number.push(right.add(left));
                        break;
                    }
                    case '*': {
                        number.push(right.multiply(left));
                        break;
                    }
                    case '-': {
                        number.push(left.subtract(right));
                        break;
                    }
                    case '/': {
                        if (right.equals(BigDecimal.ZERO)) {
                            return Optional.empty();
                        }
                        number.push(left.divide(right, 8, RoundingMode.FLOOR));
                        break;
                    }
                    case '(': 
                    case ')': {
                        return Optional.empty();
                    }
                    default: {
                        throw new IllegalStateException("Unreachable character : " + currentOperator);
                    }
                }
                continue;
            }
            if (number.isEmpty()) {
                return Optional.empty();
            }
            number.push(((BigDecimal)number.pop()).negate());
        }
        if (number.size() != 1) {
            return Optional.empty();
        }
        return Optional.of((BigDecimal)number.pop());
    }

    private static int getPrecedence(char operator) {
        return switch (operator) {
            case 'u' -> 0;
            case '*', '/' -> 1;
            case '+', '-' -> 2;
            default -> throw new IllegalArgumentException("Invalid Operator : " + operator);
        };
    }

    private static boolean precedenceCheck(char first, char second) {
        return MathExpressionParser.getPrecedence(first) <= MathExpressionParser.getPrecedence(second);
    }
}

