/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear.events;

import io.redspace.allthewizardgear.item.ExtendedArmorMaterials;
import io.redspace.allthewizardgear.item.WizardArmorItem;
import java.util.function.Function;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ServerEvents {
    @SubscribeEvent
    public static void onPlayerFall(LivingFallEvent event) {
        WizardArmorItem armorItem;
        Item item = event.getEntity().m_6844_(EquipmentSlot.FEET).m_41720_();
        if (item instanceof WizardArmorItem && (armorItem = (WizardArmorItem)item).getMaterial().bootsPreventFallDamage()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingAttackEvent event) {
        if (!event.getEntity().m_20193_().f_46443_) {
            DamageSources damageSources = event.getEntity().m_269291_();
            ItemStack helmet = event.getEntity().m_6844_(EquipmentSlot.HEAD);
            ItemStack chestplate = event.getEntity().m_6844_(EquipmentSlot.CHEST);
            ItemStack leggings = event.getEntity().m_6844_(EquipmentSlot.LEGS);
            if (event.getSource() == damageSources.m_269515_() && ServerEvents.checkItem(helmet, ExtendedArmorMaterials::helmetPreventsElytraDamage)) {
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.m_269063_() && ServerEvents.checkItem(helmet, ExtendedArmorMaterials::helmetPreventsDrowning)) {
                event.getEntity().m_20301_(event.getEntity().m_6062_());
                event.setCanceled(true);
            } else if (event.getSource().m_269533_(DamageTypeTags.f_268745_) && ServerEvents.checkItem(chestplate, ExtendedArmorMaterials::chestplatePreventsFire)) {
                event.getEntity().m_20095_();
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.m_269254_() && ServerEvents.checkItem(chestplate, ExtendedArmorMaterials::chestplatePreventsDragonBreath)) {
                event.setCanceled(true);
            } else if (event.getSource() == damageSources.m_269251_() && ServerEvents.checkItem(leggings, ExtendedArmorMaterials::leggingsPreventWither)) {
                event.getEntity().m_21195_(MobEffects.f_19615_);
                event.setCanceled(true);
            } else if (ServerEvents.checkItem(leggings, ExtendedArmorMaterials::leggingsPreventLevitation)) {
                event.getEntity().m_21195_(MobEffects.f_19620_);
            }
        }
    }

    private static boolean checkItem(ItemStack stack, Function<ExtendedArmorMaterials, Boolean> run) {
        boolean bl;
        Item item = stack.m_41720_();
        if (item instanceof WizardArmorItem) {
            WizardArmorItem armorItem = (WizardArmorItem)item;
            bl = run.apply(armorItem.getMaterial());
        } else {
            bl = false;
        }
        return bl;
    }
}

