/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.allthewizardgear;

import io.redspace.allthewizardgear.item.ExtendedArmorMaterials;
import java.util.List;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.config.ModConfigEvent;

@Mod.EventBusSubscriber(modid="allthewizardgear", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ServerConfig {
    private static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    static ForgeConfigSpec SPEC;
    public static ArmorSetConfig ALLTHEMODIUM_CONFIG;
    public static ArmorSetConfig VIBRANIUM_CONFIG;
    public static ArmorSetConfig UNOBTAINIUM_CONFIG;

    private static ArmorSetConfig defineConfig(ForgeConfigSpec.Builder builder, String name, List<Integer> defenseValues, int toughness, double knockbackResistance, int maxMana, double spellPower, double manaRegen, boolean helmetPreventsDrowning, boolean helmetPreventsElytraDamage, boolean chestplatePreventsFire, boolean chestplatePreventsDragonBreath, boolean leggingsPreventWither, boolean leggingsPreventLevitation, boolean bootsPreventFallDamage) {
        builder.push(name);
        String localizedName = name.substring(0, 1).toUpperCase() + name.substring(1) + "'s ";
        ArmorSetConfig config = new ArmorSetConfig((ForgeConfigSpec.ConfigValue<List<? extends Integer>>)builder.worldRestart().comment(localizedName + "Armor Values, in the form of [boots, leggings, chestplate, helmet]. Default: " + defenseValues).defineList("armorValues", () -> defenseValues, x -> true), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.worldRestart().comment(localizedName + "Armor Toughness. Default: " + toughness).define("toughness", (Object)toughness), (ForgeConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + "Knockback Resistance. Default: " + knockbackResistance).define("knockbackResistance", (Object)knockbackResistance), (ForgeConfigSpec.ConfigValue<? extends Integer>)builder.worldRestart().comment(localizedName + "Max Mana. Default: " + maxMana).define("maxMana", (Object)maxMana), (ForgeConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + String.format("Spell Power. Default: %s (+%s%%)", spellPower, (int)(spellPower * 100.0))).define("spellPower", (Object)spellPower), (ForgeConfigSpec.ConfigValue<? extends Double>)builder.worldRestart().comment(localizedName + String.format("Mana Regen. Default: %s", manaRegen)).define("manaRegen", (Object)manaRegen), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Helmet Prevents Drowning. Default: %s", helmetPreventsDrowning)).define("helmetPreventsDrowning", helmetPreventsDrowning), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Helmet Prevents Elytra Damage. Default: %s", helmetPreventsElytraDamage)).define("helmetPreventsElytraDamage", helmetPreventsElytraDamage), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Chestplate Prevents Fire Damage. Default: %s", chestplatePreventsFire)).define("chestplatePreventsFire", chestplatePreventsFire), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Chestplate Prevents Dragon Breath. Default: %s", chestplatePreventsDragonBreath)).define("chestplatePreventsDragonBreath", chestplatePreventsDragonBreath), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Leggings Prevent Wither. Default: %s", leggingsPreventWither)).define("leggingsPreventWither", leggingsPreventWither), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Leggings Prevent Levitation. Default: %s", leggingsPreventLevitation)).define("leggingsPreventLevitation", leggingsPreventLevitation), (ForgeConfigSpec.ConfigValue<? extends Boolean>)builder.worldRestart().comment(localizedName + String.format("Boots Prevent Fall Damage. Default: %s", bootsPreventFallDamage)).define("bootsPreventFallDamage", bootsPreventFallDamage));
        builder.pop();
        return config;
    }

    @SubscribeEvent
    public static void onReload(ModConfigEvent.Reloading event) {
        for (ExtendedArmorMaterials value : ExtendedArmorMaterials.values()) {
            value.reload();
        }
    }

    static {
        BUILDER.push("ArmorConfig");
        BUILDER.comment("Changing armor values requires world restart");
        ALLTHEMODIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "allthemodium", List.of(Integer.valueOf(4), Integer.valueOf(7), Integer.valueOf(9), Integer.valueOf(4)), 4, 0.0, 200, 0.2, 0.05, true, true, true, false, false, false, true);
        VIBRANIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "vibranium", List.of(Integer.valueOf(6), Integer.valueOf(9), Integer.valueOf(11), Integer.valueOf(6)), 5, 0.0, 325, 0.3, 0.1, true, true, true, false, true, false, true);
        UNOBTAINIUM_CONFIG = ServerConfig.defineConfig(BUILDER, "unobtainium", List.of(Integer.valueOf(8), Integer.valueOf(11), Integer.valueOf(13), Integer.valueOf(8)), 6, 0.0, 450, 0.4, 0.15, true, true, true, true, true, true, true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }

    public record ArmorSetConfig(ForgeConfigSpec.ConfigValue<List<? extends Integer>> defenseValues, ForgeConfigSpec.ConfigValue<? extends Integer> toughness, ForgeConfigSpec.ConfigValue<? extends Double> knockbackResistance, ForgeConfigSpec.ConfigValue<? extends Integer> maxMana, ForgeConfigSpec.ConfigValue<? extends Double> spellPower, ForgeConfigSpec.ConfigValue<? extends Double> manaRegen, ForgeConfigSpec.ConfigValue<? extends Boolean> helmetPreventsDrowning, ForgeConfigSpec.ConfigValue<? extends Boolean> helmetPreventsElytraDamage, ForgeConfigSpec.ConfigValue<? extends Boolean> chestplatePreventsFire, ForgeConfigSpec.ConfigValue<? extends Boolean> chestplatePreventsDragonBreath, ForgeConfigSpec.ConfigValue<? extends Boolean> leggingsPreventWither, ForgeConfigSpec.ConfigValue<? extends Boolean> leggingsPreventLevitation, ForgeConfigSpec.ConfigValue<? extends Boolean> bootsPreventFallDamage) {
        public double getDefenseFor(EquipmentSlot slot) {
            if (((List)this.defenseValues.get()).size() != 4) {
                return ((Integer)((List)this.defenseValues.getDefault()).get(slot.m_20749_())).intValue();
            }
            return ((Integer)((List)this.defenseValues.get()).get(slot.m_20749_())).intValue();
        }
    }
}

