/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemylib.datagen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.smashingmods.alchemylib.api.item.IngredientStack;
import com.smashingmods.chemlib.registry.ItemRegistry;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.common.crafting.conditions.AndCondition;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.ModLoadedCondition;
import net.minecraftforge.common.crafting.conditions.NotCondition;
import net.minecraftforge.common.crafting.conditions.OrCondition;
import net.minecraftforge.common.crafting.conditions.TagEmptyCondition;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;

public class DatagenHelpers {
    public static void itemToJson(JsonObject pJson, String pKey, ItemLike pItem) {
        DatagenHelpers.itemStackToJson(pJson, pKey, new ItemStack(pItem));
    }

    public static void itemStackToJson(JsonObject pJson, String pKey, ItemStack pItemStack) {
        if (!pItemStack.m_41619_()) {
            JsonObject jsonObject = new JsonObject();
            jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItemStack.m_41720_())).toString());
            if (pItemStack.m_41613_() > 1) {
                jsonObject.addProperty("count", (Number)pItemStack.m_41613_());
            }
            pJson.add(pKey, (JsonElement)jsonObject);
        }
    }

    public static void itemStackListToJson(JsonObject pJson, String pKey, List<ItemStack> pItemStackList) {
        if (!pItemStackList.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (ItemStack itemStack : pItemStackList) {
                JsonObject jsonObject = new JsonObject();
                if (itemStack != null) {
                    jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)itemStack.m_41720_())).toString());
                    if (itemStack.m_41613_() > 1) {
                        jsonObject.addProperty("count", (Number)itemStack.m_41613_());
                    }
                } else {
                    jsonObject.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)ItemStack.f_41583_.m_41720_())).toString());
                }
                jsonArray.add((JsonElement)jsonObject);
            }
            pJson.add(pKey, (JsonElement)jsonArray);
        }
    }

    public static void ingredientStackListToJson(JsonObject pJson, String pKey, Collection<IngredientStack> pIngredientStackList) {
        if (!pIngredientStackList.isEmpty()) {
            JsonArray jsonArray = new JsonArray();
            for (IngredientStack ingredientStack : pIngredientStackList) {
                jsonArray.add((JsonElement)ingredientStack.toJson());
            }
            pJson.add(pKey, (JsonElement)jsonArray);
        }
    }

    public static void fluidStacktoJson(JsonObject pJson, String pKey, FluidStack pFluidStack) {
        if (!pFluidStack.isEmpty()) {
            JsonObject jsonObject = new JsonObject();
            ResourceLocation fluidLocation = ForgeRegistries.FLUIDS.getKey((Object)pFluidStack.getFluid());
            String amount = String.valueOf(pFluidStack.getAmount());
            jsonObject.addProperty("fluid", Objects.requireNonNull(fluidLocation).toString());
            jsonObject.addProperty("amount", amount);
            pJson.add(pKey, (JsonElement)jsonObject);
        }
    }

    public static ItemStack toItemStack(String pString) {
        return DatagenHelpers.toItemStack(pString, 1);
    }

    public static ItemStack toItemStack(String pString, int pCount) {
        return new ItemStack(DatagenHelpers.getChemicalItem(pString), pCount);
    }

    public static IngredientStack toIngredientStack(String pString) {
        return DatagenHelpers.toIngredientStack(pString, 1);
    }

    public static IngredientStack toIngredientStack(String pString, int pCount) {
        return new IngredientStack(DatagenHelpers.getChemicalItem(pString), pCount);
    }

    private static ItemLike getChemicalItem(String pString) {
        ResourceLocation resourceLocation = new ResourceLocation(pString);
        Optional optionalElement = ItemRegistry.getElementByName((String)pString);
        Optional optionalCompound = ItemRegistry.getCompoundByName((String)pString.replace(" ", "_"));
        Item outputItem = (Item)ForgeRegistries.ITEMS.getValue(resourceLocation);
        Block outputBlock = (Block)ForgeRegistries.BLOCKS.getValue(resourceLocation);
        if (optionalElement.isPresent()) {
            return (ItemLike)optionalElement.get();
        }
        if (optionalCompound.isPresent()) {
            return (ItemLike)optionalCompound.get();
        }
        if (outputItem != null) {
            return outputItem;
        }
        if (outputBlock != null && outputBlock != Blocks.f_50016_ && outputBlock != Blocks.f_49990_) {
            return outputBlock;
        }
        return Items.f_41852_;
    }

    public static ResourceLocation getLocation(ItemStack pItemStack, String pType, String pModId) {
        return new ResourceLocation(pModId, String.format("%s/%s", pType, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItemStack.m_41720_())).m_135815_()));
    }

    public static ResourceLocation getLocation(Item pItem, String pType, String pModId) {
        return new ResourceLocation(pModId, String.format("%s/%s", pType, Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)pItem)).m_135815_()));
    }

    public static ResourceLocation getLocation(FluidStack pFluidStack, String pType, String pModId) {
        return new ResourceLocation(pModId, String.format("%s/%s", pType, Objects.requireNonNull(ForgeRegistries.FLUIDS.getKey((Object)pFluidStack.getFluid())).m_135815_()));
    }

    public static ModLoadedCondition modLoadedCondition(String pModId) {
        return new ModLoadedCondition(pModId);
    }

    public static NotCondition notCondition(ICondition pCondition) {
        return new NotCondition(pCondition);
    }

    public static AndCondition andCondition(ICondition pCondition1, ICondition pCondition2) {
        return new AndCondition(new ICondition[]{pCondition1, pCondition2});
    }

    public static OrCondition orCondition(ICondition pCondition1, ICondition pCondition2) {
        return new OrCondition(new ICondition[]{pCondition1, pCondition2});
    }

    public static TagEmptyCondition tagEmptyCondition(String pTag) {
        return new TagEmptyCondition(pTag);
    }

    public static NotCondition tagNotEmptyCondition(String pTag) {
        return DatagenHelpers.notCondition((ICondition)DatagenHelpers.tagEmptyCondition(pTag));
    }
}

