/*
 * Decompiled with CFR 0.152.
 */
package com.smashingmods.alchemistry.common.block.reactor;

import com.smashingmods.alchemistry.common.block.reactor.ReactorType;
import com.smashingmods.alchemistry.registry.BlockRegistry;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class ReactorShape {
    private final ReactorType reactorType;
    private final BoundingBox fullBoundingBox;
    private final BoundingBox core;
    private final BoundingBox innerFrontPlane;
    private final BoundingBox innerRearPlane;
    private final BoundingBox innerTopPlane;
    private final BoundingBox innerBottomPlane;
    private final BoundingBox innerLeftPlane;
    private final BoundingBox innerRightPlane;
    private final BoundingBox frontTopBorder;
    private final BoundingBox frontBottomBorder;
    private final BoundingBox leftTopBorder;
    private final BoundingBox leftBottomBorder;
    private final BoundingBox rightTopBorder;
    private final BoundingBox rightBottomBorder;
    private final BoundingBox rearTopBorder;
    private final BoundingBox rearBottomBorder;
    private final BoundingBox frontLeftCornerBorder;
    private final BoundingBox frontRightCornerBorder;
    private final BoundingBox rearLeftCornerBorder;
    private final BoundingBox rearRightCornerBorder;

    public ReactorShape(BlockPos pBlockPos, ReactorType pReactorType, Level pLevel) {
        this.reactorType = pReactorType;
        Direction facing = (Direction)pLevel.m_8055_(pBlockPos).m_61143_((Property)BlockStateProperties.f_61374_);
        Direction oppositeFacing = facing.m_122424_();
        Direction rightFacing = facing.m_122428_();
        Direction leftFacing = facing.m_122427_();
        BlockPos coreBottom = pBlockPos.m_5484_(oppositeFacing, 2);
        BlockPos coreTop = coreBottom.m_5484_(Direction.UP, 2);
        this.core = ReactorShape.fromCorners(coreBottom, coreTop);
        BlockPos frontTopRight = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(rightFacing, 2);
        BlockPos frontTopLeft = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(leftFacing, 2);
        BlockPos frontBottomRight = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(rightFacing, 2);
        BlockPos frontBottomLeft = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(leftFacing, 2);
        BlockPos rearTopRight = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(oppositeFacing, 4).m_5484_(rightFacing, 2);
        BlockPos rearTopLeft = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(oppositeFacing, 4).m_5484_(leftFacing, 2);
        BlockPos rearBottomRight = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(oppositeFacing, 4).m_5484_(rightFacing, 2);
        BlockPos rearBottomLeft = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(oppositeFacing, 4).m_5484_(leftFacing, 2);
        this.fullBoundingBox = ReactorShape.fromCorners(frontTopLeft, rearBottomRight);
        this.frontTopBorder = ReactorShape.fromCorners(frontTopRight, frontTopLeft);
        this.frontBottomBorder = ReactorShape.fromCorners(frontBottomRight, frontBottomLeft);
        this.leftTopBorder = ReactorShape.fromCorners(frontTopLeft, rearTopLeft);
        this.leftBottomBorder = ReactorShape.fromCorners(frontBottomLeft, rearBottomLeft);
        this.rightTopBorder = ReactorShape.fromCorners(frontTopRight, rearTopRight);
        this.rightBottomBorder = ReactorShape.fromCorners(frontBottomRight, rearBottomRight);
        this.rearTopBorder = ReactorShape.fromCorners(rearTopRight, rearTopLeft);
        this.rearBottomBorder = ReactorShape.fromCorners(rearBottomRight, rearBottomLeft);
        this.frontLeftCornerBorder = ReactorShape.fromCorners(frontTopLeft, frontBottomLeft);
        this.frontRightCornerBorder = ReactorShape.fromCorners(frontTopRight, frontBottomRight);
        this.rearLeftCornerBorder = ReactorShape.fromCorners(rearTopLeft, rearBottomLeft);
        this.rearRightCornerBorder = ReactorShape.fromCorners(rearTopRight, rearBottomRight);
        BlockPos innerFrontTopClockwise = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(oppositeFacing, 1).m_5484_(rightFacing, 1);
        BlockPos innerRearTopCounterClockwise = pBlockPos.m_5484_(Direction.UP, 3).m_5484_(oppositeFacing, 3).m_5484_(leftFacing, 1);
        this.innerTopPlane = ReactorShape.fromCorners(innerFrontTopClockwise, innerRearTopCounterClockwise);
        BlockPos innerFrontBottomRight = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(oppositeFacing, 1).m_5484_(rightFacing, 1);
        BlockPos innerRearBottomLeft = pBlockPos.m_5484_(Direction.DOWN, 1).m_5484_(oppositeFacing, 3).m_5484_(leftFacing, 1);
        this.innerBottomPlane = ReactorShape.fromCorners(innerFrontBottomRight, innerRearBottomLeft);
        BlockPos innerLeftFrontTop = pBlockPos.m_5484_(Direction.UP, 2).m_5484_(oppositeFacing, 1).m_5484_(leftFacing, 2);
        BlockPos innerLeftRearBottom = pBlockPos.m_5484_(oppositeFacing, 3).m_5484_(leftFacing, 2);
        this.innerLeftPlane = ReactorShape.fromCorners(innerLeftFrontTop, innerLeftRearBottom);
        BlockPos innerRightFrontTop = pBlockPos.m_5484_(Direction.UP, 2).m_5484_(oppositeFacing, 1).m_5484_(rightFacing, 2);
        BlockPos innerRightRearBottom = pBlockPos.m_5484_(oppositeFacing, 3).m_5484_(rightFacing, 2);
        this.innerRightPlane = ReactorShape.fromCorners(innerRightFrontTop, innerRightRearBottom);
        BlockPos innerFrontLeftTop = pBlockPos.m_5484_(Direction.UP, 2).m_5484_(leftFacing, 1);
        BlockPos innerFrontRightBottom = pBlockPos.m_5484_(rightFacing, 1);
        this.innerFrontPlane = ReactorShape.fromCorners(innerFrontLeftTop, innerFrontRightBottom);
        BlockPos innerRearLeftTop = pBlockPos.m_5484_(Direction.UP, 2).m_5484_(oppositeFacing, 4).m_5484_(leftFacing, 1);
        BlockPos innerRearRightBottom = pBlockPos.m_5484_(oppositeFacing, 4).m_5484_(rightFacing, 1);
        this.innerRearPlane = ReactorShape.fromCorners(innerRearLeftTop, innerRearRightBottom);
    }

    public Map<BoundingBox, List<Block>> createShapeMap() {
        HashMap<BoundingBox, List<Block>> reactorShapeMap = new HashMap<BoundingBox, List<Block>>();
        RotatedPillarBlock coreComponent = switch (this.reactorType) {
            default -> throw new IncompatibleClassChangeError();
            case ReactorType.FUSION -> (RotatedPillarBlock)BlockRegistry.FUSION_CORE.get();
            case ReactorType.FISSION -> (RotatedPillarBlock)BlockRegistry.FISSION_CORE.get();
        };
        Block controllerComponent = switch (this.reactorType) {
            default -> throw new IncompatibleClassChangeError();
            case ReactorType.FUSION -> (Block)BlockRegistry.FUSION_CONTROLLER.get();
            case ReactorType.FISSION -> (Block)BlockRegistry.FISSION_CONTROLLER.get();
        };
        reactorShapeMap.put(this.core, List.of(coreComponent));
        reactorShapeMap.put(this.frontTopBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.frontBottomBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rearTopBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rearBottomBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.leftTopBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.leftBottomBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rightTopBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rightBottomBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.frontLeftCornerBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.frontRightCornerBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rearLeftCornerBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.rearRightCornerBorder, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_ENERGY.get(), (Block)BlockRegistry.REACTOR_INPUT.get(), (Block)BlockRegistry.REACTOR_OUTPUT.get()));
        reactorShapeMap.put(this.innerTopPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get()));
        reactorShapeMap.put(this.innerBottomPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get()));
        reactorShapeMap.put(this.innerFrontPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_GLASS.get(), controllerComponent));
        reactorShapeMap.put(this.innerRearPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_GLASS.get()));
        reactorShapeMap.put(this.innerLeftPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_GLASS.get()));
        reactorShapeMap.put(this.innerRightPlane, List.of((Block)BlockRegistry.REACTOR_CASING.get(), (Block)BlockRegistry.REACTOR_GLASS.get()));
        return reactorShapeMap;
    }

    private static BoundingBox fromCorners(BlockPos pStart, BlockPos pEnd) {
        return BoundingBox.m_162375_((Vec3i)ReactorShape.blockPosToVec3i(pStart), (Vec3i)ReactorShape.blockPosToVec3i(pEnd));
    }

    private static Vec3i blockPosToVec3i(BlockPos pBlockPos) {
        return new Vec3i(pBlockPos.m_123341_(), pBlockPos.m_123342_(), pBlockPos.m_123343_());
    }

    public BoundingBox getFullBoundingBox() {
        return this.fullBoundingBox;
    }

    public BoundingBox getCoreBoundingBox() {
        return this.core;
    }
}

