/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.network.packet.serverbound;

import com.aetherteam.aether.client.event.hooks.GuiHooks;
import com.aetherteam.nitrogen.network.BasePacket;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;

public abstract class BossInfoPacket
implements BasePacket {
    protected final UUID bossEvent;
    protected final int entityID;

    public BossInfoPacket(UUID bossEvent, int entityID) {
        this.bossEvent = bossEvent;
        this.entityID = entityID;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130077_(this.bossEvent);
        buf.writeInt(this.entityID);
    }

    public static class Remove
    extends BossInfoPacket {
        public Remove(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public static Remove decode(FriendlyByteBuf buf) {
            UUID bossEvent = buf.m_130259_();
            int entityID = buf.readInt();
            return new Remove(bossEvent, entityID);
        }

        public void execute(Player playerEntity) {
            GuiHooks.BOSS_EVENTS.remove(this.bossEvent);
        }
    }

    public static class Display
    extends BossInfoPacket {
        public Display(UUID bossEvent, int entityID) {
            super(bossEvent, entityID);
        }

        public static Display decode(FriendlyByteBuf buf) {
            UUID bossEvent = buf.m_130259_();
            int entityID = buf.readInt();
            return new Display(bossEvent, entityID);
        }

        public void execute(Player playerEntity) {
            GuiHooks.BOSS_EVENTS.put(this.bossEvent, this.entityID);
        }
    }
}

