/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.client.renderer.entity.layers;

import com.aetherteam.aether.client.gui.screen.perks.MoaSkinsScreen;
import com.aetherteam.aether.client.renderer.entity.model.MoaModel;
import com.aetherteam.aether.entity.passive.Moa;
import com.aetherteam.aether.perk.data.ClientMoaSkinPerkData;
import com.aetherteam.aether.perk.types.MoaData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;

public class MoaSaddleEmissiveLayer
extends RenderLayer<Moa, MoaModel> {
    private final MoaModel saddle;

    public MoaSaddleEmissiveLayer(RenderLayerParent<Moa, MoaModel> entityRenderer, MoaModel saddleModel) {
        super(entityRenderer);
        this.saddle = saddleModel;
    }

    public void render(PoseStack poseStack, MultiBufferSource buffer, int packedLight, Moa moa, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        ResourceLocation moaSkin;
        if (moa.m_6254_() && !moa.m_20145_() && (moaSkin = this.getMoaSkinLocation(moa)) != null) {
            RenderType renderType = RenderType.m_110488_((ResourceLocation)moaSkin);
            ((MoaModel)this.m_117386_()).m_102624_(this.saddle);
            this.saddle.prepareMobModel(moa, limbSwing, limbSwingAmount, partialTicks);
            this.saddle.setupAnim(moa, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            VertexConsumer consumer = buffer.m_6299_(renderType);
            this.saddle.m_7695_(poseStack, consumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    @Nullable
    private ResourceLocation getMoaSkinLocation(Moa moa) {
        MoaSkinsScreen moaSkinsScreen;
        UUID lastRiderUUID = moa.getLastRider();
        UUID moaUUID = moa.getMoaUUID();
        Map userSkinsData = ClientMoaSkinPerkData.INSTANCE.getClientPerkData();
        Screen screen = Minecraft.m_91087_().f_91080_;
        if (screen instanceof MoaSkinsScreen && (moaSkinsScreen = (MoaSkinsScreen)screen).getSelectedSkin() != null && moaSkinsScreen.getPreviewMoa() != null && moaSkinsScreen.getPreviewMoa().getMoaUUID() != null && moaSkinsScreen.getPreviewMoa().getMoaUUID().equals(moaUUID)) {
            return moaSkinsScreen.getSelectedSkin().getSaddleEmissiveLocation();
        }
        if (userSkinsData.containsKey(lastRiderUUID) && ((MoaData)userSkinsData.get(lastRiderUUID)).moaUUID() != null && ((MoaData)userSkinsData.get(lastRiderUUID)).moaUUID().equals(moaUUID)) {
            return ((MoaData)userSkinsData.get(lastRiderUUID)).moaSkin().getSaddleEmissiveLocation();
        }
        return null;
    }
}

