/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.miscellaneous;

import com.aetherteam.aether.api.registers.MoaType;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.aetherteam.aether.mixin.mixins.common.accessor.BaseSpawnerAccessor;
import com.google.common.collect.Iterables;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.RegistryObject;

public class MoaEggItem
extends Item {
    private static final Map<Supplier<? extends MoaType>, MoaEggItem> BY_ID = new IdentityHashMap<Supplier<? extends MoaType>, MoaEggItem>();
    private final Supplier<? extends MoaType> moaType;
    private final ResourceLocation moaTypeId;
    private final int color;

    public MoaEggItem(RegistryObject<? extends MoaType> moaType, int shellColor, Item.Properties properties) {
        this((Supplier<? extends MoaType>)moaType, moaType.getId(), shellColor, properties);
    }

    public MoaEggItem(Supplier<? extends MoaType> moaType, ResourceLocation moaTypeId, int shellColor, Item.Properties properties) {
        super(properties);
        this.moaType = moaType;
        this.moaTypeId = moaTypeId;
        this.color = shellColor;
        BY_ID.put(moaType, this);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        ItemStack itemStack = context.m_43722_();
        Player player = context.m_43723_();
        if (player != null && player.m_7500_()) {
            BlockEntity blockEntity;
            Level level = context.m_43725_();
            if (!(level instanceof ServerLevel)) {
                return InteractionResult.SUCCESS;
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockPos = context.m_8083_();
            Direction direction = context.m_43719_();
            BlockState blockState = level.m_8055_(blockPos);
            if (blockState.m_60713_(Blocks.f_50085_) && (blockEntity = level.m_7702_(blockPos)) instanceof SpawnerBlockEntity) {
                SpawnerBlockEntity spawnerBlockEntity = (SpawnerBlockEntity)blockEntity;
                BaseSpawnerAccessor baseSpawnerAccessor = (BaseSpawnerAccessor)spawnerBlockEntity.m_59801_();
                EntityType entityType = (EntityType)AetherEntityTypes.MOA.get();
                spawnerBlockEntity.m_252803_(entityType, level.m_213780_());
                baseSpawnerAccessor.aether$getNextSpawnData().m_186567_().m_128359_("MoaType", this.getMoaTypeId().toString());
                baseSpawnerAccessor.aether$getNextSpawnData().m_186567_().m_128379_("PlayerGrown", true);
                blockEntity.m_6596_();
                level.m_7260_(blockPos, blockState, blockState, 3);
                itemStack.m_41774_(1);
                return InteractionResult.CONSUME;
            }
            BlockPos relativePos = blockState.m_60812_((BlockGetter)level, blockPos).m_83281_() ? blockPos : blockPos.m_121945_(direction);
            ItemStack spawnStack = this.getStackWithTags(itemStack, false, this.getMoaType(), false, true);
            Entity entity = ((EntityType)AetherEntityTypes.MOA.get()).m_20592_(serverLevel, spawnStack, player, relativePos, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, relativePos) && direction == Direction.UP);
            if (entity != null) {
                level.m_142346_((Entity)player, GameEvent.f_157810_, blockPos);
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.FAIL;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack heldStack = player.m_21120_(hand);
        if (player.m_7500_()) {
            BlockHitResult hitResult = MoaEggItem.m_41435_((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
            if (hitResult.m_6662_() != HitResult.Type.BLOCK) {
                return InteractionResultHolder.m_19098_((Object)heldStack);
            }
            if (!(level instanceof ServerLevel)) {
                return InteractionResultHolder.m_19100_((Object)heldStack);
            }
            ServerLevel serverLevel = (ServerLevel)level;
            BlockPos blockpos = hitResult.m_82425_();
            if (!(level.m_8055_(blockpos).m_60734_() instanceof LiquidBlock)) {
                return InteractionResultHolder.m_19098_((Object)heldStack);
            }
            if (level.m_7966_(player, blockpos) && player.m_36204_(blockpos, hitResult.m_82434_(), heldStack)) {
                ItemStack spawnStack = this.getStackWithTags(heldStack, false, this.getMoaType(), false, true);
                Entity entity = ((EntityType)AetherEntityTypes.MOA.get()).m_20592_(serverLevel, spawnStack, player, blockpos, MobSpawnType.SPAWN_EGG, false, false);
                if (entity == null) {
                    return InteractionResultHolder.m_19098_((Object)heldStack);
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                level.m_142346_((Entity)player, GameEvent.f_157810_, blockpos);
                return InteractionResultHolder.m_19096_((Object)heldStack);
            }
            return InteractionResultHolder.m_19100_((Object)heldStack);
        }
        return InteractionResultHolder.m_19100_((Object)heldStack);
    }

    public ItemStack getStackWithTags(ItemStack stack, boolean isBaby, MoaType moaType, boolean isHungry, boolean isPlayerGrown) {
        ItemStack itemStack = stack.m_41777_();
        CompoundTag tag = itemStack.m_41784_();
        tag.m_128379_("IsBaby", isBaby);
        tag.m_128359_("MoaType", moaType.toString());
        tag.m_128379_("Hungry", isHungry);
        tag.m_128379_("PlayerGrown", isPlayerGrown);
        return itemStack;
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getColor() {
        return this.color;
    }

    public MoaType getMoaType() {
        return this.moaType.get();
    }

    public ResourceLocation getMoaTypeId() {
        return this.moaTypeId;
    }

    @Nullable
    public static MoaEggItem byId(MoaType moaType) {
        for (Supplier<? extends MoaType> holder : BY_ID.keySet()) {
            if (!moaType.getId().equals((Object)holder.get().getId())) continue;
            return BY_ID.get(holder);
        }
        return null;
    }

    public static Iterable<MoaEggItem> moaEggs() {
        return Iterables.unmodifiableIterable(BY_ID.values());
    }
}

