/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.item.combat.abilities.weapon;

import com.aetherteam.aether.item.EquipmentUtil;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ItemStack;

public interface ZaniteWeapon {
    public static final UUID DAMAGE_MODIFIER_UUID = UUID.fromString("CAE1DE8D-8A7F-4391-B6BD-C060B1DD49C5");

    default public Multimap<Attribute, AttributeModifier> increaseDamage(Multimap<Attribute, AttributeModifier> map, ItemStack stack, EquipmentSlot slot) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder attributeBuilder = ImmutableMultimap.builder();
            attributeBuilder.putAll(map);
            attributeBuilder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(DAMAGE_MODIFIER_UUID, "Damage modifier", (double)this.calculateIncrease((Multimap<Attribute, AttributeModifier>)map, stack), AttributeModifier.Operation.ADDITION));
            map = attributeBuilder.build();
        }
        return map;
    }

    private int calculateIncrease(Multimap<Attribute, AttributeModifier> map, ItemStack stack) {
        double baseDamage = 0.0;
        Iterator it = map.get((Object)Attributes.f_22281_).stream().iterator();
        while (it.hasNext()) {
            AttributeModifier modifier = (AttributeModifier)it.next();
            baseDamage += modifier.m_22218_();
        }
        double boostedDamage = EquipmentUtil.calculateZaniteBuff(stack, baseDamage);
        if ((boostedDamage -= baseDamage) < 0.0) {
            boostedDamage = 0.0;
        }
        return (int)Math.round(boostedDamage);
    }
}

