/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.projectile.ZephyrSnowball;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.FlyingMob;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Zephyr
extends FlyingMob
implements Enemy {
    private static final EntityDataAccessor<Integer> DATA_CHARGE_TIME_ID = SynchedEntityData.m_135353_(Zephyr.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private int cloudScale;
    private int cloudScaleAdd;
    private float tailRot;
    private float tailRotAdd;

    public Zephyr(EntityType<? extends Zephyr> type, Level level) {
        super(type, level);
        this.f_21342_ = new ZephyrMoveControl(this);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(5, (Goal)new RandomFloatAroundGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new ZephyrLookGoal(this));
        this.f_21345_.m_25352_(7, (Goal)new ZephyrShootSnowballGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return FlyingMob.m_21552_().m_22268_(Attributes.f_22276_, 5.0).m_22268_(Attributes.f_22277_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_CHARGE_TIME_ID, (Object)0);
    }

    public static boolean checkZephyrSpawnRules(EntityType<? extends Zephyr> zephyr, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return Mob.m_217057_(zephyr, (LevelAccessor)level, (MobSpawnType)reason, (BlockPos)pos, (RandomSource)random) && level.m_45527_(pos) && level.m_46791_() != Difficulty.PEACEFUL && (reason != MobSpawnType.NATURAL || random.m_188503_(11) == 0);
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_20186_() < (double)(this.m_9236_().m_141937_() - 2) || this.m_20186_() > (double)this.m_9236_().m_151558_()) {
            this.m_146870_();
        }
        if (this.m_9236_().m_5776_()) {
            this.cloudScale += this.cloudScaleAdd;
            this.tailRot += this.tailRotAdd;
            if (this.getChargeTime() < 20 && this.getChargeTime() > 0) {
                this.cloudScaleAdd = 1;
            } else {
                this.cloudScaleAdd = 0;
                this.cloudScale = 0;
            }
            this.tailRotAdd = 0.015f;
            if (this.tailRot >= (float)Math.PI * 2) {
                this.tailRot -= (float)Math.PI * 2;
            }
        }
    }

    public int getChargeTime() {
        return (Integer)this.m_20088_().m_135370_(DATA_CHARGE_TIME_ID);
    }

    public void setChargeTime(int chargeTime) {
        this.m_20088_().m_135381_(DATA_CHARGE_TIME_ID, (Object)chargeTime);
    }

    public int getCloudScale() {
        return this.cloudScale;
    }

    public int getCloudScaleAdd() {
        return this.cloudScaleAdd;
    }

    public float getTailRot() {
        return this.tailRot;
    }

    public float getTailRotAdd() {
        return this.tailRotAdd;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_DEATH.get();
    }

    protected float m_6121_() {
        return 3.0f;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return true;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected static class ZephyrMoveControl
    extends MoveControl {
        private final Zephyr zephyr;
        private int floatDuration;

        public ZephyrMoveControl(Zephyr zephyr) {
            super((Mob)zephyr);
            this.zephyr = zephyr;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO && this.floatDuration-- <= 0) {
                this.floatDuration += this.zephyr.m_217043_().m_188503_(5) + 2;
                Vec3 vec3d = new Vec3(this.f_24975_ - this.zephyr.m_20185_(), this.f_24976_ - this.zephyr.m_20186_(), this.f_24977_ - this.zephyr.m_20189_());
                double d0 = vec3d.m_82553_();
                if (this.canReach(vec3d = vec3d.m_82541_(), Mth.m_14165_((double)d0))) {
                    this.zephyr.m_20256_(this.zephyr.m_20184_().m_82549_(vec3d.m_82490_(0.1)));
                } else {
                    this.f_24981_ = MoveControl.Operation.WAIT;
                }
            }
        }

        private boolean canReach(Vec3 pos, int distance) {
            AABB axisalignedbb = this.zephyr.m_20191_();
            for (int i = 1; i < distance; ++i) {
                axisalignedbb = axisalignedbb.m_82383_(pos);
                if (this.zephyr.m_9236_().m_45756_((Entity)this.zephyr, axisalignedbb)) continue;
                return false;
            }
            return true;
        }
    }

    protected static class RandomFloatAroundGoal
    extends Goal {
        private final Zephyr zephyr;

        public RandomFloatAroundGoal(Zephyr zephyr) {
            this.zephyr = zephyr;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            double d2;
            double d1;
            MoveControl moveControl = this.zephyr.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d0 = moveControl.m_25000_() - this.zephyr.m_20185_();
            double d3 = d0 * d0 + (d1 = moveControl.m_25001_() - this.zephyr.m_20186_()) * d1 + (d2 = moveControl.m_25002_() - this.zephyr.m_20189_()) * d2;
            return d3 < 1.0 || d3 > 3600.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource random = this.zephyr.m_217043_();
            double d0 = this.zephyr.m_20185_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d1 = this.zephyr.m_20186_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            double d2 = this.zephyr.m_20189_() + (double)((random.m_188501_() * 2.0f - 1.0f) * 16.0f);
            this.zephyr.m_21566_().m_6849_(d0, d1, d2, 1.0);
        }
    }

    protected static class ZephyrLookGoal
    extends Goal {
        private final Zephyr zephyr;

        public ZephyrLookGoal(Zephyr zephyr) {
            this.zephyr = zephyr;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.zephyr.m_5448_() == null) {
                Vec3 vec3d = this.zephyr.m_20184_();
                this.zephyr.m_146922_(-((float)Mth.m_14136_((double)vec3d.m_7096_(), (double)vec3d.m_7094_())) * 57.295776f);
                this.zephyr.f_20883_ = this.zephyr.m_146908_();
            } else {
                LivingEntity livingEntity = this.zephyr.m_5448_();
                if (livingEntity.m_20280_((Entity)this.zephyr) < 4096.0) {
                    double x = livingEntity.m_20185_() - this.zephyr.m_20185_();
                    double z = livingEntity.m_20189_() - this.zephyr.m_20189_();
                    this.zephyr.m_146922_(-((float)Mth.m_14136_((double)x, (double)z)) * 57.295776f);
                    this.zephyr.m_5618_(this.zephyr.m_146908_());
                }
            }
        }
    }

    protected static class ZephyrShootSnowballGoal
    extends Goal {
        private final Zephyr zephyr;

        public ZephyrShootSnowballGoal(Zephyr zephyr) {
            this.zephyr = zephyr;
        }

        public boolean m_8036_() {
            return this.zephyr.m_5448_() != null;
        }

        public void m_8056_() {
            this.zephyr.setChargeTime(0);
        }

        public void m_8041_() {
            this.zephyr.setChargeTime(0);
        }

        public void m_8037_() {
            LivingEntity livingEntity = this.zephyr.m_5448_();
            if (livingEntity != null) {
                if (livingEntity.m_20280_((Entity)this.zephyr) < 1600.0 && this.zephyr.m_142582_((Entity)livingEntity)) {
                    Level level = this.zephyr.m_9236_();
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() + 1);
                    if (this.zephyr.getChargeTime() == 10) {
                        if (this.zephyr.m_7515_() != null) {
                            this.zephyr.m_5496_(this.zephyr.m_7515_(), this.zephyr.m_6121_(), (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                        }
                    } else if (this.zephyr.getChargeTime() == 20) {
                        Vec3 look = this.zephyr.m_20252_(1.0f);
                        double accelX = livingEntity.m_20185_() - (this.zephyr.m_20185_() + look.m_7096_() * 4.0);
                        double accelY = livingEntity.m_20227_(0.5) - (0.5 + this.zephyr.m_20227_(0.5));
                        double accelZ = livingEntity.m_20189_() - (this.zephyr.m_20189_() + look.m_7094_() * 4.0);
                        this.zephyr.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_ZEPHYR_SHOOT.get(), this.zephyr.m_6121_(), (level.m_213780_().m_188501_() - level.m_213780_().m_188501_()) * 0.2f + 1.0f);
                        ZephyrSnowball snowball = new ZephyrSnowball(level, (LivingEntity)this.zephyr, accelX, accelY, accelZ);
                        snowball.m_6034_(this.zephyr.m_20185_() + look.m_7096_() * 4.0, this.zephyr.m_20227_(0.5) + 0.5, this.zephyr.m_20189_() + look.m_7094_() * 4.0);
                        level.m_7967_((Entity)snowball);
                        this.zephyr.setChargeTime(-40);
                    }
                } else if (this.zephyr.getChargeTime() > 0) {
                    this.zephyr.setChargeTime(this.zephyr.getChargeTime() - 1);
                }
            }
        }
    }
}

