/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.monster;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.entity.MountableMob;
import com.aetherteam.aether.item.EquipmentUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;

public class Swet
extends Slime
implements MountableMob {
    private static final EntityDataAccessor<Boolean> DATA_PLAYER_JUMPED_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_MOUNT_JUMPING_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_MID_JUMP_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Float> DATA_WATER_DAMAGE_SCALE_ID = SynchedEntityData.m_135353_(Swet.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private boolean wasOnGround;
    private int jumpTimer;
    private float swetHeight = 1.0f;
    private float swetHeightO = 1.0f;
    private float swetWidth = 1.0f;
    private float swetWidthO = 1.0f;

    public Swet(EntityType<? extends Swet> type, Level level) {
        super(type, level);
        this.f_21342_ = new SwetMoveControl(this);
        this.f_21364_ = 5;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new ConsumeGoal(this));
        this.f_21345_.m_25352_(1, (Goal)new HuntGoal(this));
        this.f_21345_.m_25352_(2, (Goal)new SwetRandomDirectionGoal(this));
        this.f_21345_.m_25352_(4, (Goal)new SwetKeepOnJumpingGoal(this));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, target -> !this.isFriendlyTowardEntity((LivingEntity)target) && !(target.m_20201_() instanceof Swet)));
    }

    public static AttributeSupplier.Builder m_21552_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, 0.4).m_22268_(Attributes.f_22277_, 14.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(DATA_PLAYER_JUMPED_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_MOUNT_JUMPING_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_MID_JUMP_ID, (Object)false);
        this.m_20088_().m_135372_(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(0.0f));
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        if (DATA_WATER_DAMAGE_SCALE_ID.equals(dataAccessor)) {
            this.m_6210_();
        }
        super.m_7350_(dataAccessor);
    }

    public static boolean checkSwetSpawnRules(EntityType<? extends Swet> swet, LevelAccessor level, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(AetherTags.Blocks.SWET_SPAWNABLE_ON) && level.m_45524_(pos, 0) > 8 && level.m_46791_() != Difficulty.PEACEFUL;
    }

    public void m_8119_() {
        if (this.m_20069_()) {
            this.spawnDissolveParticles();
            if (this.getWaterDamageScale() < 0.9f) {
                this.setWaterDamageScale(this.getWaterDamageScale() + 0.02f);
            }
        }
        if (this.getWaterDamageScale() >= 0.9f && !this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
        this.tick((Mob)this);
        this.riderTick((Mob)this);
        super.m_8119_();
        if (!this.hasPrey() && this.canSpawnSplashParticles() && this.m_9236_().m_5776_()) {
            double d = (float)this.m_20185_() + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            double d1 = (float)this.m_20186_() + this.m_20206_();
            double d2 = (float)this.m_20189_() + (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.3f;
            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, d, d1 - 0.25, d2, 0.0, 0.0, 0.0);
        }
        if (!this.m_21525_()) {
            this.setMidJump(!this.m_20096_());
            if (this.m_9236_().m_5776_()) {
                this.swetHeightO = this.swetHeight;
                this.swetWidthO = this.swetWidth;
                this.jumpTimer = this.getMidJump() ? ++this.jumpTimer : 0;
                if (this.getJumpTimer() > 1) {
                    this.swetHeight = 1.425f;
                    this.swetWidth = 0.875f;
                    if (this.getJumpTimer() > 3) {
                        float scale = Math.min(this.getJumpTimer(), 10);
                        this.swetHeight -= 0.05f * scale;
                        this.swetWidth += 0.05f * scale;
                    }
                } else {
                    this.swetHeight = this.swetHeight < 1.0f ? this.swetHeight + 0.25f : 1.0f;
                    this.swetWidth = this.swetWidth > 1.0f ? this.swetWidth - 0.25f : 1.0f;
                }
            }
            this.wasOnGround = this.m_20096_();
        }
        if (this.isFriendly()) {
            this.m_183634_();
        }
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null && (this.hasPrey() || this.isFriendlyTowardEntity(this.m_5448_()) || this.m_5448_().m_20201_() instanceof Swet)) {
            this.m_6710_(null);
        }
    }

    public void m_7023_(Vec3 vector) {
        this.travel((Mob)this, vector);
        if (this.m_6084_()) {
            LivingEntity entity = this.m_6688_();
            if (this.m_20160_() && entity != null) {
                if (this.m_20096_() && !this.getPlayerJumped() && (this.m_20184_().m_7096_() != 0.0 || this.m_20184_().m_7094_() != 0.0)) {
                    this.m_20334_(this.m_20184_().m_7096_(), 0.42f, this.m_20184_().m_7094_());
                }
                this.m_183634_();
            }
        }
    }

    @Override
    public void travelWithInput(Vec3 motion) {
        super.m_7023_(motion);
    }

    public InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (!this.m_9236_().m_5776_() && !this.hasPrey() && this.isFriendlyTowardEntity((LivingEntity)player) && this.m_6134_() >= super.m_6134_()) {
            this.consumePassenger((LivingEntity)player);
        }
        return InteractionResult.PASS;
    }

    public void consumePassenger(LivingEntity livingEntity) {
        this.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_ATTACK.get(), 0.5f, (this.m_217043_().m_188501_() - this.m_217043_().m_188501_()) * 0.2f + 1.0f);
        EntityUtil.copyRotations((Entity)livingEntity, (Entity)this);
        this.m_20256_(livingEntity.m_20184_());
        livingEntity.m_7998_((Entity)this, true);
    }

    public void spawnDissolveParticles() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            level2.m_7605_((Entity)this, (byte)70);
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.m_142467_(pReason);
        this.invalidateCaps();
    }

    public boolean getMidJump() {
        return (Boolean)this.m_20088_().m_135370_(DATA_MID_JUMP_ID);
    }

    public void setMidJump(boolean midJump) {
        this.m_20088_().m_135381_(DATA_MID_JUMP_ID, (Object)midJump);
    }

    public float getWaterDamageScale() {
        return ((Float)this.m_20088_().m_135370_(DATA_WATER_DAMAGE_SCALE_ID)).floatValue();
    }

    public void setWaterDamageScale(float scale) {
        this.m_20088_().m_135381_(DATA_WATER_DAMAGE_SCALE_ID, (Object)Float.valueOf(scale));
    }

    @Override
    public boolean getPlayerJumped() {
        return (Boolean)this.m_20088_().m_135370_(DATA_PLAYER_JUMPED_ID);
    }

    @Override
    public void setPlayerJumped(boolean playerJumped) {
        this.m_20088_().m_135381_(DATA_PLAYER_JUMPED_ID, (Object)playerJumped);
    }

    @Override
    public boolean isMountJumping() {
        return (Boolean)this.m_20088_().m_135370_(DATA_MOUNT_JUMPING_ID);
    }

    @Override
    public void setMountJumping(boolean isMountJumping) {
        this.m_20088_().m_135381_(DATA_MOUNT_JUMPING_ID, (Object)isMountJumping);
    }

    public float getSwetHeight() {
        return this.swetHeight;
    }

    public float getSwetHeightO() {
        return this.swetHeightO;
    }

    public float getSwetWidth() {
        return this.swetWidth;
    }

    public float getSwetWidthO() {
        return this.swetWidthO;
    }

    protected SoundEvent m_7975_(DamageSource damageSource) {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_DEATH.get();
    }

    protected SoundEvent m_7905_() {
        return (SoundEvent)AetherSoundEvents.ENTITY_SWET_SQUISH.get();
    }

    public boolean hasPrey() {
        return this.m_146895_() != null;
    }

    public boolean canSpawnSplashParticles() {
        return true;
    }

    public boolean isFriendly() {
        return this.m_6688_() != null;
    }

    public boolean isFriendlyTowardEntity(LivingEntity entity) {
        return EquipmentUtil.hasSwetCape(entity);
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public int m_7549_() {
        return this.m_217043_().m_188503_(20) + 10;
    }

    public float m_6118_() {
        return 0.5f;
    }

    @Override
    public double getMountJumpStrength() {
        return 1.2;
    }

    @Override
    public double jumpFactor() {
        return this.m_20098_();
    }

    @Override
    public boolean canJump() {
        return this.m_20096_() && this.isFriendly();
    }

    @Override
    public float getSteeringSpeed() {
        return 0.084f;
    }

    public float m_274460_() {
        return this.m_6688_() != null ? this.getSteeringSpeed() * 0.25f : 0.02f;
    }

    public boolean canRiderInteract() {
        return true;
    }

    public double m_6048_() {
        return 1.4;
    }

    @Nullable
    public LivingEntity m_6688_() {
        LivingEntity livingEntity;
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity && this.isFriendlyTowardEntity(livingEntity = (LivingEntity)entity)) {
            return livingEntity;
        }
        return null;
    }

    public Vec3 m_7688_(LivingEntity livingEntity) {
        if (this.isFriendlyTowardEntity(livingEntity)) {
            return super.m_7688_(livingEntity);
        }
        return this.m_20182_();
    }

    public int m_33632_() {
        return this.m_20160_() ? 2 : 1;
    }

    public void m_7839_(int size, boolean resetHealth) {
    }

    public float m_6134_() {
        return super.m_6134_() - super.m_6134_() * this.getWaterDamageScale();
    }

    public EntityDimensions m_6972_(Pose pose) {
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    protected boolean m_7483_() {
        return false;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected boolean spawnCustomParticles() {
        return true;
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            for (int i = 0; i < 10; ++i) {
                double f = this.m_217043_().m_188501_() * ((float)Math.PI * 2);
                double f1 = this.m_217043_().m_188501_() * this.swetWidth + 0.25f;
                double f2 = (double)(this.m_217043_().m_188501_() * this.swetHeight) - this.m_217043_().m_188583_() * 0.02 * 10.0;
                double f3 = (double)Mth.m_14031_((float)((float)f)) * f1;
                double f4 = (double)Mth.m_14089_((float)((float)f)) * f1;
                this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123769_, this.m_20185_() + f3, this.m_20186_() + f2, this.m_20189_() + f4, f3 * 1.5 + this.m_20184_().m_7096_(), 4.0, f4 * 1.5 + this.m_20184_().m_7094_());
            }
        } else if (id == 71) {
            this.m_20248_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        } else {
            super.m_7822_(id);
        }
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("WaterDamageScale", this.getWaterDamageScale());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("WaterDamageScale")) {
            this.setWaterDamageScale(tag.m_128457_("WaterDamageScale"));
        }
    }

    public static class SwetMoveControl
    extends MoveControl {
        private float yRot;
        private int jumpDelay;
        private final Swet swet;
        private boolean isAggressive;
        private boolean canJump;

        public SwetMoveControl(Swet swet) {
            super((Mob)swet);
            this.swet = swet;
            this.yRot = 180.0f * swet.m_146908_() / (float)Math.PI;
        }

        public void setDirection(float yRot, boolean isAggressive) {
            this.yRot = yRot;
            this.isAggressive = isAggressive;
        }

        public void setWantedMovement(double speed) {
            this.f_24978_ = speed;
            this.f_24981_ = MoveControl.Operation.MOVE_TO;
        }

        public void setCanJump(boolean canJump) {
            this.canJump = canJump;
        }

        public void m_8126_() {
            if (this.swet.isFriendly()) {
                return;
            }
            this.swet.m_146922_(this.m_24991_(this.swet.m_146908_(), this.yRot, 90.0f));
            this.swet.m_5616_(this.swet.m_146908_());
            this.swet.m_5618_(this.swet.m_146908_());
            if (this.f_24981_ != MoveControl.Operation.MOVE_TO) {
                this.swet.m_21564_(0.0f);
            } else {
                this.f_24981_ = MoveControl.Operation.WAIT;
                if (this.swet.m_20096_()) {
                    this.swet.m_7910_((float)(this.f_24978_ * this.swet.m_21133_(Attributes.f_22279_)));
                    if (this.jumpDelay-- <= 0) {
                        this.jumpDelay = this.swet.m_7549_();
                        if (this.isAggressive) {
                            this.jumpDelay /= 6;
                        }
                        this.swet.m_21569_().m_24901_();
                        this.swet.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.m_217043_().m_188501_() - this.swet.m_217043_().m_188501_()) * 0.2f + 1.0f) * 0.8f);
                    } else {
                        this.swet.f_20900_ = 0.0f;
                        this.swet.f_20902_ = 0.0f;
                        this.swet.m_7910_(0.0f);
                    }
                } else {
                    this.swet.m_7910_((float)(this.f_24978_ * this.swet.m_21133_(Attributes.f_22279_)));
                }
            }
        }
    }

    public static class ConsumeGoal
    extends Goal {
        private final Swet swet;
        private int jumps = 0;
        private float chosenDegrees = 0.0f;

        public ConsumeGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            LivingEntity passenger;
            Object e;
            return this.swet.hasPrey() && (e = this.swet.m_20197_().get(0)) instanceof LivingEntity && !this.swet.isFriendlyTowardEntity(passenger = (LivingEntity)e);
        }

        public void m_8037_() {
            if (this.jumps <= 3) {
                if (this.swet.m_20096_()) {
                    this.swet.m_9236_().m_7605_((Entity)this.swet, (byte)71);
                    this.swet.m_5496_((SoundEvent)AetherSoundEvents.ENTITY_SWET_JUMP.get(), 1.0f, ((this.swet.m_217043_().m_188501_() - this.swet.m_217043_().m_188501_()) * 0.2f + 1.0f) * 0.8f);
                    this.chosenDegrees = this.swet.m_217043_().m_188503_(360);
                    if (this.jumps == 0) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 0.65, 0.0));
                    } else if (this.jumps == 1) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 0.75, 0.0));
                    } else if (this.jumps == 2) {
                        this.swet.m_20256_(this.swet.m_20184_().m_82520_(0.0, 1.55, 0.0));
                    } else {
                        ((Entity)this.swet.m_20197_().get(0)).m_8127_();
                        this.swet.spawnDissolveParticles();
                        this.swet.m_146870_();
                    }
                    if (!this.swet.getMidJump()) {
                        ++this.jumps;
                    }
                }
                if (!this.swet.wasOnGround && this.swet.getJumpTimer() < 6) {
                    if (this.jumps == 1) {
                        this.moveHorizontal(0.0f, 0.1f, this.chosenDegrees);
                    } else if (this.jumps == 2) {
                        this.moveHorizontal(0.0f, 0.15f, this.chosenDegrees);
                    } else if (this.jumps == 3) {
                        this.moveHorizontal(0.0f, 0.3f, this.chosenDegrees);
                    }
                }
            }
        }

        public void moveHorizontal(float strafe, float forward, float rotation) {
            float f = Mth.m_14207_((float)strafe) + Mth.m_14207_((float)forward);
            if ((f = Mth.m_14116_((float)f)) < 1.0f) {
                f = 1.0f;
            }
            float f1 = Mth.m_14031_((float)(rotation * ((float)Math.PI / 180)));
            float f2 = Mth.m_14089_((float)(rotation * ((float)Math.PI / 180)));
            this.swet.m_20334_((strafe *= f) * f2 - (forward *= f) * f1, this.swet.m_20184_().m_7098_(), forward * f2 + strafe * f1);
            MoveControl moveControl = this.swet.m_21566_();
            if (moveControl instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)moveControl;
                swetMoveControl.yRot = rotation % 360.0f;
            }
        }
    }

    public static class HuntGoal
    extends Goal {
        private final Swet swet;

        public HuntGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            block3: {
                block2: {
                    LivingEntity target = this.swet.m_5448_();
                    if (this.swet.hasPrey() || target == null || !target.m_6084_() || this.swet.isFriendlyTowardEntity(target)) break block2;
                    if (!(target instanceof Player)) break block3;
                    Player player = (Player)target;
                    if (!player.m_150110_().f_35934_) break block3;
                }
                return false;
            }
            return this.swet.m_21566_() instanceof SwetMoveControl;
        }

        public boolean m_8045_() {
            LivingEntity target = this.swet.m_5448_();
            if (this.swet.hasPrey() || target == null || !target.m_6084_()) {
                return false;
            }
            if (target instanceof Player) {
                Player player = (Player)target;
                if (player.m_150110_().f_35934_) {
                    return false;
                }
            }
            return !this.swet.isFriendlyTowardEntity(target);
        }

        public void m_8037_() {
            MoveControl moveControl = this.swet.m_21566_();
            if (moveControl instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)moveControl;
                LivingEntity target = this.swet.m_5448_();
                if (target != null) {
                    this.swet.m_21391_((Entity)target, 10.0f, 10.0f);
                    swetMoveControl.setDirection(this.swet.m_146908_(), true);
                    if (this.swet.m_20191_().m_82381_(target.m_20191_())) {
                        this.swet.consumePassenger(target);
                    }
                }
            }
        }
    }

    public static class SwetRandomDirectionGoal
    extends Goal {
        private final Swet swet;
        private float chosenDegrees;
        private int nextRandomizeTime;

        public SwetRandomDirectionGoal(Swet swet) {
            this.swet = swet;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return this.swet.m_5448_() == null && (this.swet.m_20096_() || this.swet.isInFluidType() || this.swet.m_21023_(MobEffects.f_19620_)) && this.swet.m_21566_() instanceof SwetMoveControl;
        }

        public void m_8037_() {
            SwetMoveControl moveHelperController = (SwetMoveControl)this.swet.m_21566_();
            float rot = moveHelperController.yRot;
            Vec3 offset = new Vec3(-Math.sin(rot * ((float)Math.PI / 180)) * 2.0, 0.0, Math.cos(rot * ((float)Math.PI / 180)) * 2.0);
            BlockPos offsetPos = BlockPos.m_274446_((Position)this.swet.m_20182_().m_82549_(offset));
            if (this.swet.m_9236_().m_6924_(Heightmap.Types.WORLD_SURFACE, offsetPos.m_123341_(), offsetPos.m_123343_()) < offsetPos.m_123342_() - this.swet.m_6056_()) {
                this.nextRandomizeTime = this.m_183277_(40 + this.swet.m_217043_().m_188503_(60));
                this.chosenDegrees += 180.0f;
                moveHelperController.setCanJump(false);
            } else {
                if (--this.nextRandomizeTime <= 0) {
                    this.nextRandomizeTime = this.m_183277_(40 + this.swet.m_217043_().m_188503_(60));
                    this.chosenDegrees = this.swet.m_217043_().m_188503_(360);
                }
                moveHelperController.setCanJump(true);
            }
            moveHelperController.setDirection(this.chosenDegrees, false);
        }
    }

    public static class SwetKeepOnJumpingGoal
    extends Goal {
        private final Swet swet;

        public SwetKeepOnJumpingGoal(Swet swetEntity) {
            this.swet = swetEntity;
            this.m_7021_(EnumSet.of(Goal.Flag.JUMP, Goal.Flag.MOVE));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean m_8036_() {
            if (this.swet.m_20159_()) return false;
            MoveControl moveControl = this.swet.m_21566_();
            if (!(moveControl instanceof SwetMoveControl)) return false;
            SwetMoveControl moveHelperController = (SwetMoveControl)moveControl;
            if (!moveHelperController.canJump) return false;
            return true;
        }

        public void m_8037_() {
            MoveControl movecontrol = this.swet.m_21566_();
            if (movecontrol instanceof SwetMoveControl) {
                SwetMoveControl swetMoveControl = (SwetMoveControl)movecontrol;
                swetMoveControl.setWantedMovement(1.0);
            }
        }
    }
}

