/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.entity.miscellaneous;

import com.aetherteam.aether.entity.EntityUtil;
import com.aetherteam.aether.mixin.mixins.common.accessor.ServerGamePacketListenerImplAccessor;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.vehicle.DismountHelper;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.network.NetworkHooks;

public class Parachute
extends Entity {
    public Parachute(EntityType<? extends Parachute> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = this.m_20185_();
        this.f_19855_ = this.m_20186_();
        this.f_19856_ = this.m_20189_();
    }

    protected void m_8097_() {
    }

    public void m_8119_() {
        super.m_8119_();
        LivingEntity passenger = this.m_6688_();
        if (passenger != null) {
            this.m_245125_();
            this.moveParachute(passenger);
            this.spawnExplosionParticle();
            if (this.m_20096_() || this.isInFluidType()) {
                this.m_20153_();
                this.die();
            }
        } else {
            this.die();
        }
    }

    public void moveParachute(LivingEntity passenger) {
        if (this.m_20160_()) {
            this.m_146922_(passenger.m_146908_());
            this.f_19859_ = this.m_146908_();
            this.m_146926_(passenger.m_146909_() * 0.5f);
            this.m_19915_(this.m_146908_(), this.m_146909_());
            float x = passenger.f_20900_ * 0.5f;
            float z = passenger.f_20902_;
            if (z <= 0.0f) {
                z *= 0.25f;
            }
            Vec3 travelVec = new Vec3((double)x, (double)passenger.f_20901_, (double)z);
            AttributeInstance gravity = passenger.m_21051_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            double gravityModifier = gravity != null ? gravity.m_22135_() : 0.08;
            Vec3 movement = this.calculateMovement(travelVec);
            double y = movement.m_7098_();
            if (!this.m_20068_()) {
                y -= gravityModifier;
            }
            double fallSpeed = Math.max(gravityModifier * -3.125, -0.25);
            this.m_20334_(movement.m_7096_() * (double)0.91f, Math.max(y *= 0.98, fallSpeed), movement.m_7094_() * (double)0.91f);
            if (passenger instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)passenger;
                ServerGamePacketListenerImplAccessor serverGamePacketListenerImplAccessor = (ServerGamePacketListenerImplAccessor)serverPlayer.f_8906_;
                serverGamePacketListenerImplAccessor.aether$setAboveGroundTickCount(0);
                serverGamePacketListenerImplAccessor.aether$setAboveGroundVehicleTickCount(0);
            }
        }
    }

    public Vec3 calculateMovement(Vec3 vec3) {
        float speed = 0.03f;
        this.m_19920_(speed, vec3);
        this.m_6478_(MoverType.SELF, this.m_20184_());
        return this.m_20184_();
    }

    public void die() {
        this.spawnExplosionParticle();
        if (!this.m_9236_().m_5776_()) {
            this.m_6074_();
        }
    }

    public void spawnExplosionParticle() {
        if (!this.m_9236_().m_5776_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)70);
        }
    }

    protected boolean m_7341_(Entity entity) {
        return true;
    }

    public boolean canRiderInteract() {
        return false;
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public double m_6048_() {
        return 1.35;
    }

    public Vec3 m_7688_(LivingEntity passenger) {
        Direction direction = this.m_6374_();
        if (direction.m_122434_() == Direction.Axis.Y) {
            return this.m_20182_().m_82520_(0.0, 0.5, 0.0);
        }
        Vec3 dismountLocation = this.m_20182_().m_82520_(0.0, 0.5, 0.0);
        if (!DismountHelper.m_38456_((CollisionGetter)this.m_9236_(), (LivingEntity)passenger, (AABB)passenger.m_6095_().m_20680_().m_20393_(dismountLocation))) {
            return this.m_20182_().m_82520_(0.0, 1.0, 0.0).m_82549_(new Vec3((double)direction.m_122429_(), (double)direction.m_122430_(), (double)direction.m_122431_()).m_82490_(0.5).m_82548_());
        }
        return dismountLocation;
    }

    @Nullable
    public LivingEntity m_6688_() {
        Entity entity = this.m_146895_();
        if (entity instanceof LivingEntity) {
            LivingEntity rider = (LivingEntity)entity;
            return rider;
        }
        return null;
    }

    public boolean m_6097_() {
        return false;
    }

    public boolean m_6087_() {
        return !this.m_213877_();
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7822_(byte id) {
        if (id == 70) {
            EntityUtil.spawnMovementExplosionParticles(this);
        } else {
            super.m_7822_(id);
        }
    }

    protected void m_7380_(CompoundTag tag) {
    }

    protected void m_7378_(CompoundTag tag) {
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

