/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.data.resources.builders;

import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.data.resources.AetherMobCategory;
import com.aetherteam.aether.data.resources.registries.AetherBiomes;
import com.aetherteam.aether.data.resources.registries.AetherPlacedFeatures;
import com.aetherteam.aether.entity.AetherEntityTypes;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.sounds.Music;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.carver.ConfiguredWorldCarver;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class AetherBiomeBuilders {
    public static Biome skyrootMeadowBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_MEADOW_TREES_PLACEMENT));
    }

    public static Biome skyrootGroveBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_GROVE_TREES_PLACEMENT));
    }

    public static Biome skyrootWoodlandBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_WOODLAND_TREES_PLACEMENT));
    }

    public static Biome skyrootForestBiome(HolderGetter<PlacedFeature> placedFeatures, HolderGetter<ConfiguredWorldCarver<?>> worldCarvers) {
        return AetherBiomeBuilders.makeDefaultBiome(new BiomeGenerationSettings.Builder(placedFeatures, worldCarvers).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.SKYROOT_FOREST_TREES_PLACEMENT));
    }

    public static Biome makeDefaultBiome(BiomeGenerationSettings.Builder builder) {
        return AetherBiomeBuilders.fullDefinition(false, 0.8f, 0.0f, new BiomeSpecialEffects.Builder().m_48019_(9671612).m_48040_(0xC0C0FF).m_48034_(4159204).m_48037_(329011).m_48045_(11665355).m_48043_(11665355).m_48031_(BiomeSpecialEffects.GrassColorModifier.NONE).m_48021_(new Music((Holder)AetherSoundEvents.MUSIC_AETHER.getHolder().orElseThrow(), 12000, 24000, true)).m_48018_(), new MobSpawnSettings.Builder().m_48370_((EntityType)AetherEntityTypes.COCKATRICE.get(), 0.5, 0.15).m_48370_((EntityType)AetherEntityTypes.ZEPHYR.get(), 0.6, 0.16).m_48370_((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 0.4, 0.11).m_48370_((EntityType)AetherEntityTypes.BLUE_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 0.5, 0.1).m_48370_((EntityType)AetherEntityTypes.WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 0.4, 0.1).m_48370_((EntityType)AetherEntityTypes.AERWHALE.get(), 0.5, 0.11).m_48376_(AetherMobCategory.AETHER_DARKNESS_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.COCKATRICE.get(), 8, 1, 1)).m_48376_(AetherMobCategory.AETHER_SKY_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.ZEPHYR.get(), 20, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AECHOR_PLANT.get(), 7, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.BLUE_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.GOLDEN_SWET.get(), 6, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.WHIRLWIND.get(), 3, 1, 1)).m_48376_(AetherMobCategory.AETHER_SURFACE_MONSTER, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.EVIL_WHIRLWIND.get(), 1, 1, 1)).m_48376_(AetherMobCategory.AETHER_AERWHALE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERWHALE.get(), 10, 1, 1)).m_48368_(0.25f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.PHYG.get(), 10, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.SHEEPUFF.get(), 12, 3, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.FLYING_COW.get(), 12, 2, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.AERBUNNY.get(), 11, 3, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)AetherEntityTypes.MOA.get(), 8, 1, 3)).m_48381_(), builder.m_255155_(GenerationStep.Decoration.RAW_GENERATION, AetherPlacedFeatures.QUICKSOIL_SHELF_PLACEMENT).m_255155_(GenerationStep.Decoration.LAKES, AetherPlacedFeatures.WATER_LAKE_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_AETHER_DIRT_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_ICESTONE_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_AMBROSIUM_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_ZANITE_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_GRAVITITE_BURIED_PLACEMENT).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, AetherPlacedFeatures.ORE_GRAVITITE_PLACEMENT).m_255155_(GenerationStep.Decoration.FLUID_SPRINGS, AetherPlacedFeatures.WATER_SPRING_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.HOLIDAY_TREE_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.GRASS_PATCH_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.TALL_GRASS_PATCH_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.WHITE_FLOWER_PATCH_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.PURPLE_FLOWER_PATCH_PLACEMENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, AetherPlacedFeatures.BERRY_BUSH_PATCH_PLACEMENT).m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.CRYSTAL_ISLAND_PLACEMENT).m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.COLD_AERCLOUD_PLACEMENT).m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.BLUE_AERCLOUD_PLACEMENT).m_255155_(GenerationStep.Decoration.TOP_LAYER_MODIFICATION, AetherPlacedFeatures.GOLDEN_AERCLOUD_PLACEMENT).m_255380_(), Biome.TemperatureModifier.NONE);
    }

    public static Biome fullDefinition(boolean precipitation, float temperature, float downfall, BiomeSpecialEffects effects, MobSpawnSettings spawnSettings, BiomeGenerationSettings generationSettings, Biome.TemperatureModifier temperatureModifier) {
        return new Biome.BiomeBuilder().m_264558_(precipitation).m_47609_(temperature).m_47611_(downfall).m_47603_(effects).m_47605_(spawnSettings).m_47601_(generationSettings).m_47599_(temperatureModifier).m_47592_();
    }

    public static BiomeSource buildAetherBiomeSource(HolderGetter<Biome> biomes) {
        Climate.Parameter fullRange = Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f);
        Climate.Parameter temps1 = Climate.Parameter.m_186822_((float)-1.0f, (float)-0.8f);
        Climate.Parameter temps2 = Climate.Parameter.m_186822_((float)-0.8f, (float)0.0f);
        Climate.Parameter temps3 = Climate.Parameter.m_186822_((float)0.0f, (float)0.4f);
        Climate.Parameter temps4 = Climate.Parameter.m_186822_((float)0.4f, (float)0.93f);
        Climate.Parameter temps5 = Climate.Parameter.m_186822_((float)0.93f, (float)0.94f);
        Climate.Parameter temps6 = Climate.Parameter.m_186822_((float)0.94f, (float)1.0f);
        return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList(List.of(Pair.of((Object)new Climate.ParameterPoint(temps1, fullRange, fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps2, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps2, Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.m_186822_((float)-1.0f, (float)0.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.m_186822_((float)0.0f, (float)0.8f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps3, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps4, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.1f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps4, Climate.Parameter.m_186822_((float)-0.1f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.6f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.m_186822_((float)-0.6f, (float)-0.3f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_GROVE)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.m_186822_((float)-0.3f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_FOREST)), Pair.of((Object)new Climate.ParameterPoint(temps6, Climate.Parameter.m_186822_((float)-1.0f, (float)-0.1f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_MEADOW)), Pair.of((Object)new Climate.ParameterPoint(temps6, Climate.Parameter.m_186822_((float)-0.1f, (float)0.8f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_WOODLAND)), Pair.of((Object)new Climate.ParameterPoint(temps5, Climate.Parameter.m_186822_((float)0.8f, (float)1.0f), fullRange, fullRange, fullRange, fullRange, 0L), (Object)biomes.m_255043_(AetherBiomes.SKYROOT_FOREST)))));
    }
}

