/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.machine.entity;

import earth.terrarium.ad_astra.common.block.machine.entity.AbstractMachineBlockEntity;
import earth.terrarium.ad_astra.common.recipe.NasaWorkbenchRecipe;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import earth.terrarium.ad_astra.common.screen.menu.NasaWorkbenchMenu;
import earth.terrarium.ad_astra.common.util.ModUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NasaWorkbenchBlockEntity
extends AbstractMachineBlockEntity {
    public NasaWorkbenchBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntityTypes.NASA_WORKBENCH.get(), blockPos, blockState);
    }

    @Override
    @Nullable
    public AbstractContainerMenu m_7208_(int syncId, @NotNull Inventory inv, @NotNull Player player) {
        return new NasaWorkbenchMenu(syncId, inv, this);
    }

    @Override
    public int getInventorySize() {
        return 15;
    }

    @Override
    public boolean m_7155_(int slot, ItemStack stack, Direction dir) {
        return slot < 14;
    }

    @Override
    public boolean m_7157_(int slot, ItemStack stack, Direction dir) {
        return false;
    }

    public void spawnWorkingParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.spawnForcedParticles(serverWorld, ParticleTypes.f_123797_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 10, 0.1, 0.1, 0.1, 0.1);
        }
    }

    public void spawnResultParticles() {
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)level;
            BlockPos pos = this.m_58899_();
            ModUtils.spawnForcedParticles(serverWorld, ParticleTypes.f_123767_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.5, (double)pos.m_123343_() + 0.5, 100, 0.1, 0.1, 0.1, 0.7);
            this.f_58857_.m_5594_(null, pos, SoundEvents.f_12513_, SoundSource.NEUTRAL, 1.0f, 1.0f);
        }
    }

    public void spawnOutputAndClearInput(NasaWorkbenchRecipe recipe) {
        BlockPos pos = this.m_58899_();
        ItemEntity itemEntity = new ItemEntity(this.f_58857_, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 2.5, (double)pos.m_123343_() + 0.5, recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_());
        itemEntity.m_20256_(itemEntity.m_20184_().m_82490_(0.5));
        this.f_58857_.m_7967_((Entity)itemEntity);
        itemEntity.m_32060_();
        for (int i = 0; i < this.getItems().size() - 1 && i < recipe.getHolders().size(); ++i) {
            ((ItemStack)this.getItems().get(i)).m_41774_(recipe.getHolders().get(i).count());
        }
        this.m_6596_();
    }

    @Override
    public void tick() {
        if (!this.f_58857_.f_46443_) {
            for (ItemStack input : this.getItems()) {
                if (input.m_41619_()) continue;
                NasaWorkbenchRecipe recipe = NasaWorkbenchRecipe.findFirst(this.f_58857_, f -> f.test(input));
                if (recipe != null) {
                    this.spawnWorkingParticles();
                    this.setActive(true);
                    continue;
                }
                this.setActive(false);
            }
        }
    }
}

