/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.networking.base.Packet;
import earth.terrarium.ad_astra.AdAstra;
import earth.terrarium.ad_astra.client.AdAstraClient;
import earth.terrarium.ad_astra.client.resourcepack.Galaxy;
import earth.terrarium.ad_astra.client.resourcepack.PlanetRing;
import earth.terrarium.ad_astra.client.resourcepack.SolarSystem;
import earth.terrarium.ad_astra.client.screen.util.ButtonType;
import earth.terrarium.ad_astra.client.screen.util.Category;
import earth.terrarium.ad_astra.client.screen.util.CustomButton;
import earth.terrarium.ad_astra.client.screen.util.ScreenUtils;
import earth.terrarium.ad_astra.common.config.AdAstraConfig;
import earth.terrarium.ad_astra.common.data.ButtonColor;
import earth.terrarium.ad_astra.common.data.Planet;
import earth.terrarium.ad_astra.common.data.PlanetData;
import earth.terrarium.ad_astra.common.networking.NetworkHandler;
import earth.terrarium.ad_astra.common.networking.packet.messages.ServerboundCreateSpaceStationPacket;
import earth.terrarium.ad_astra.common.networking.packet.messages.ServerboundTeleportToPlanetPacket;
import earth.terrarium.ad_astra.common.recipe.SpaceStationRecipe;
import earth.terrarium.ad_astra.common.screen.menu.PlanetSelectionMenu;
import earth.terrarium.ad_astra.common.util.MathUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;

@MethodsReturnNonnullByDefault
public class PlanetSelectionScreen
extends Screen
implements MenuAccess<PlanetSelectionMenu> {
    public static final ResourceLocation SMALL_MENU_LIST = new ResourceLocation("ad_astra", "textures/gui/selection_menu.png");
    public static final ResourceLocation LARGE_MENU_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/selection_menu_large.png");
    public static final ResourceLocation SCROLL_BAR = new ResourceLocation("ad_astra", "textures/gui/scroll_bar.png");
    public static final int SCROLL_BAR_X = 92;
    public static final int SCROLL_SENSITIVITY = 5;
    public static final Component CATALOG_TEXT = ScreenUtils.createText("catalog");
    public static final Component BACK_TEXT = ScreenUtils.createText("back");
    public static final Component PLANET_TEXT = ScreenUtils.createText("planet");
    public static final Component MOON_TEXT = ScreenUtils.createText("moon");
    public static final Component ORBIT_TEXT = ScreenUtils.createText("orbit");
    public static final Component NO_GRAVITY_TEXT = ScreenUtils.createText("no_gravity");
    public static final Component SPACE_STATION_TEXT = ScreenUtils.createText("space_station");
    public static final Component SOLAR_SYSTEM_TEXT = ScreenUtils.createText("solar_system");
    public static final Component GALAXY_TEXT = ScreenUtils.createText("galaxy");
    public static final Component CATEGORY_TEXT = ScreenUtils.createText("category");
    public static final Component PROVIDED_TEXT = ScreenUtils.createText("provided");
    public static final Component TYPE_TEXT = ScreenUtils.createText("type");
    public static final Component GRAVITY_TEXT = ScreenUtils.createText("gravity");
    public static final Component OXYGEN_TEXT = ScreenUtils.createText("oxygen");
    public static final Component TEMPERATURE_TEXT = ScreenUtils.createText("temperature");
    public static final Component OXYGEN_TRUE_TEXT = ScreenUtils.createText("oxygen.true");
    public static final Component OXYGEN_FALSE_TEXT = ScreenUtils.createText("oxygen.false");
    public static final Component ITEM_REQUIREMENT_TEXT = ScreenUtils.createText("item_requirement");
    public final List<Pair<ItemStack, Integer>> ingredients = new ArrayList<Pair<ItemStack, Integer>>();
    final Set<Category> solarSystemsCategories = new HashSet<Category>();
    final Set<Category> galaxyCategories = new HashSet<Category>();
    private final PlanetSelectionMenu handler;
    private final Map<Category, LinkedList<CustomButton>> categoryButtons = new HashMap<Category, LinkedList<CustomButton>>();
    public int minScrollY = 177;
    public int maxScrollY = 274;
    private Category currentCategory = Category.GALAXY_CATEGORY;
    private float guiTime;
    private Button scrollBar;

    public PlanetSelectionScreen(PlanetSelectionMenu handler, Inventory inventory, Component title) {
        super(title);
        this.handler = handler;
        if (AdAstraClient.galaxies.size() <= 1) {
            this.currentCategory = Category.MILKY_WAY_CATEGORY;
        }
        this.guiTime = handler.getPlayer().m_9236_().m_213780_().m_188501_() * 100000.0f;
        SpaceStationRecipe.getRecipes(handler.getPlayer().m_9236_()).forEach(recipe -> {
            if (recipe != null) {
                for (int i = 0; i < recipe.m_7527_().size(); ++i) {
                    if (((Ingredient)recipe.m_7527_().get(i)).m_43908_().length == 0) {
                        return;
                    }
                    ItemStack stack = ((Ingredient)recipe.m_7527_().get(i)).m_43908_()[0].m_41777_();
                    stack.m_41714_(stack.m_41786_());
                    stack.m_41764_(0);
                    for (ItemStack slot : inventory.f_35974_) {
                        if (slot == null || slot.m_41619_() || !((Ingredient)recipe.m_7527_().get(i)).test(slot)) continue;
                        stack.m_41764_(inventory.m_18947_(slot.m_41720_()));
                    }
                    this.ingredients.add((Pair<ItemStack, Integer>)Pair.of((Object)stack, (Object)recipe.getHolders().get(i).count()));
                }
            }
        });
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        this.guiTime += delta;
        this.renderBackground(graphics, mouseX, mouseY, delta);
        super.m_88315_(graphics, mouseX, mouseY, delta);
        graphics.m_280430_(this.f_96547_, CATALOG_TEXT, 29, (int)((float)this.f_96544_ / 2.0f - 71.5f), -1);
    }

    private void drawBackground(GuiGraphics graphics) {
        graphics.m_280509_(0, 0, this.f_96543_, this.f_96544_, -16776167);
        for (int i = 0; i < this.f_96543_ / 24; ++i) {
            ScreenUtils.drawLine(i * 24, this.f_96543_ + i * 24, 0, this.f_96543_, -15784615);
            ScreenUtils.drawLine(0, this.f_96543_ - i * 24, i * 24, this.f_96543_, -15784615);
            ScreenUtils.drawLine(i * 24, 0, 0, i * 24, -15784615);
            ScreenUtils.drawLine(this.f_96543_, i * 24, i * 24, this.f_96543_, -15784615);
        }
        RenderSystem.enableBlend();
    }

    private void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
        super.m_280273_(graphics);
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        this.drawBackground(graphics);
        int currentPage = this.getPage();
        SolarSystem solarSystem = null;
        HashSet<PlanetRing> planetRings = new HashSet<PlanetRing>();
        for (SolarSystem system : AdAstraClient.solarSystems) {
            if (!this.currentCategory.id().equals((Object)system.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)system.solarSystem()))) continue;
            solarSystem = system;
            break;
        }
        for (PlanetRing ring : AdAstraClient.planetRings) {
            if (!this.currentCategory.id().equals((Object)ring.solarSystem()) && (this.currentCategory.parent() == null || !this.currentCategory.parent().id().equals((Object)ring.solarSystem()))) continue;
            planetRings.add(ring);
        }
        if (currentPage == 1) {
            AdAstraClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)this.currentCategory.id())).findFirst().ifPresent(galaxy -> ScreenUtils.addRotatingTexture(this, graphics, -125, -125, galaxy.scale(), galaxy.scale(), galaxy.texture(), 0.6f));
        } else if (solarSystem != null) {
            ScreenUtils.addTexture(graphics, (this.f_96543_ - solarSystem.sunScale()) / 2, (this.f_96544_ - solarSystem.sunScale()) / 2, solarSystem.sunScale(), solarSystem.sunScale(), solarSystem.sun());
            for (PlanetRing ring : planetRings) {
                ScreenUtils.drawCircle((float)this.f_96543_ / 2.0f, (float)this.f_96544_ / 2.0f, ring.radius() * 24.0, 75, solarSystem.ringColour());
            }
            for (PlanetRing ring : planetRings) {
                int coordinates = (int)(ring.radius() * 17.0 - (double)ring.scale() / 1.9);
                ScreenUtils.addRotatingTexture(this, graphics, coordinates, coordinates, ring.scale(), ring.scale(), ring.texture(), 365.0f / (float)ring.speed());
            }
        }
        if (currentPage == 3) {
            ScreenUtils.addTexture(graphics, 0, this.f_96544_ / 2 - 88, 215, 177, LARGE_MENU_TEXTURE);
            this.scrollBar.m_252865_(210);
        } else {
            ScreenUtils.addTexture(graphics, 0, this.f_96544_ / 2 - 88, 105, 177, SMALL_MENU_LIST);
            this.scrollBar.m_252865_(92);
        }
        this.categoryButtons.forEach((category, buttons) -> buttons.forEach(button -> {
            button.f_93624_ = this.currentCategory.equals(category);
        }));
        CustomButton backButton = this.categoryButtons.get(Category.BACK).get(0);
        boolean bl = backButton.f_93624_ = this.currentCategory.parent() != null;
        if (currentPage == 1 && AdAstraClient.galaxies.size() <= 1) {
            backButton.f_93624_ = false;
        }
        if (this.categoryButtons.containsKey(this.currentCategory)) {
            this.scrollBar.f_93624_ = this.categoryButtons.get(this.currentCategory).size() > (currentPage == 3 ? 13 : 5);
        }
        this.minScrollY = this.f_96544_ / 2 - 33;
        this.maxScrollY = this.f_96544_ / 2 + 64;
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.disableScissor();
    }

    protected void m_7856_() {
        super.m_7856_();
        LinkedList<CustomButton> backButtonList = new LinkedList<CustomButton>();
        CustomButton backButton = new CustomButton(10, this.f_96544_ / 2 - 36, BACK_TEXT, ButtonType.NORMAL, ButtonColor.BLUE, TooltipType.NONE, null, pressed -> this.onNavigationButtonClick(this.currentCategory.parent()));
        this.m_142416_((GuiEventListener)backButton);
        backButtonList.add(backButton);
        this.categoryButtons.put(Category.BACK, backButtonList);
        ArrayList<Planet> planets = new ArrayList<Planet>(PlanetData.planets());
        planets.sort(Comparator.comparing(g -> g.translation().substring(Math.abs(g.translation().indexOf(".text")))));
        planets.forEach(planet -> {
            if (this.handler.getTier() >= planet.rocketTier()) {
                Category galaxyCategory = new Category(planet.galaxy(), Category.GALAXY_CATEGORY);
                Category solarSystemCategory = new Category(planet.solarSystem(), galaxyCategory);
                Category planetCategory = new Category(planet.parentWorld() == null ? planet.level().m_135782_() : planet.parentWorld().m_135782_(), solarSystemCategory);
                MutableComponent label = Component.m_237115_((String)planet.translation());
                this.galaxyCategories.add(galaxyCategory);
                this.solarSystemsCategories.add(solarSystemCategory);
                List<String> disabledPlanets = List.of(AdAstraConfig.disabledPlanets.split(","));
                if (planet.parentWorld() == null && !disabledPlanets.contains(planet.level().m_135782_().toString())) {
                    this.createNavigationButton((Component)label, solarSystemCategory, ButtonType.NORMAL, planet.buttonColor(), TooltipType.CATEGORY, (Planet)planet, planetCategory);
                }
                this.createTeleportButton(1, (Component)label, planetCategory, ButtonType.NORMAL, planet.buttonColor(), TooltipType.PLANET, (Planet)planet, planet.level());
                this.createTeleportButton(2, ORBIT_TEXT, planetCategory, ButtonType.SMALL, planet.buttonColor(), TooltipType.ORBIT, null, planet.orbitWorld());
                this.createSpaceStationTeleportButton(3, SPACE_STATION_TEXT, planetCategory, ButtonType.NORMAL, planet.buttonColor(), planet.orbitWorld());
            }
        });
        this.galaxyCategories.forEach(this::createGalaxyButton);
        this.solarSystemsCategories.forEach(this::createSolarSystemButton);
        this.scrollBar = new Button(92, this.minScrollY, 4, 8, Component.m_130674_((String)""), pressed -> {}, Supplier::get){

            public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float delta) {
                if (this.f_93624_) {
                    RenderSystem.setShader(GameRenderer::m_172817_);
                    RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    RenderSystem.enableBlend();
                    RenderSystem.defaultBlendFunc();
                    RenderSystem.enableDepthTest();
                    graphics.m_280163_(SCROLL_BAR, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                }
            }
        };
        this.m_142416_((GuiEventListener)this.scrollBar);
    }

    public boolean m_7043_() {
        return true;
    }

    public void onNavigationButtonClick(Category target) {
        this.resetButtonScroll();
        this.scrollBar.m_253211_(this.minScrollY);
        this.currentCategory = target;
    }

    public void createGalaxyButton(Category galaxyCategory) {
        Component label = ScreenUtils.createText(galaxyCategory.id());
        Galaxy galaxy = AdAstraClient.galaxies.stream().filter(g -> g.galaxy().equals((Object)galaxyCategory.id())).findFirst().orElse(null);
        this.createNavigationButton(label, Category.GALAXY_CATEGORY, ButtonType.LARGE, galaxy != null ? galaxy.buttonColor() : ButtonColor.PURPLE, TooltipType.GALAXY, null, galaxyCategory);
    }

    public void createSolarSystemButton(Category solarSystemCategory) {
        Component label = ScreenUtils.createText(solarSystemCategory.id());
        SolarSystem solarSystem = AdAstraClient.solarSystems.stream().filter(g -> g.solarSystem().equals((Object)solarSystemCategory.id())).findFirst().orElse(null);
        this.createNavigationButton(label, solarSystemCategory.parent(), ButtonType.NORMAL, solarSystem != null ? solarSystem.buttonColor() : ButtonColor.BLUE, TooltipType.SOLAR_SYSTEM, null, solarSystemCategory);
    }

    public void createNavigationButton(Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Category target) {
        this.createButton(label, category, size, colour, tooltip, planetInfo, press -> this.onNavigationButtonClick(target));
    }

    public void createSpaceStationTeleportButton(int row, Component label, Category category, ButtonType size, ButtonColor colour, ResourceKey<Level> level) {
        this.createTeleportButton(row, label, category, size, colour, TooltipType.SPACE_STATION, null, level, press -> {
            if (!this.handler.getPlayer().m_7500_() && !this.handler.getPlayer().m_5833_()) {
                for (Pair<ItemStack, Integer> ingredient : this.ingredients) {
                    boolean isEnough = ((ItemStack)ingredient.getFirst()).m_41613_() >= (Integer)ingredient.getSecond();
                    if (isEnough) continue;
                    return;
                }
            }
            if (this.f_96541_ != null && this.f_96541_.f_91074_ != null) {
                this.f_96541_.f_91074_.m_6915_();
                NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundCreateSpaceStationPacket(level.m_135782_()));
                this.teleportPlayer(level);
            }
        });
    }

    public void createTeleportButton(int row, Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, ResourceKey<Level> level) {
        this.createTeleportButton(row, label, category, size, colour, tooltip, planetInfo, level, press -> this.teleportPlayer(level));
    }

    public void createTeleportButton(int row, Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, ResourceKey<Level> level, Consumer<Button> onClick) {
        int newRow = 0;
        if (row == 2) {
            newRow = 76;
        } else if (row == 3) {
            newRow = 118;
        }
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int column = this.getColumn(category) - (row - 1) * 22;
        this.createButton(newRow + 10, column -= 44 * (buttons.size() / 3), label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public void teleportPlayer(ResourceKey<Level> level) {
        this.f_96541_.f_91074_.m_6915_();
        NetworkHandler.CHANNEL.sendToServer((Packet)new ServerboundTeleportToPlanetPacket(level.m_135782_()));
    }

    public CustomButton createButton(Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        return this.createButton(10, label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public CustomButton createButton(int row, Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        int column = this.getColumn(category);
        return this.createButton(row, column, label, category, size, colour, tooltip, planetInfo, onClick);
    }

    public CustomButton createButton(int row, int column, Component label, Category category, ButtonType size, ButtonColor colour, TooltipType tooltip, Planet planetInfo, Consumer<Button> onClick) {
        LinkedList<CustomButton> buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        CustomButton button = new CustomButton(row, column, label, size, colour, tooltip, planetInfo, onClick::accept);
        this.m_142416_((GuiEventListener)button);
        buttons.add(button);
        this.categoryButtons.put(category, buttons);
        return button;
    }

    public boolean m_6050_(double mouseX, double mouseY, double amount) {
        for (Map.Entry<Category, LinkedList<CustomButton>> entry : this.categoryButtons.entrySet()) {
            if (!this.currentCategory.equals(entry.getKey())) continue;
            LinkedList<CustomButton> buttons = new LinkedList<CustomButton>();
            CustomButton backButton = this.categoryButtons.get(Category.BACK).get(0);
            buttons.add(backButton);
            buttons.addAll((Collection)entry.getValue());
            boolean isLargePage = this.getPage() == 3;
            int overflowButtons = buttons.size() - (isLargePage ? 13 : 5);
            if (overflowButtons <= 0) break;
            int referencePoint = backButton.m_252907_();
            int minThreshold = this.f_96544_ / 2 - 35;
            int maxThreshold = this.f_96544_ / 2 - 38 - overflowButtons * (isLargePage ? 7 : 21);
            int sensitivity = (int)(5.0 * amount);
            if (amount > 0.0) {
                if (referencePoint >= minThreshold) {
                    sensitivity = 0;
                }
            } else if (amount < 0.0 && referencePoint <= maxThreshold) {
                sensitivity = 0;
            }
            for (CustomButton button2 : buttons) {
                button2.m_253211_(button2.m_252907_() + sensitivity);
                if (referencePoint >= minThreshold) {
                    button2.m_253211_(button2.m_252907_() - Mth.m_14045_((int)(referencePoint - minThreshold), (int)-1, (int)1));
                    continue;
                }
                if (referencePoint > maxThreshold) continue;
                button2.m_253211_(button2.m_252907_() - Mth.m_14045_((int)(referencePoint - maxThreshold), (int)-1, (int)1));
            }
            float min = (float)maxThreshold / (float)minThreshold;
            float ratio = (float)backButton.m_252907_() / (float)minThreshold;
            ratio = MathUtil.invLerp(ratio, 1.0f, min);
            this.scrollBar.m_253211_((int)Mth.m_14179_((float)ratio, (float)this.maxScrollY, (float)this.minScrollY));
            this.scrollBar.m_253211_(Mth.m_14045_((int)this.scrollBar.m_252907_(), (int)this.minScrollY, (int)this.maxScrollY));
            break;
        }
        return super.m_6050_(mouseX, mouseY, amount);
    }

    public void resetButtonScroll() {
        this.categoryButtons.values().forEach(list -> list.forEach(button -> button.m_253211_(button.getStartY())));
    }

    private int getPage() {
        Category category = this.currentCategory;
        if (category.parent() == null) {
            return 0;
        }
        if (category.parent().parent() == null) {
            return 1;
        }
        if (category.parent().parent().parent() == null) {
            return 2;
        }
        if (category.parent().parent().parent().parent() == null) {
            return 3;
        }
        AdAstra.LOGGER.warn("Invalid page!");
        return 0;
    }

    public int getColumn(Category category) {
        LinkedList buttons = this.categoryButtons.getOrDefault(category, new LinkedList());
        int index = buttons.size() + 1;
        int startY = this.f_96544_ / 2 - 58;
        if (Category.GALAXY_CATEGORY.equals(category.parent()) && AdAstraClient.galaxies.size() <= 1) {
            return startY + 22 * index;
        }
        return startY + 22 * index + (category.parent() != null ? 22 : 0);
    }

    public float getGuiTime() {
        return this.guiTime;
    }

    public PlanetSelectionMenu getMenu() {
        return this.handler;
    }

    public List<Pair<ItemStack, Integer>> getIngredients() {
        return this.ingredients;
    }

    public void m_7379_() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft.f_91074_ != null && (minecraft.f_91074_.m_7500_() || minecraft.f_91074_.m_5833_())) {
            super.m_7379_();
        }
    }

    public void m_6574_(Minecraft minecraft, int width, int height) {
        this.categoryButtons.clear();
        this.resetButtonScroll();
        super.m_6574_(minecraft, width, height);
    }

    public static enum TooltipType {
        NONE,
        GALAXY,
        SOLAR_SYSTEM,
        CATEGORY,
        PLANET,
        ORBIT,
        SPACE_STATION;

    }
}

