/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.teamresourceful.resourcefullib.client.scissor.ClosingScissorBox;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import earth.terrarium.ad_astra.client.ClientPlatformUtils;
import earth.terrarium.botarium.common.fluid.base.FluidHolder;
import earth.terrarium.botarium.common.fluid.utils.ClientFluidHooks;
import earth.terrarium.botarium.common.fluid.utils.FluidHooks;
import java.awt.Rectangle;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.InventoryMenu;
import org.joml.Matrix4f;

public class GuiUtil {
    public static final int FIRE_WIDTH = 14;
    public static final int FIRE_HEIGHT = 14;
    public static final int SNOWFLAKE_WIDTH = 13;
    public static final int SNOWFLAKE_HEIGHT = 13;
    public static final int SUN_WIDTH = 21;
    public static final int SUN_HEIGHT = 21;
    public static final int HAMMER_WIDTH = 13;
    public static final int HAMMER_HEIGHT = 13;
    public static final int ENERGY_WIDTH = 13;
    public static final int ENERGY_HEIGHT = 46;
    public static final int FLUID_TANK_WIDTH = 14;
    public static final int FLUID_TANK_HEIGHT = 48;
    public static final int ARROW_WIDTH = 24;
    public static final int ARROW_HEIGHT = 17;
    public static final ResourceLocation FIRE_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/fire_on.png");
    public static final ResourceLocation SNOWFLAKE_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/snowflake.png");
    public static final ResourceLocation SUN_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/sun.png");
    public static final ResourceLocation HAMMER_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/hammer.png");
    public static final ResourceLocation ENERGY_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/energy_full.png");
    public static final ResourceLocation FLUID_TANK_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/fluid_tank.png");
    public static final ResourceLocation ARROW_TEXTURE = new ResourceLocation("ad_astra", "textures/gui/arrow.png");

    public static boolean isHovering(Rectangle bounds, double x, double y) {
        double left = bounds.getX();
        double right = left + bounds.getWidth();
        double top = bounds.getY();
        double bottom = top + bounds.getHeight();
        return left <= x && x < right && top <= y && y < bottom;
    }

    public static Rectangle getFluidTankBounds(int x, int y) {
        return new Rectangle(x, y, 14, 48);
    }

    public static Rectangle getHammerBounds(int x, int y) {
        return new Rectangle(x, y, 13, 13);
    }

    public static Rectangle getEnergyBounds(int x, int y) {
        return new Rectangle(x, y, 13, 46);
    }

    public static Rectangle getFireBounds(int x, int y) {
        return new Rectangle(x, y, 14, 14);
    }

    public static void drawEnergy(GuiGraphics graphics, int x, int y, long energy, long maxEnergy) {
        double ratio = maxEnergy > 0L ? (double)((float)energy / (float)maxEnergy) : 0.0;
        GuiUtil.drawVertical(graphics, x, y, 13, 46, ENERGY_TEXTURE, ratio);
    }

    public static void drawFluidTank(GuiGraphics graphics, int x, int y, long fluidCapacity, FluidHolder fluid) {
        double ratio = fluidCapacity > 0L ? (double)((float)fluid.getFluidAmount() / (float)fluidCapacity) : 0.0;
        GuiUtil.drawFluidTank(graphics, x, y, ratio, fluid);
    }

    public static void drawFluidTank(GuiGraphics graphics, int x, int y, double ratio, FluidHolder fluid) {
        GuiUtil.drawFluid(graphics, x, y, ratio, fluid);
        RenderSystem.enableBlend();
        GuiUtil.drawVertical(graphics, x, y, 14, 48, FLUID_TANK_TEXTURE, 1.0);
        RenderSystem.disableBlend();
    }

    private static void drawFluid(GuiGraphics graphics, int x, int y, double ratio, FluidHolder fluid) {
        if (fluid.isEmpty()) {
            return;
        }
        TextureAtlasSprite sprite = ClientFluidHooks.getFluidSprite((FluidHolder)fluid);
        int colour = ClientFluidHooks.getFluidColor((FluidHolder)fluid);
        int spriteHeight = sprite.m_245424_().m_245330_();
        RenderSystem.setShaderColor((float)((float)(colour >> 16 & 0xFF) / 255.0f), (float)((float)(colour >> 8 & 0xFF) / 255.0f), (float)((float)(colour & 0xFF) / 255.0f), (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)InventoryMenu.f_39692_);
        int calcHeight = (int)(49.0 * ratio);
        try (ClosingScissorBox ignored = RenderUtils.createScissorBox((Minecraft)Minecraft.m_91087_(), (PoseStack)graphics.m_280168_(), (int)x, (int)(y + 48 - calcHeight), (int)14, (int)calcHeight);){
            for (int i = 1; i < 4; ++i) {
                graphics.m_280159_(x + 1, 48 + y - spriteHeight * i, 0, 12, spriteHeight, sprite);
            }
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawFire(GuiGraphics graphics, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawVertical(graphics, x, y, 14, 14, FIRE_TEXTURE, ratio);
    }

    public static void drawSnowflake(GuiGraphics graphics, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(graphics, x, y, 13, 13, SNOWFLAKE_TEXTURE, ratio);
    }

    public static void drawSun(GuiGraphics graphics, int x, int y) {
        GuiUtil.drawHorizontal(graphics, x, y, 21, 21, SUN_TEXTURE, 1.0);
    }

    public static void drawHammer(GuiGraphics graphics, int x, int y, int burnTime, int totalBurnTime) {
        double ratio = totalBurnTime > 0 ? (double)((float)burnTime / (float)totalBurnTime) : 0.0;
        GuiUtil.drawHorizontal(graphics, x, y, 13, 13, HAMMER_TEXTURE, ratio);
    }

    public static void drawVertical(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        graphics.m_280163_(resource, x, y + remainHeight, 0.0f, (float)remainHeight, width, ratioHeight, width, height);
    }

    public static void drawVerticalReverse(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioHeight = (int)Math.ceil((double)height * ratio);
        int remainHeight = height - ratioHeight;
        graphics.m_280163_(resource, x, y, 0.0f, 0.0f, width, remainHeight, width, height);
    }

    public static void drawHorizontal(GuiGraphics graphics, int x, int y, int width, int height, ResourceLocation resource, double ratio) {
        int ratioWidth = (int)Math.ceil((double)width * ratio);
        graphics.m_280163_(resource, x, y, 0.0f, 0.0f, ratioWidth, height, width, height);
    }

    public static void drawEnergyTooltip(GuiGraphics graphics, long energy, long energyCapacity, int mouseX, int mouseY) {
        graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"gauge_text.ad_astra.storage", (Object[])new Object[]{Float.valueOf(Mth.m_14036_((float)energy, (float)0.0f, (float)energyCapacity)), energyCapacity}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)), mouseX, mouseY);
    }

    public static void drawTankTooltip(GuiGraphics graphics, FluidHolder tank, long capacity, int mouseX, int mouseY) {
        graphics.m_280557_(Minecraft.m_91087_().f_91062_, (Component)Component.m_237110_((String)"gauge_text.ad_astra.liquid_storage", (Object[])new Object[]{FluidHooks.toMillibuckets((long)tank.getFluidAmount()), FluidHooks.toMillibuckets((long)capacity)}).m_6270_(Style.f_131099_.m_131140_(ChatFormatting.GOLD)).m_7220_(Component.m_130674_((String)", ")).m_7220_(ClientPlatformUtils.getFluidTranslation(tank.getFluid())), mouseX, mouseY);
    }

    public static class FloatGuiComponent {
        public static void drawTexture(GuiGraphics graphics, float x, float y, float u, float v, int width, int height, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(graphics, x, y, width, height, u, v, width, height, textureWidth, textureHeight);
        }

        public static void drawTexture(GuiGraphics graphics, float x, float y, int width, int height, float u, float v, int regionWidth, int regionHeight, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexture(graphics, x, x + (float)width, y, y + (float)height, 0, regionWidth, regionHeight, u, v, textureWidth, textureHeight);
        }

        private static void drawTexture(GuiGraphics graphics, float x0, float x1, float y0, float y1, int z, int regionWidth, int regionHeight, float u, float v, int textureWidth, int textureHeight) {
            FloatGuiComponent.drawTexturedQuad(graphics.m_280168_().m_85850_().m_252922_(), x0, x1, y0, y1, z, (u + 0.0f) / (float)textureWidth, (u + (float)regionWidth) / (float)textureWidth, (v + 0.0f) / (float)textureHeight, (v + (float)regionHeight) / (float)textureHeight);
        }

        private static void drawTexturedQuad(Matrix4f matrix, float x0, float x1, float y0, float y1, int z, float u0, float u1, float v0, float v1) {
            RenderSystem.setShader(GameRenderer::m_172817_);
            BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
            bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85817_);
            bufferBuilder.m_252986_(matrix, x0, y1, (float)z).m_7421_(u0, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y1, (float)z).m_7421_(u1, v1).m_5752_();
            bufferBuilder.m_252986_(matrix, x1, y0, (float)z).m_7421_(u1, v0).m_5752_();
            bufferBuilder.m_252986_(matrix, x0, y0, (float)z).m_7421_(u0, v0).m_5752_();
            BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        }
    }
}

