/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.resourcepack;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.dimension.renderer.StarInformation;
import earth.terrarium.ad_astra.common.util.ModUtils;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.Level;
import org.joml.Vector3f;

public record PlanetSkyRenderer(ResourceKey<Level> dimension, StarsRenderer starsRenderer, SunsetColour sunsetColour, DimensionEffects effects, CloudEffects cloudEffects, WeatherEffects weatherEffects, int horizonAngle, List<SkyObject> skyObjects) {
    public static final Codec<PlanetSkyRenderer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).fieldOf("world").forGetter(PlanetSkyRenderer::dimension), (App)StarsRenderer.CODEC.fieldOf("stars").forGetter(PlanetSkyRenderer::starsRenderer), (App)SunsetColour.CODEC.fieldOf("sunset_color").forGetter(PlanetSkyRenderer::sunsetColour), (App)DimensionEffects.CODEC.fieldOf("dimension_effects").forGetter(PlanetSkyRenderer::effects), (App)CloudEffects.CODEC.fieldOf("cloud_effects").forGetter(PlanetSkyRenderer::cloudEffects), (App)WeatherEffects.CODEC.fieldOf("weather_effects").forGetter(PlanetSkyRenderer::weatherEffects), (App)Codec.INT.fieldOf("horizon_angle").forGetter(PlanetSkyRenderer::horizonAngle), (App)SkyObject.CODEC.listOf().fieldOf("sky_objects").forGetter(PlanetSkyRenderer::skyObjects)).apply((Applicative)instance, PlanetSkyRenderer::new));

    public record StarsRenderer(int fancyStars, int fastStars, boolean colouredStars, boolean daylightVisible) {
        public static final Codec<StarsRenderer> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.fieldOf("fancy_count").forGetter(StarsRenderer::fancyStars), (App)Codec.INT.fieldOf("fast_count").forGetter(StarsRenderer::fastStars), (App)Codec.BOOL.fieldOf("colored_stars").forGetter(StarsRenderer::colouredStars), (App)Codec.BOOL.fieldOf("daylight_visible").forGetter(StarsRenderer::daylightVisible)).apply((Applicative)instance, StarsRenderer::new));
    }

    public static enum SunsetColour {
        VANILLA,
        MARS;

        public static final Codec<SunsetColour> CODEC;

        static {
            CODEC = ModUtils.createEnumCodec(SunsetColour.class);
        }
    }

    public record DimensionEffects(DimensionEffectType type, Color colour) {
        public static final Codec<DimensionEffects> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)DimensionEffectType.CODEC.fieldOf("type").forGetter(DimensionEffects::type), (App)Color.CODEC.fieldOf("color").orElse((Object)StarInformation.BASE_COLOUR).forGetter(DimensionEffects::colour)).apply((Applicative)instance, DimensionEffects::new));
    }

    public static enum CloudEffects {
        NONE,
        VANILLA,
        VENUS;

        public static final Codec<CloudEffects> CODEC;

        static {
            CODEC = ModUtils.createEnumCodec(CloudEffects.class);
        }
    }

    public static enum WeatherEffects {
        NONE,
        VANILLA,
        VENUS;

        public static final Codec<WeatherEffects> CODEC;

        static {
            CODEC = ModUtils.createEnumCodec(WeatherEffects.class);
        }
    }

    public record SkyObject(ResourceLocation texture, boolean blending, RenderType renderType, float scale, Color colour, Vector3f rotation) {
        public static final Codec<SkyObject> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.fieldOf("texture").forGetter(SkyObject::texture), (App)Codec.BOOL.fieldOf("blending").forGetter(SkyObject::blending), (App)RenderType.CODEC.fieldOf("render_type").forGetter(SkyObject::renderType), (App)Codec.FLOAT.fieldOf("scale").forGetter(SkyObject::scale), (App)Color.CODEC.fieldOf("color").orElse((Object)StarInformation.BASE_COLOUR).forGetter(SkyObject::colour), (App)ExtraCodecs.f_252432_.fieldOf("rotation").forGetter(SkyObject::rotation)).apply((Applicative)instance, SkyObject::new));
    }

    public static enum DimensionEffectType {
        SIMPLE,
        NONE,
        FOGGY_REVERSED,
        FOGGY,
        COLORED_HORIZON;

        public static final Codec<DimensionEffectType> CODEC;

        public boolean isFoggy() {
            return this == FOGGY || this == FOGGY_REVERSED;
        }

        static {
            CODEC = ModUtils.createEnumCodec(DimensionEffectType.class);
        }
    }

    public static enum RenderType {
        STATIC,
        DYNAMIC,
        SCALING,
        DEBUG;

        public static final Codec<RenderType> CODEC;

        static {
            CODEC = ModUtils.createEnumCodec(RenderType.class);
        }
    }
}

