/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.renderer.entity.vehicle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.VehicleModel;
import earth.terrarium.ad_astra.client.renderer.entity.vehicle.rover.RoverModel;
import earth.terrarium.ad_astra.common.entity.vehicle.Vehicle;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public abstract class VehicleRenderer<T extends Vehicle, M extends EntityModel<T>>
extends EntityRenderer<T>
implements RenderLayerParent<T, M> {
    protected final M model;

    protected VehicleRenderer(EntityRendererProvider.Context context, M model, float shadowRadius) {
        super(context);
        this.model = model;
        this.f_114477_ = shadowRadius;
    }

    public static void renderItem(EntityModel<?> model, ResourceLocation texture, ModelLayerLocation layer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_85837_(0.0, -1.501, 0.0);
        VertexConsumer vertexConsumer = buffer.m_6299_(RenderType.m_110464_((ResourceLocation)texture));
        model.m_7695_(poseStack, vertexConsumer, packedLight, packedOverlay, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static void renderRocketItem(ResourceLocation texture, ModelLayerLocation layer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        VehicleModel model = new VehicleModel(Minecraft.m_91087_().m_167973_().m_171103_(layer), "rocket");
        VehicleRenderer.renderItem(model, texture, layer, poseStack, buffer, packedLight, packedOverlay);
    }

    public static void renderRoverItem(ResourceLocation texture, ModelLayerLocation layer, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        RoverModel model = new RoverModel(Minecraft.m_91087_().m_167973_().m_171103_(layer));
        VehicleRenderer.renderItem(model, texture, layer, poseStack, buffer, packedLight, packedOverlay);
    }

    public M m_7200_() {
        return this.model;
    }

    public void render(T entity, float yaw, float tickDelta, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        poseStack.m_85836_();
        poseStack.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        poseStack.m_252781_(Axis.f_252436_.m_252977_((float)this.getYawOffset()));
        poseStack.m_85837_(0.0, -1.501, 0.0);
        if (entity.m_146890_()) {
            this.shakeVehicle(entity, tickDelta, poseStack);
        }
        this.model.m_6973_(entity, tickDelta, 0.0f, -0.1f, 0.0f, 0.0f);
        VertexConsumer vertexConsumer = buffer.m_6299_(this.model.m_103119_(this.m_5478_((Entity)entity)));
        this.model.m_7695_(poseStack, vertexConsumer, packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
        super.m_7392_(entity, yaw, tickDelta, poseStack, buffer, packedLight);
    }

    private void shakeVehicle(T entity, float tickDelta, PoseStack poseStack) {
        if (!Minecraft.m_91087_().m_91104_()) {
            double shakeDirection1 = tickDelta * (float)(entity.m_9236_().f_46441_.m_188499_() ? 1 : -1) / 150.0f;
            double shakeDirection2 = tickDelta * (float)(entity.m_9236_().f_46441_.m_188499_() ? 1 : -1) / 150.0f;
            double shakeDirection3 = tickDelta * (float)(entity.m_9236_().f_46441_.m_188499_() ? 1 : -1) / 150.0f;
            poseStack.m_85837_(shakeDirection1, shakeDirection2, shakeDirection3);
        }
    }

    public int getYawOffset() {
        return 180;
    }
}

