/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.world.features;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import earth.terrarium.adastra.common.registry.ModBlocks;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelWriter;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.ColumnFeatureConfiguration;
import org.jetbrains.annotations.Nullable;

public class InfernalSpireColumnFeature
extends Feature<ColumnFeatureConfiguration> {
    private static final ImmutableList<Block> CANNOT_PLACE_ON = ImmutableList.of((Object)Blocks.f_49991_, (Object)Blocks.f_50752_, (Object)Blocks.f_50450_, (Object)Blocks.f_50135_, (Object)Blocks.f_50197_, (Object)Blocks.f_50198_, (Object)Blocks.f_50199_, (Object)Blocks.f_50200_, (Object)Blocks.f_50087_, (Object)Blocks.f_50085_);

    public InfernalSpireColumnFeature(Codec<ColumnFeatureConfiguration> codec) {
        super(codec);
    }

    public boolean m_142674_(FeaturePlaceContext<ColumnFeatureConfiguration> context) {
        int i = context.m_159775_().m_6337_();
        BlockPos blockPos = context.m_159777_();
        WorldGenLevel worldGenLevel = context.m_159774_();
        RandomSource randomSource = context.m_225041_();
        ColumnFeatureConfiguration columnFeatureConfiguration = (ColumnFeatureConfiguration)context.m_159778_();
        if (!InfernalSpireColumnFeature.canPlaceAt((LevelAccessor)worldGenLevel, i, blockPos.m_122032_())) {
            return false;
        }
        int j = columnFeatureConfiguration.m_160720_().m_214085_(randomSource);
        boolean bl = randomSource.m_188501_() < 0.9f;
        int k = Math.min(j, bl ? 5 : 8);
        int l = bl ? 50 : 15;
        boolean bl2 = false;
        for (BlockPos blockPos2 : BlockPos.m_235641_((RandomSource)randomSource, (int)l, (int)(blockPos.m_123341_() - k), (int)blockPos.m_123342_(), (int)(blockPos.m_123343_() - k), (int)(blockPos.m_123341_() + k), (int)blockPos.m_123342_(), (int)(blockPos.m_123343_() + k))) {
            int m = j - blockPos2.m_123333_((Vec3i)blockPos);
            if (m < 0) continue;
            bl2 |= this.placeColumn((LevelAccessor)worldGenLevel, i, blockPos2, m, columnFeatureConfiguration.m_160717_().m_214085_(randomSource));
        }
        return bl2;
    }

    private boolean placeColumn(LevelAccessor level, int seaLevel, BlockPos pos, int distance, int reach) {
        boolean bl = false;
        block0: for (BlockPos blockPos : BlockPos.m_121976_((int)(pos.m_123341_() - reach), (int)pos.m_123342_(), (int)(pos.m_123343_() - reach), (int)(pos.m_123341_() + reach), (int)pos.m_123342_(), (int)(pos.m_123343_() + reach))) {
            int i = blockPos.m_123333_((Vec3i)pos);
            BlockPos blockPos2 = InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, blockPos) ? InfernalSpireColumnFeature.findSurface(level, seaLevel, blockPos.m_122032_(), i) : InfernalSpireColumnFeature.findAir(level, blockPos.m_122032_(), i);
            if (blockPos2 == null) continue;
            BlockPos.MutableBlockPos mutableBlockPos = blockPos2.m_122032_();
            for (int j = distance - i / 2; j >= 0; --j) {
                if (InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, (BlockPos)mutableBlockPos)) {
                    this.m_5974_((LevelWriter)level, (BlockPos)mutableBlockPos, ((Block)ModBlocks.INFERNAL_SPIRE_BLOCK.get()).m_49966_());
                    mutableBlockPos.m_122173_(Direction.UP);
                    bl = true;
                    continue;
                }
                if (!level.m_8055_((BlockPos)mutableBlockPos).m_60713_((Block)ModBlocks.INFERNAL_SPIRE_BLOCK.get())) continue block0;
                mutableBlockPos.m_122173_(Direction.UP);
            }
        }
        return bl;
    }

    @Nullable
    private static BlockPos findSurface(LevelAccessor level, int seaLevel, BlockPos.MutableBlockPos pos, int distance) {
        while (pos.m_123342_() > level.m_141937_() + 1 && distance > 0) {
            --distance;
            if (InfernalSpireColumnFeature.canPlaceAt(level, seaLevel, pos)) {
                return pos;
            }
            pos.m_122173_(Direction.DOWN);
        }
        return null;
    }

    private static boolean canPlaceAt(LevelAccessor level, int seaLevel, BlockPos.MutableBlockPos pos) {
        if (!InfernalSpireColumnFeature.isAirOrLavaOcean(level, seaLevel, (BlockPos)pos)) {
            return false;
        }
        BlockState blockState = level.m_8055_((BlockPos)pos.m_122173_(Direction.DOWN));
        pos.m_122173_(Direction.UP);
        return !blockState.m_60795_() && !CANNOT_PLACE_ON.contains((Object)blockState.m_60734_());
    }

    @Nullable
    private static BlockPos findAir(LevelAccessor level, BlockPos.MutableBlockPos pos, int distance) {
        while (pos.m_123342_() < level.m_151558_() && distance > 0) {
            --distance;
            BlockState blockState = level.m_8055_((BlockPos)pos);
            if (CANNOT_PLACE_ON.contains((Object)blockState.m_60734_())) {
                return null;
            }
            if (blockState.m_60795_()) {
                return pos;
            }
            pos.m_122173_(Direction.UP);
        }
        return null;
    }

    private static boolean isAirOrLavaOcean(LevelAccessor level, int seaLevel, BlockPos pos) {
        BlockState blockState = level.m_8055_(pos);
        return blockState.m_60795_() || blockState.m_60713_(Blocks.f_49991_) && pos.m_123342_() <= seaLevel;
    }
}

