/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.systems;

import earth.terrarium.adastra.api.events.AdAstraEvents;
import earth.terrarium.adastra.api.planets.Planet;
import earth.terrarium.adastra.api.planets.PlanetApi;
import earth.terrarium.adastra.api.systems.TemperatureApi;
import earth.terrarium.adastra.common.config.AdAstraConfig;
import earth.terrarium.adastra.common.handlers.PlanetHandler;
import earth.terrarium.adastra.common.items.armor.SpaceSuitItem;
import earth.terrarium.adastra.common.tags.ModEntityTypeTags;
import earth.terrarium.adastra.common.tags.ModItemTags;
import earth.terrarium.adastra.common.utils.ModUtils;
import java.util.Collection;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public class TemperatureApiImpl
implements TemperatureApi {
    @Override
    public short getTemperature(Level level) {
        return this.getTemperature((ResourceKey<Level>)level.m_46472_());
    }

    @Override
    public short getTemperature(ResourceKey<Level> level) {
        return (Short)Optionull.m_269278_((Object)PlanetApi.API.getPlanet(level), Planet::temperature, (Object)15);
    }

    @Override
    public short getTemperature(Level level, BlockPos pos) {
        if (level.m_5776_()) {
            return this.getTemperature(level);
        }
        return PlanetHandler.getTemperature((ServerLevel)level, pos);
    }

    @Override
    public short getTemperature(Entity entity) {
        return this.getTemperature(entity.m_9236_(), BlockPos.m_274561_((double)entity.m_20185_(), (double)entity.m_20188_(), (double)entity.m_20189_()));
    }

    @Override
    public void setTemperature(Level level, BlockPos pos, short temperature) {
        if (level.m_5776_()) {
            return;
        }
        PlanetHandler.setTemperature((ServerLevel)level, pos, temperature);
    }

    @Override
    public void setTemperature(Level level, Collection<BlockPos> positions, short temperature) {
        if (level.m_5776_()) {
            return;
        }
        PlanetHandler.setTemperature((ServerLevel)level, positions, temperature);
    }

    @Override
    public void removeTemperature(Level level, BlockPos pos) {
        this.setTemperature(level, pos, this.getTemperature(level));
    }

    @Override
    public void removeTemperature(Level level, Collection<BlockPos> positions) {
        this.setTemperature(level, positions, this.getTemperature(level));
    }

    @Override
    public boolean isLiveable(Level level, BlockPos pos) {
        short temperature = this.getTemperature(level, pos);
        return temperature >= -50 && temperature <= 70;
    }

    @Override
    public boolean isHot(Level level, BlockPos pos) {
        return this.getTemperature(level, pos) > 70;
    }

    @Override
    public boolean isCold(Level level, BlockPos pos) {
        return this.getTemperature(level, pos) < -50;
    }

    @Override
    public void entityTick(ServerLevel level, LivingEntity entity) {
        if (AdAstraConfig.disableTemperature) {
            return;
        }
        if (entity.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_IN_SPACE)) {
            return;
        }
        if (this.isHot((Level)level, entity.m_20183_())) {
            if (entity.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_EXTREME_HEAT)) {
                return;
            }
            if (SpaceSuitItem.hasFullSet(entity, ModItemTags.HEAT_RESISTANT_ARMOR)) {
                return;
            }
            if (entity.m_21023_(MobEffects.f_19607_)) {
                return;
            }
            if (AdAstraEvents.HotTemperatureTickEvent.fire(level, entity)) {
                this.burnEntity(entity);
            }
        } else if (this.isCold((Level)level, entity.m_20183_())) {
            if (entity.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_EXTREME_COLD)) {
                return;
            }
            if (SpaceSuitItem.hasFullSet(entity, ModItemTags.FREEZE_RESISTANT_ARMOR)) {
                return;
            }
            if (AdAstraEvents.ColdTemperatureTickEvent.fire(level, entity)) {
                this.freezeEntity(entity, level);
            }
        }
    }

    private void burnEntity(LivingEntity entity) {
        entity.m_6469_(entity.m_269291_().m_269549_(), 6.0f);
        entity.m_20254_(10);
    }

    private void freezeEntity(LivingEntity entity, ServerLevel level) {
        if (entity.m_6095_().m_204039_(ModEntityTypeTags.CAN_SURVIVE_EXTREME_COLD)) {
            return;
        }
        if (SpaceSuitItem.hasFullSet(entity, ModItemTags.FREEZE_RESISTANT_ARMOR)) {
            return;
        }
        if (AdAstraEvents.ColdTemperatureTickEvent.fire(level, entity)) {
            entity.m_6469_(entity.m_269291_().m_269109_(), 3.0f);
            entity.m_146917_(Math.min(entity.m_146891_() + 20, entity.m_146888_() + 50));
            ModUtils.sendParticles(level, ParticleTypes.f_175821_, entity.m_20185_(), entity.m_20186_() + 1.0, entity.m_20189_(), 1, Mth.m_216283_((RandomSource)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.085f, 0.05, (double)Mth.m_216283_((RandomSource)level.f_46441_, (float)-1.0f, (float)1.0f) * 0.085, 0.0);
        }
    }
}

