/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.common.blockentities.machines;

import earth.terrarium.adastra.client.utils.GuiUtils;
import earth.terrarium.adastra.common.blockentities.base.EnergyContainerMachineBlockEntity;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.Configuration;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationEntry;
import earth.terrarium.adastra.common.blockentities.base.sideconfig.ConfigurationType;
import earth.terrarium.adastra.common.config.MachineConfig;
import earth.terrarium.adastra.common.constants.ConstantComponents;
import earth.terrarium.adastra.common.menus.machines.EtrionicBlastFurnaceMenu;
import earth.terrarium.adastra.common.recipes.machines.AlloyingRecipe;
import earth.terrarium.adastra.common.registry.ModRecipeTypes;
import earth.terrarium.adastra.common.utils.ItemUtils;
import earth.terrarium.adastra.common.utils.TransferUtils;
import earth.terrarium.botarium.common.energy.base.EnergyContainer;
import earth.terrarium.botarium.common.energy.impl.InsertOnlyEnergyContainer;
import earth.terrarium.botarium.common.energy.impl.WrappedBlockEnergyContainer;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EtrionicBlastFurnaceBlockEntity
extends EnergyContainerMachineBlockEntity {
    public static final List<ConfigurationEntry> SIDE_CONFIG = List.of(new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_INPUT_SLOTS), new ConfigurationEntry(ConfigurationType.SLOT, Configuration.NONE, ConstantComponents.SIDE_CONFIG_OUTPUT_SLOTS), new ConfigurationEntry(ConfigurationType.ENERGY, Configuration.NONE, ConstantComponents.SIDE_CONFIG_ENERGY));
    @Nullable
    private AlloyingRecipe alloyingRecipe;
    protected final RecipeManager.CachedCheck<Container, AlloyingRecipe> alloyingQuickCheck = RecipeManager.m_220267_((RecipeType)((RecipeType)ModRecipeTypes.ALLOYING.get()));
    private final BlastingRecipe[] recipes = new BlastingRecipe[4];
    private Mode mode = Mode.BLASTING;
    protected int cookTime;
    protected int cookTimeTotal;

    public EtrionicBlastFurnaceBlockEntity(BlockPos pos, BlockState state) {
        super(pos, state, 9);
    }

    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new EtrionicBlastFurnaceMenu(id, inventory, this);
    }

    public WrappedBlockEnergyContainer getEnergyStorage() {
        if (this.energyContainer != null) {
            return this.energyContainer;
        }
        this.energyContainer = new WrappedBlockEnergyContainer((BlockEntity)this, (EnergyContainer)new InsertOnlyEnergyContainer(MachineConfig.steelTierEnergyCapacity, MachineConfig.steelTierMaxEnergyInOut));
        return this.energyContainer;
    }

    @Override
    public void serverTick(ServerLevel level, long time, BlockState state, BlockPos pos) {
        if (this.canFunction()) {
            this.recipeTick(this.getEnergyStorage());
        }
        if (time % 5L == 0L) {
            this.setLit(this.cookTimeTotal > 0 && this.canFunction());
        }
    }

    @Override
    public boolean shouldUpdate() {
        for (int i = 0; i < 4; ++i) {
            if (this.recipes[i] != null) continue;
            return true;
        }
        return false;
    }

    @Override
    public void tickSideInteractions(BlockPos pos, Predicate<Direction> filter, List<ConfigurationEntry> sideConfig) {
        TransferUtils.pullItemsNearby(this, pos, new int[]{1, 2, 3, 4}, sideConfig.get(0), filter);
        TransferUtils.pushItemsNearby(this, pos, new int[]{5, 6, 7, 8}, sideConfig.get(1), filter);
        TransferUtils.pullEnergyNearby(this, pos, this.getEnergyStorage().maxInsert(), sideConfig.get(2), filter);
    }

    public void recipeTick(WrappedBlockEnergyContainer energyStorage) {
        int i;
        if (this.mode == Mode.ALLOYING) {
            this.alloyingRecipeTick(energyStorage);
            return;
        }
        boolean isCooking = false;
        boolean shouldClear = true;
        for (i = 0; i < 4; ++i) {
            if (this.recipes[i] == null) continue;
            if (this.canCraft(energyStorage, this.recipes[i], i + 1)) {
                shouldClear = false;
            }
            energyStorage.internalExtract(MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem, false);
            isCooking = true;
            if (this.cookTime < this.cookTimeTotal) continue;
            for (int j = 0; j < 4; ++j) {
                this.craft(this.recipes[j], j, j + 1);
            }
        }
        if (isCooking) {
            ++this.cookTime;
        }
        if (shouldClear) {
            for (i = 0; i < 4; ++i) {
                this.clearRecipe(i);
            }
        }
    }

    protected boolean canCraft(WrappedBlockEnergyContainer energyStorage, BlastingRecipe recipe, int slot) {
        if (recipe == null) {
            return false;
        }
        if (energyStorage.internalExtract(MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem, true) < MachineConfig.etrionicBlastFurnaceBlastingEnergyPerItem) {
            return false;
        }
        if (!((Ingredient)recipe.m_7527_().get(0)).test(this.m_8020_(slot))) {
            return false;
        }
        return ItemUtils.canAddItem(this, recipe.m_8043_(this.level().m_9598_()), 5, 6, 7, 8);
    }

    protected void craft(BlastingRecipe recipe, int recipeIndex, int slot) {
        if (recipe == null) {
            return;
        }
        this.m_8020_(slot).m_41774_(1);
        ItemUtils.addItem((Container)this, recipe.m_8043_(this.level().m_9598_()), 5, 6, 7, 8);
        this.cookTime = 0;
        if (this.m_8020_(slot).m_41619_()) {
            this.clearRecipe(recipeIndex);
        }
    }

    public void alloyingRecipeTick(WrappedBlockEnergyContainer energyStorage) {
        if (this.alloyingRecipe == null) {
            return;
        }
        if (!this.canCraftAlloying()) {
            this.clearAlloyingRecipe();
            return;
        }
        energyStorage.internalExtract((long)this.alloyingRecipe.energy(), false);
        ++this.cookTime;
        if (this.cookTime < this.cookTimeTotal) {
            return;
        }
        this.craftAlloying();
    }

    public boolean canCraftAlloying() {
        return this.alloyingRecipe != null && this.alloyingRecipe.m_5818_(this, this.level());
    }

    public void craftAlloying() {
        if (this.alloyingRecipe == null) {
            return;
        }
        block0: for (Ingredient recipe : this.alloyingRecipe.ingredients()) {
            for (int i = 0; i < 4; ++i) {
                if (!recipe.test(this.m_8020_(i + 1))) continue;
                this.m_8020_(i + 1).m_41774_(1);
                continue block0;
            }
        }
        ItemUtils.addItem((Container)this, this.alloyingRecipe.result(), 5, 6, 7, 8);
        this.cookTime = 0;
        if (!this.canCraftAlloying()) {
            this.clearAlloyingRecipe();
        }
    }

    @Override
    public void update() {
        if (this.level().m_5776_()) {
            return;
        }
        if (this.mode == Mode.BLASTING) {
            for (int i = 0; i < 4; ++i) {
                this.createRecipe(i, i + 1);
            }
        } else {
            this.alloyingQuickCheck.m_213657_((Container)this, this.level()).ifPresent(r -> {
                this.alloyingRecipe = r;
                this.cookTimeTotal = r.cookingTime();
            });
        }
    }

    @Nullable
    protected void createRecipe(int recipe, int slot) {
        if (this.m_8020_(slot).m_41619_()) {
            return;
        }
        this.level().m_7465_().m_44013_(RecipeType.f_44109_).stream().filter(r -> ((Ingredient)r.m_7527_().get(0)).test(this.m_8020_(slot))).findFirst().ifPresent(r -> {
            this.recipes[recipe] = r;
            this.cookTimeTotal = r.m_43753_();
        });
    }

    @Override
    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        this.cookTime = tag.m_128451_("CookTime");
        this.cookTimeTotal = tag.m_128451_("CookTimeTotal");
        this.mode = Mode.values()[tag.m_128445_("Mode")];
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("CookTime", this.cookTime);
        tag.m_128405_("CookTimeTotal", this.cookTimeTotal);
        tag.m_128344_("Mode", (byte)this.mode.ordinal());
    }

    public void clearRecipe(int recipe) {
        this.recipes[recipe] = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
    }

    public void clearAlloyingRecipe() {
        this.alloyingRecipe = null;
        this.cookTime = 0;
        this.cookTimeTotal = 0;
    }

    public int cookTime() {
        return this.cookTime;
    }

    public int cookTimeTotal() {
        return this.cookTimeTotal;
    }

    public Mode mode() {
        return this.mode;
    }

    public void setMode(Mode mode) {
        this.mode = mode;
    }

    @Override
    public List<ConfigurationEntry> getDefaultConfig() {
        return SIDE_CONFIG;
    }

    public int @NotNull [] m_7071_(@NotNull Direction side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8};
    }

    public static enum Mode {
        ALLOYING(GuiUtils.CRAFTING_BUTTON),
        BLASTING(GuiUtils.FURNACE_BUTTON);

        private final ResourceLocation icon;

        private Mode(ResourceLocation icon) {
            this.icon = icon;
        }

        public ResourceLocation icon() {
            return this.icon;
        }

        public Component translation() {
            return Component.m_237115_((String)"tooltip.ad_astra.etrionic_blast_furnace.mode.%s".formatted(this.name().toLowerCase(Locale.ROOT)));
        }

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode previous() {
            return Mode.values()[(this.ordinal() - 1 + Mode.values().length) % Mode.values().length];
        }
    }
}

