/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.adastra.client.radio.audio;

import com.google.common.hash.Hashing;
import earth.terrarium.adastra.client.config.RadioConfig;
import earth.terrarium.adastra.client.radio.audio.Mp3AudioStream;
import earth.terrarium.adastra.client.radio.audio.RadioHandler;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.Executor;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractSoundInstance;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.AudioStream;
import net.minecraft.client.sounds.SoundBufferLibrary;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.client.sounds.Weighted;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.SampledFloat;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class RadioSoundInstance
extends AbstractSoundInstance
implements TickableSoundInstance {
    protected final String url;
    protected boolean stopped = false;

    public RadioSoundInstance(String url, RandomSource randomSource) {
        super(new ResourceLocation("ad_astra", "radio/" + Hashing.sha1().hashUnencodedChars((CharSequence)url)), SoundSource.MASTER, randomSource);
        this.url = url;
    }

    public WeighedSoundEvents m_6775_(@NotNull SoundManager manager) {
        WeighedSoundEvents soundEvents = new WeighedSoundEvents(this.m_7904_(), null);
        soundEvents.m_120451_((Weighted)new Sound(this.m_7904_().toString(), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), (SampledFloat)ConstantFloat.m_146458_((float)1.0f), 1, Sound.Type.FILE, true, false, 0));
        this.f_119570_ = soundEvents.m_213718_(this.f_235066_);
        return soundEvents;
    }

    public float m_7769_() {
        return (float)RadioConfig.volume / 100.0f;
    }

    public boolean m_7801_() {
        return this.stopped;
    }

    public void m_7788_() {
        if (this != RadioHandler.getLastStation()) {
            this.stopped = true;
            return;
        }
        if (Minecraft.m_91087_().f_91074_ != null && Minecraft.m_91087_().f_91074_.m_6084_()) {
            this.f_119575_ = (float)Minecraft.m_91087_().f_91074_.m_20185_();
            this.f_119576_ = (float)Minecraft.m_91087_().f_91074_.m_20186_();
            this.f_119577_ = (float)Minecraft.m_91087_().f_91074_.m_20189_();
        } else {
            this.stopped = true;
        }
    }

    public CompletableFuture<AudioStream> getStream() {
        return ((CompletableFuture)RadioHandler.getRadioStream(this.url).thenApplyAsync(stream -> {
            try {
                return new Mp3AudioStream((InputStream)stream);
            }
            catch (Exception e) {
                throw new CompletionException(e);
            }
        }, (Executor)Util.m_183991_())).handleAsync((stream, e) -> {
            if (e != null) {
                e.printStackTrace();
            }
            return stream;
        }, (Executor)Util.m_183991_());
    }

    public String url() {
        return this.url;
    }

    public CompletableFuture<AudioStream> getAudioStream(SoundBufferLibrary library, ResourceLocation id, boolean loop) {
        return this.getStream();
    }

    public CompletableFuture<AudioStream> getStream(SoundBufferLibrary library, Sound sound, boolean loop) {
        return this.getStream();
    }
}

