/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util.handler;

import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.tuple.Pair;
import org.violetmoon.zeta.advancement.modifier.WaxModifier;
import org.violetmoon.zeta.event.bus.LoadEvent;
import org.violetmoon.zeta.event.bus.PlayEvent;
import org.violetmoon.zeta.event.load.ZCommonSetup;
import org.violetmoon.zeta.event.play.ZBlock;
import org.violetmoon.zeta.event.play.entity.player.ZRightClickBlock;
import org.violetmoon.zeta.module.ZetaModule;

public final class ToolInteractionHandler {
    private static final Map<Block, Block> cleanToWaxMap = HashBiMap.create();
    private static final Map<ToolAction, Map<Block, Block>> interactionMaps = new HashMap<ToolAction, Map<Block, Block>>();
    private static final Multimap<ZetaModule, Pair<Block, Block>> waxingByModule = HashMultimap.create();

    public static void registerWaxedBlock(ZetaModule module, Block clean, Block waxed) {
        cleanToWaxMap.put(clean, waxed);
        ToolInteractionHandler.registerInteraction(ToolActions.AXE_WAX_OFF, waxed, clean);
        waxingByModule.put((Object)module, (Object)Pair.of((Object)clean, (Object)waxed));
    }

    public static void registerInteraction(ToolAction action, Block in, Block out) {
        if (!interactionMaps.containsKey(action)) {
            interactionMaps.put(action, new HashMap());
        }
        Map<Block, Block> map = interactionMaps.get(action);
        map.put(in, out);
    }

    @LoadEvent
    public static void addModifiers(ZCommonSetup event) {
        event.enqueueWork(() -> {
            for (ZetaModule module : waxingByModule.keySet()) {
                Collection pairs = waxingByModule.get((Object)module);
                HashSet<Block> unwaxed = new HashSet<Block>();
                HashSet<Block> waxed = new HashSet<Block>();
                for (Pair pair : pairs) {
                    unwaxed.add((Block)pair.getLeft());
                    waxed.add((Block)pair.getRight());
                }
                module.zeta.advancementModifierRegistry.addModifier(new WaxModifier(module, unwaxed, waxed));
            }
        });
    }

    @PlayEvent
    public static void toolActionEvent(ZBlock.BlockToolModification event) {
        BlockState state;
        Block block;
        Map<Block, Block> map;
        ToolAction action = event.getToolAction();
        if (interactionMaps.containsKey(action) && (map = interactionMaps.get(action)).containsKey(block = (state = event.getState()).m_60734_())) {
            Block finalBlock = map.get(block);
            event.setFinalState(ToolInteractionHandler.copyState(state, finalBlock));
        }
    }

    @PlayEvent
    public static void itemUse(ZRightClickBlock event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41720_() == Items.f_42784_) {
            BlockPos pos = event.getPos();
            Level world = event.getLevel();
            BlockState state = world.m_8055_(pos);
            Block block = state.m_60734_();
            if (cleanToWaxMap.containsKey(block)) {
                Block alternate = cleanToWaxMap.get(block);
                LivingEntity livingEntity = event.getEntity();
                if (livingEntity instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)livingEntity;
                    CriteriaTriggers.f_10562_.m_285767_(sp, pos, stack);
                }
                if (!world.f_46443_) {
                    world.m_46597_(pos, ToolInteractionHandler.copyState(state, alternate));
                }
                world.m_5898_(event.getPlayer(), 3003, pos, 0);
                if (!event.getPlayer().m_150110_().f_35937_) {
                    stack.m_41764_(stack.m_41613_() - 1);
                }
                event.setCanceled(true);
                event.setCancellationResult(InteractionResult.SUCCESS);
            }
        }
    }

    private static BlockState copyState(BlockState original, Block newBlock) {
        BlockState retState = newBlock.m_49966_();
        for (Property prop : original.m_61147_()) {
            if (!retState.m_61138_(prop)) continue;
            retState = (BlockState)retState.m_61124_(prop, original.m_61143_(prop));
        }
        return retState;
    }
}

