/*
 * Decompiled with CFR 0.152.
 */
package org.violetmoon.zeta.util;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.LinkedHashSet;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.violetmoon.zeta.util.BlockUtils;

public class MiscUtil {
    public static final Direction[] HORIZONTALS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final DyeColor[] CREATIVE_COLOR_ORDER = new DyeColor[]{DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK};

    public static BooleanProperty directionProperty(Direction direction) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> BlockStateProperties.f_61367_;
            case Direction.UP -> BlockStateProperties.f_61366_;
            case Direction.NORTH -> BlockStateProperties.f_61368_;
            case Direction.SOUTH -> BlockStateProperties.f_61370_;
            case Direction.WEST -> BlockStateProperties.f_61371_;
            case Direction.EAST -> BlockStateProperties.f_61369_;
        };
    }

    public static void addGoalJustAfterLatestWithPriority(GoalSelector selector, int priority, Goal goal) {
        LinkedHashSet allGoals = new LinkedHashSet(selector.m_148105_());
        WrappedGoal latestWithPriority = null;
        for (WrappedGoal wrappedGoal : allGoals) {
            if (wrappedGoal.m_26012_() != priority) continue;
            latestWithPriority = wrappedGoal;
        }
        selector.m_262460_(g -> true);
        if (latestWithPriority == null) {
            selector.m_25352_(priority, goal);
        }
        for (WrappedGoal wrappedGoal : allGoals) {
            selector.m_25352_(wrappedGoal.m_26012_(), wrappedGoal.m_26015_());
            if (wrappedGoal != latestWithPriority) continue;
            selector.m_25352_(priority, goal);
        }
    }

    public static void damageStack(Player player, InteractionHand hand, ItemStack stack, int dmg) {
        stack.m_41622_(dmg, (LivingEntity)player, p -> p.m_21190_(hand));
    }

    public static Vec2 getMinecraftAngles(Vec3 direction) {
        direction = direction.m_82541_();
        double pitch = Math.asin(direction.f_82480_);
        double yaw = Math.asin(direction.f_82479_ / Math.cos(pitch));
        return new Vec2((float)(pitch * 180.0 / Math.PI), (float)(-yaw * 180.0 / Math.PI));
    }

    public static boolean validSpawnLight(ServerLevelAccessor world, BlockPos pos, RandomSource rand) {
        if (world.m_45517_(LightLayer.SKY, pos) > rand.m_188503_(32)) {
            return false;
        }
        int light = world.m_6018_().m_46470_() ? world.m_46849_(pos, 10) : world.m_46803_(pos);
        return light == 0;
    }

    public static boolean validSpawnLocation(@NotNull EntityType<? extends Mob> type, @NotNull LevelAccessor world, MobSpawnType reason, BlockPos pos) {
        BlockPos below = pos.m_7495_();
        if (reason == MobSpawnType.SPAWNER) {
            return true;
        }
        BlockState state = world.m_8055_(below);
        return BlockUtils.isStoneBased(state, (BlockGetter)world, below) && state.m_60643_((BlockGetter)world, below, type);
    }

    public static void syncTE(BlockEntity tile) {
        Level level;
        Packet packet = tile.m_58483_();
        if (packet != null && (level = tile.m_58904_()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7726_().f_8325_.m_183262_(new ChunkPos(tile.m_58899_()), false).forEach(e -> e.f_8906_.m_9829_(packet));
        }
    }

    public static ItemStack putIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean simulate, boolean doSimulation) {
        Block block;
        IItemHandler handler = null;
        if (level != null && blockPos != null && (block = level.m_8055_(blockPos).m_60734_()) instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder holder = (WorldlyContainerHolder)block;
            handler = new SidedInvWrapper(holder.m_5840_(level.m_8055_(blockPos), level, blockPos), face);
        } else if (tile != null) {
            LazyOptional opt = tile.getCapability(ForgeCapabilities.ITEM_HANDLER, face);
            if (opt.isPresent()) {
                handler = (IItemHandler)opt.orElse((Object)new ItemStackHandler());
            } else if (tile instanceof WorldlyContainer) {
                WorldlyContainer container = (WorldlyContainer)tile;
                handler = new SidedInvWrapper(container, face);
            } else if (tile instanceof Container) {
                Container container = (Container)tile;
                handler = new InvWrapper(container);
            }
        }
        if (handler != null) {
            return simulate && !doSimulation ? ItemStack.f_41583_ : ItemHandlerHelper.insertItem(handler, (ItemStack)stack, (boolean)simulate);
        }
        return stack;
    }

    public static boolean canPutIntoInv(ItemStack stack, LevelAccessor level, BlockPos blockPos, BlockEntity tile, Direction face, boolean doSimulation) {
        return MiscUtil.putIntoInv(stack, level, blockPos, tile, face, true, doSimulation).m_41619_();
    }

    public static BlockState fromString(String key) {
        try {
            BlockStateParser.BlockResult result = BlockStateParser.m_234691_((HolderLookup)BuiltInRegistries.f_256975_.m_255303_(), (StringReader)new StringReader(key), (boolean)false);
            BlockState state = result.f_234748_();
            return state == null ? Blocks.f_50016_.m_49966_() : state;
        }
        catch (CommandSyntaxException e) {
            return Blocks.f_50016_.m_49966_();
        }
    }

    public static BlockBehaviour.Properties copyPropertySafe(BlockBehaviour blockBehaviour) {
        BlockBehaviour.Properties p = BlockBehaviour.Properties.m_60926_((BlockBehaviour)blockBehaviour);
        p.m_60953_(s -> 0);
        p.m_222979_(BlockBehaviour.OffsetType.NONE);
        p.m_284180_(blockBehaviour.m_284356_());
        return p;
    }
}

