/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.item;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.data.json.JSONHelper;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Containers;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.wrapper.EmptyHandler;
import net.minecraftforge.registries.ForgeRegistries;

public final class ItemHelper {
    public static final String INVENTORY = "inventory";
    public static final IItemHandlerModifiable EMPTY_ITEM_HANDLER = (IItemHandlerModifiable)EmptyHandler.INSTANCE;

    public static ResourceLocation getItemId(ItemLike item) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item.m_5456_()));
    }

    public static ResourceLocation getItemId(ItemStack stack) {
        return Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_()));
    }

    public static MutableComponent getItemName(Item item) {
        return Component.m_237115_((String)item.m_5524_());
    }

    public static MutableComponent getItemName(ItemStack stack) {
        return Component.m_237115_((String)stack.m_41778_());
    }

    @Nullable
    public static Item getItemFrom(String id) {
        return ItemHelper.getItemFrom(new ResourceLocation(id));
    }

    public static Item getItemFromOrAir(String id) {
        return ItemHelper.getItemFromOrAir(new ResourceLocation(id));
    }

    @Nullable
    public static Item getItemFrom(ResourceLocation id) {
        return (Item)ForgeRegistries.ITEMS.getValue(id);
    }

    public static Item getItemFromOrAir(ResourceLocation id) {
        return ForgeRegistries.ITEMS.containsKey(id) ? Objects.requireNonNull((Item)ForgeRegistries.ITEMS.getValue(id)) : Items.f_41852_;
    }

    public static boolean stackMatch(ItemStack stackA, ItemStack stackB, EnumSet<MatchOption> options) {
        if (stackA.m_41619_() || stackB.m_41619_()) {
            return false;
        }
        if (options.isEmpty()) {
            return true;
        }
        boolean result = true;
        if (options.contains((Object)MatchOption.Item)) {
            boolean bl = result = stackA.m_41720_() == stackB.m_41720_();
        }
        if (result && options.contains((Object)MatchOption.Size)) {
            boolean bl = result = stackA.m_41613_() == stackB.m_41613_();
        }
        if (result && options.contains((Object)MatchOption.Damage)) {
            boolean bl = result = stackA.m_41773_() == stackB.m_41773_();
        }
        if (result && options.contains((Object)MatchOption.NBT)) {
            result = Objects.equals(stackA.m_41783_(), stackB.m_41783_());
        }
        if (result && options.contains((Object)MatchOption.Capabilities)) {
            result = stackA.areCapsCompatible((CapabilityProvider)stackB);
        }
        return result;
    }

    public static ItemStack stackFrom(ItemLike provider) {
        return ItemHelper.stackFrom(provider, 1, null);
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<T> supplier) {
        return ItemHelper.stackFrom(supplier, 1, null);
    }

    public static ItemStack stackFrom(ItemLike provider, int amount) {
        return ItemHelper.stackFrom(provider, amount, null);
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<T> supplier, int amount) {
        return ItemHelper.stackFrom(supplier, amount, null);
    }

    public static ItemStack stackFrom(ItemLike provider, int amount, int damage) {
        ItemStack stack = ItemHelper.stackFrom(provider, amount);
        stack.m_41721_(damage);
        return stack;
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<T> supplier, int amount, int damage) {
        ItemStack stack = ItemHelper.stackFrom(supplier, amount);
        if (!stack.m_41619_()) {
            stack.m_41721_(damage);
        }
        return stack;
    }

    public static ItemStack stackFrom(ItemLike provider, int amount, @Nullable CompoundTag nbt) {
        return new ItemStack(provider, amount, nbt);
    }

    public static <T extends ItemLike> ItemStack stackFrom(Supplier<T> supplier, int amount, @Nullable CompoundTag nbt) {
        ItemLike provider = (ItemLike)supplier.get();
        return null != provider ? new ItemStack(provider, amount, nbt) : ItemHelper.stackEmpty();
    }

    public static ItemStack stackFrom(BlockState state, int amount) {
        return ItemHelper.stackFrom((ItemLike)state.m_60734_(), amount, null);
    }

    public static ItemStack stackFrom(CompoundTag nbt) {
        return ItemStack.m_41712_((CompoundTag)nbt);
    }

    public static CompoundTag stackToNBT(ItemStack stack) {
        return stack.m_41739_(new CompoundTag());
    }

    public static ItemStack stackFrom(JsonElement json) {
        JsonObject o = json.getAsJsonObject();
        Item item = JSONHelper.jsonGetItem(o, "item");
        int count = JSONHelper.jsonGetInt(o, "count", 1);
        if (o.has("nbt")) {
            return ItemHelper.stackFrom((ItemLike)item, count, JSONHelper.jsonGetNBT(o, "nbt"));
        }
        return ItemHelper.stackFrom((ItemLike)item, count);
    }

    public static JsonElement stackToJSON(ItemStack stack) {
        JsonObject json = new JsonObject();
        int count = stack.m_41613_();
        JSONHelper.jsonSetItem(json, "item", (ItemLike)stack.m_41720_());
        if (count > 1) {
            JSONHelper.jsonSetInt(json, "count", count);
        }
        if (stack.m_41782_()) {
            JSONHelper.jsonSetNBT(json, "nbt", Objects.requireNonNull(stack.m_41783_()));
        }
        return json;
    }

    public static ItemStack stackFrom(ItemStack stack) {
        return stack.m_41777_();
    }

    public static ItemStack stackFrom(ItemStack stack, int amount) {
        ItemStack newStack = ItemHelper.stackFrom(stack);
        if (newStack.m_41619_()) {
            return ItemHelper.stackEmpty();
        }
        ItemHelper.stackSetSize(newStack, amount);
        return newStack;
    }

    public static ItemStack stackSetSize(ItemStack stack, int amount) {
        stack.m_41764_(Math.max(amount, 0));
        return stack;
    }

    public static ItemStack stackEmpty(ItemStack stack) {
        stack.m_41764_(0);
        return stack;
    }

    @Deprecated
    public static ItemStack stackEmpty() {
        return ItemStack.f_41583_;
    }

    public static Optional<CompoundTag> stackGetTag(ItemStack stack) {
        return Optional.ofNullable(stack.m_41783_());
    }

    public static boolean stackHasData(ItemStack stack, String key) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"'key' must not be empty");
        return ItemHelper.stackGetTag(stack).map(tag -> tag.m_128441_(key)).orElse(false);
    }

    public static Optional<Tag> stackGetData(ItemStack stack, String key) {
        return ItemHelper.stackGetTag(stack).map(tag -> tag.m_128423_(key));
    }

    public static void stackSetData(ItemStack stack, String key, Tag value) {
        Preconditions.checkArgument((!key.isEmpty() ? 1 : 0) != 0, (Object)"'key' must not be empty");
        CodeHelper.optionalIfPresentOrElse(ItemHelper.stackGetTag(stack), tag -> tag.m_128365_(key, value), () -> {
            CompoundTag newTag = new CompoundTag();
            newTag.m_128365_(key, value);
            stack.m_41751_(newTag);
        });
    }

    public static ItemStack removeStackFromSlot(IItemHandlerModifiable inventory, int slot) {
        ItemStack stack = inventory.getStackInSlot(slot);
        inventory.setStackInSlot(slot, ItemHelper.stackEmpty());
        return stack;
    }

    public static void inventoryDropItems(IItemHandlerModifiable inventory, Level world, BlockPos position) {
        double x = position.m_123341_();
        double y = position.m_123342_();
        double z = position.m_123343_();
        IntStream.range(0, inventory.getSlots()).mapToObj(slot -> ItemHelper.removeStackFromSlot(inventory, slot)).filter(stack -> !stack.m_41619_()).forEach(stack -> Containers.m_18992_((Level)world, (double)x, (double)y, (double)z, (ItemStack)stack));
    }

    private ItemHelper() {
    }

    public static enum MatchOption {
        Item,
        Size,
        Damage,
        NBT,
        Capabilities;

        public static final EnumSet<MatchOption> MATCH_ALWAYS;
        public static final EnumSet<MatchOption> MATCH_ALL;
        public static final EnumSet<MatchOption> MATCH_ITEM;
        public static final EnumSet<MatchOption> MATCH_ITEM_SIZE;
        public static final EnumSet<MatchOption> MATCH_ITEM_NBT;
        public static final EnumSet<MatchOption> MATCH_ITEM_DAMAGE;
        public static final EnumSet<MatchOption> MATCH_ITEM_DAMAGE_NBT;
        public static final EnumSet<MatchOption> MATCH_EXISTING_STACK;

        static {
            MATCH_ALWAYS = EnumSet.noneOf(MatchOption.class);
            MATCH_ALL = EnumSet.of(Item, Size, Damage, NBT, Capabilities);
            MATCH_ITEM = EnumSet.of(Item);
            MATCH_ITEM_SIZE = EnumSet.of(Item, Size);
            MATCH_ITEM_NBT = EnumSet.of(Item, NBT);
            MATCH_ITEM_DAMAGE = EnumSet.of(Item, Damage);
            MATCH_ITEM_DAMAGE_NBT = EnumSet.of(Item, Damage, NBT);
            MATCH_EXISTING_STACK = EnumSet.of(Item, Damage, NBT, Capabilities);
        }
    }
}

