/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.data.geometry;

import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class Vector3d
implements Position {
    public static final Vector3d ZERO = new Vector3d();
    public static final Vector3d HALF = new Vector3d(0.5, 0.5, 0.5);
    public static final Vector3d XN = new Vector3d(-1.0, 0.0, 0.0);
    public static final Vector3d XP = new Vector3d(1.0, 0.0, 0.0);
    public static final Vector3d YN = new Vector3d(0.0, -1.0, 0.0);
    public static final Vector3d YP = new Vector3d(0.0, 1.0, 0.0);
    public static final Vector3d ZN = new Vector3d(0.0, 0.0, -1.0);
    public static final Vector3d ZP = new Vector3d(0.0, 0.0, 1.0);
    public final double X;
    public final double Y;
    public final double Z;

    public Vector3d(double x, double y, double z) {
        this.X = x;
        this.Y = y;
        this.Z = z;
    }

    public Vector3d(Vector3d other) {
        this(other.X, other.Y, other.Z);
    }

    public Vector3d(Vec3i other) {
        this(other.m_123341_(), other.m_123342_(), other.m_123343_());
    }

    public static Vector3d from(Vec3i data) {
        return new Vector3d(data.m_123341_(), data.m_123342_(), data.m_123343_());
    }

    public static Vector3d from(Vector3f data) {
        return new Vector3d(data.x(), data.y(), data.z());
    }

    public static Vector3d from(Vector4f data) {
        return new Vector3d(data.x(), data.y(), data.z());
    }

    public static Vector3d fromCenter(Vec3i data) {
        return new Vector3d((double)data.m_123341_() + 0.5, (double)data.m_123342_() + 0.5, (double)data.m_123343_() + 0.5);
    }

    public static Vector3d from(Entity data) {
        return new Vector3d(data.m_20185_(), data.m_20186_(), data.m_20189_());
    }

    public static Vector3d fromCenter(Entity data) {
        return new Vector3d(data.m_20185_() + 0.5, data.m_20186_() + 0.5, data.m_20189_() + 0.5);
    }

    public static Vector3d from(BlockEntity data) {
        return Vector3d.from((Vec3i)data.m_58899_());
    }

    public static Vector3d fromCenter(BlockEntity data) {
        return Vector3d.fromCenter((Vec3i)data.m_58899_());
    }

    public static Vector3d syncDataFrom(CompoundTag data) {
        return new Vector3d(data.m_128459_("vx"), data.m_128459_("vy"), data.m_128459_("vz"));
    }

    public CompoundTag syncDataTo(CompoundTag data) {
        data.m_128347_("vx", this.X);
        data.m_128347_("vy", this.Y);
        data.m_128347_("vz", this.Z);
        return data;
    }

    public Vec3i toVec3i() {
        return new Vec3i(Mth.m_14107_((double)this.X), Mth.m_14107_((double)this.Y), Mth.m_14107_((double)this.Z));
    }

    public BlockPos toBlockPos() {
        return new BlockPos(Mth.m_14107_((double)this.X), Mth.m_14107_((double)this.Y), Mth.m_14107_((double)this.Z));
    }

    public Vector3d add(double offsetX, double offsetY, double offsetZ) {
        return new Vector3d(this.X + offsetX, this.Y + offsetY, this.Z + offsetZ);
    }

    public Vector3d add(double offset) {
        return this.add(offset, offset, offset);
    }

    public Vector3d add(Vector3d v) {
        return this.add(v.X, v.Y, v.Z);
    }

    public Vector3d add(Vec3i v) {
        return this.add(v.m_123341_(), v.m_123342_(), v.m_123343_());
    }

    public Vector3d subtract(double offsetX, double offsetY, double offsetZ) {
        return this.add(-offsetX, -offsetY, -offsetZ);
    }

    public Vector3d subtract(double offset) {
        return this.subtract(offset, offset, offset);
    }

    public Vector3d subtract(Vec3i v) {
        return this.subtract(v.m_123341_(), v.m_123342_(), v.m_123343_());
    }

    public Vector3d subtract(Vector3d v) {
        return this.subtract(v.X, v.Y, v.Z);
    }

    public Vector3d multiply(double factorX, double factorY, double factorZ) {
        return new Vector3d(this.X * factorX, this.Y * factorY, this.Z * factorZ);
    }

    public Vector3d multiply(double factor) {
        return this.multiply(factor, factor, factor);
    }

    public Vector3d multiply(Vec3i factor) {
        return this.multiply(factor.m_123341_(), factor.m_123342_(), factor.m_123343_());
    }

    public Vector3d multiply(Vector3d v) {
        return this.multiply(v.m_7096_(), v.m_7098_(), v.m_7094_());
    }

    public Vector3d divide(double factorX, double factorY, double factorZ) {
        return new Vector3d(this.X / factorX, this.Y / factorY, this.Z / factorZ);
    }

    public Vector3d divide(double factor) {
        return this.divide(factor, factor, factor);
    }

    public Vector3d divide(Vec3i factor) {
        return this.divide(factor.m_123341_(), factor.m_123342_(), factor.m_123343_());
    }

    public Vector3d ceil() {
        return new Vector3d(Mth.m_14165_((double)this.X), Mth.m_14165_((double)this.Y), Mth.m_14165_((double)this.Z));
    }

    public Vector3d floor() {
        return new Vector3d(Mth.m_14107_((double)this.X), Mth.m_14107_((double)this.Y), Mth.m_14107_((double)this.Z));
    }

    public Vector3d crossProduct(Vector3d vec) {
        return new Vector3d(this.Y * vec.Z - this.Z * vec.Y, this.Z * vec.X - this.X * vec.Z, this.X * vec.Y - this.Y * vec.X);
    }

    public double magnitude() {
        return Math.sqrt(this.X * this.X + this.Y * this.Y + this.Z * this.Z);
    }

    public Vector3d normalize() {
        double magnitude = this.magnitude();
        if (0.0 != magnitude) {
            return this.multiply(1.0 / magnitude);
        }
        return this;
    }

    public double scalarProduct(double x, double y, double z) {
        return this.X * x + this.Y * y + this.Z * z;
    }

    public double scalarProduct(Vector3d vector) {
        double product = this.X * vector.X + this.Y * vector.Y + this.Z * vector.Z;
        if (product > 1.0 && product < 1.00001) {
            product = 1.0;
        } else if (product < -1.0 && product > -1.00001) {
            product = -1.0;
        }
        return product;
    }

    public double m_7096_() {
        return this.X;
    }

    public double m_7098_() {
        return this.Y;
    }

    public double m_7094_() {
        return this.Z;
    }

    public boolean equals(Object other) {
        if (other instanceof Vector3d) {
            Vector3d v = (Vector3d)other;
            return this.X == v.X && this.Y == v.Y && this.Z == v.Z;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.X, this.Y, this.Z);
    }

    public String toString() {
        return String.format("Vector3d (%f, %f, %f)", this.X, this.Y, this.Z);
    }

    private Vector3d() {
        this.Z = 0.0;
        this.Y = 0.0;
        this.X = 0.0;
    }
}

