/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.zerocore.lib.client.gui.sprite;

import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISprite;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteBuilder;
import it.zerono.mods.zerocore.lib.client.gui.sprite.ISpriteTextureMap;
import it.zerono.mods.zerocore.lib.client.render.ModRenderHelper;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraftforge.common.util.NonNullConsumer;

public class AtlasSpriteTextureMap
implements ISpriteTextureMap {
    public static final AtlasSpriteTextureMap BLOCKS = new AtlasSpriteTextureMap(InventoryMenu.f_39692_);
    private final ResourceLocation _atlasName;
    private int _atlasWidth;
    private int _atlasHeight;

    public static AtlasSpriteTextureMap from(TextureAtlasSprite sprite) {
        ResourceLocation id = sprite.m_247685_();
        if (BLOCKS.getTextureLocation().equals((Object)id)) {
            return BLOCKS;
        }
        return new AtlasSpriteTextureMap(id);
    }

    public AtlasSpriteTextureMap(ResourceLocation atlasName) {
        this._atlasName = atlasName;
        this._atlasHeight = -1;
        this._atlasWidth = -1;
    }

    public ISprite sprite(ResourceLocation spriteName) {
        return this.sprite((TextureAtlasSprite)Minecraft.m_91087_().m_91258_(this._atlasName).apply(spriteName));
    }

    public ISprite sprite(TextureAtlasSprite sprite, ISprite overlay) {
        return this.makeSprite(sprite, overlay);
    }

    public ISprite sprite(TextureAtlasSprite sprite) {
        return this.makeSprite(sprite, null);
    }

    @Override
    public ResourceLocation getTextureLocation() {
        return this._atlasName;
    }

    @Override
    public int getWidth() {
        return this._atlasWidth;
    }

    @Override
    public int getHeight() {
        return this._atlasHeight;
    }

    @Override
    public ISpriteBuilder sprite() {
        throw new UnsupportedOperationException();
    }

    private ISprite makeSprite(TextureAtlasSprite sprite, @Nullable ISprite overlay) {
        int spriteX = sprite.m_174743_();
        int spriteY = sprite.m_174744_();
        if (this._atlasHeight < 0 || this._atlasWidth < 0) {
            IntIntPair dimensions = ModRenderHelper.getAtlasDimensions(sprite);
            this._atlasWidth = dimensions.firstInt();
            this._atlasHeight = dimensions.secondInt();
        }
        return new AtlasSprite(this, sprite, spriteX, spriteY, overlay);
    }

    static class AtlasSprite
    implements ISprite {
        private final ISpriteTextureMap _map;
        private final TextureAtlasSprite _atlasSprite;
        private final ISprite _overlay;
        private final int _u;
        private final int _v;

        public AtlasSprite(ISpriteTextureMap textureMap, TextureAtlasSprite sprite, int u, int v, @Nullable ISprite overlay) {
            this._map = textureMap;
            this._atlasSprite = sprite;
            this._overlay = overlay;
            this._u = u;
            this._v = v;
        }

        @Override
        public int getWidth() {
            return this._atlasSprite.m_245424_().m_246492_();
        }

        @Override
        public int getHeight() {
            return this._atlasSprite.m_245424_().m_245330_();
        }

        @Override
        public int getU() {
            return this._u;
        }

        @Override
        public int getV() {
            return this._v;
        }

        @Override
        public float getMinU() {
            return this._atlasSprite.m_118409_();
        }

        @Override
        public float getMaxU() {
            return this._atlasSprite.m_118410_();
        }

        @Override
        public float getMinV() {
            return this._atlasSprite.m_118411_();
        }

        @Override
        public float getMaxV() {
            return this._atlasSprite.m_118412_();
        }

        @Override
        public Optional<TextureAtlasSprite> getAtlasSprite() {
            return Optional.of(this._atlasSprite);
        }

        @Override
        public ISpriteTextureMap getTextureMap() {
            return this._map;
        }

        @Override
        public Optional<ISprite> getSpriteOverlay() {
            return Optional.ofNullable(this._overlay);
        }

        @Override
        public void applyOverlay(NonNullConsumer<ISprite> overlayConsumer) {
            if (null != this._overlay) {
                overlayConsumer.accept((Object)this._overlay);
            }
        }

        @Override
        public ISprite copy() {
            return new AtlasSprite(this);
        }

        @Override
        public ISprite copyWith(ISprite overlay) {
            return new AtlasSprite(this, overlay);
        }

        protected AtlasSprite(AtlasSprite other) {
            this(other, null);
        }

        protected AtlasSprite(AtlasSprite other, @Nullable ISprite overlay) {
            this._map = other._map;
            this._atlasSprite = other._atlasSprite;
            this._overlay = overlay;
            this._u = other._u;
            this._v = other._v;
        }
    }
}

