/*
 * Decompiled with CFR 0.152.
 */
package dev.shadowsoffire.wstweaks;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.shadowsoffire.wstweaks.ItemImmolationBlade;
import dev.shadowsoffire.wstweaks.WSTConfig;
import dev.shadowsoffire.wstweaks.WitherSkeletonTweaks;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.function.Supplier;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.monster.WitherSkeleton;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;

public class WSTLootModifier
extends LootModifier {
    public static final Supplier<Codec<WSTLootModifier>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> WSTLootModifier.codecStart((RecordCodecBuilder.Instance)inst).apply((Applicative)inst, WSTLootModifier::new)));

    protected WSTLootModifier(LootItemCondition[] conditionsIn) {
        super(conditionsIn);
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext ctx) {
        Entity ent = (Entity)ctx.m_78953_(LootContextParams.f_81455_);
        DamageSource src = (DamageSource)ctx.m_78953_(LootContextParams.f_81457_);
        if (src != null && ent != null && (src.m_269150_().m_203565_(DamageTypes.f_268428_) || WSTLootModifier.hasSword(src))) {
            if (ent.getClass() == WitherSkeleton.class) {
                if (generatedLoot.stream().noneMatch(i -> i.m_41720_() == Items.f_42679_)) {
                    generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42679_));
                }
            } else if (ent instanceof AbstractSkeleton) {
                generatedLoot.add((Object)new ItemStack((ItemLike)Items.f_42678_));
            }
        }
        if (ent != null && ent.getClass() == WitherSkeleton.class && ctx.m_230907_().m_188501_() <= WSTConfig.shardDropChance && generatedLoot.stream().noneMatch(i -> i.m_41720_() == Items.f_42679_)) {
            generatedLoot.add((Object)new ItemStack((ItemLike)WitherSkeletonTweaks.fragment));
        }
        return generatedLoot;
    }

    private static boolean hasSword(DamageSource source) {
        Entity s = source.m_7639_();
        if (s instanceof LivingEntity) {
            return ((LivingEntity)s).m_21205_().m_41720_() instanceof ItemImmolationBlade;
        }
        return false;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

