/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client.entity.model;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.function.Function;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import tamaized.voidscape.regutil.RegUtil;

public class ModelArmorTitanite<T extends LivingEntity>
extends HumanoidModel<T> {
    private final ImmutableList<ModelPart> parts;
    public ModelPart head;
    public ModelPart headoverlay;
    public ModelPart body;
    public ModelPart leftarm;
    public ModelPart rightarm;
    public ModelPart leftleg;
    public ModelPart rightleg;
    public ModelPart leftfoot;
    public ModelPart rightfoot;
    private final boolean fullbright;

    public ModelArmorTitanite(ModelPart p_170677_) {
        this(p_170677_, false);
    }

    public ModelArmorTitanite(ModelPart p_170677_, boolean fullbright) {
        this(p_170677_, RenderType::m_110458_, fullbright);
    }

    public ModelArmorTitanite(ModelPart parent, Function<ResourceLocation, RenderType> p_170680_, boolean fullbright) {
        super(parent, p_170680_);
        this.fullbright = fullbright;
        ImmutableList.Builder builder = ImmutableList.builder();
        this.head = parent.m_171324_("realhead");
        builder.add((Object[])new ModelPart[]{this.head, this.headoverlay = parent.m_171324_("headoverlay"), this.body = parent.m_171324_("realbody"), this.leftarm = parent.m_171324_("leftarm"), this.rightarm = parent.m_171324_("rightarm"), this.leftleg = parent.m_171324_("leftleg"), this.rightleg = parent.m_171324_("rightleg"), this.leftfoot = parent.m_171324_("leftfoot"), this.rightfoot = parent.m_171324_("rightfoot")});
        this.parts = builder.build();
    }

    public static LayerDefinition makeMesh(CubeDeformation deformation, float f) {
        MeshDefinition mesh = new MeshDefinition();
        PartDefinition definition = mesh.m_171576_();
        definition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + f), (float)0.0f));
        definition.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, deformation.m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)(0.0f + f), (float)0.0f));
        definition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)0.0f, (float)(0.0f + f), (float)0.0f));
        definition.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-5.0f, (float)(2.0f + f), (float)0.0f));
        definition.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)5.0f, (float)(2.0f + f), (float)0.0f));
        definition.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)-1.9f, (float)(12.0f + f), (float)0.0f));
        definition.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171480_().m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, deformation), PartPose.m_171419_((float)1.9f, (float)(12.0f + f), (float)0.0f));
        definition.m_171599_("realhead", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)).m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.5f)).m_171514_(0, 32).m_171488_(-2.0f, -10.0f, -4.5f, 4.0f, 0.5f, 4.0f, new CubeDeformation(0.5f)).m_171514_(0, 37).m_171488_(-1.0f, -11.76f, -4.74f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.26f)).m_171514_(0, 40).m_171488_(-1.13f, -13.15f, -4.87f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.13f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("headoverlay", CubeListBuilder.m_171558_().m_171514_(32, 0).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f).m_171469_(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("realbody", CubeListBuilder.m_171558_().m_171514_(16, 16).m_171488_(-4.0f, 0.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        definition.m_171599_("leftarm", CubeListBuilder.m_171558_().m_171514_(32, 48).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(52, 60).m_171488_(0.24f, -3.78f, -2.24f, 3.0f, 0.02f, 3.0f, new CubeDeformation(0.76f)).m_171514_(56, 57).m_171488_(1.47f, -5.55f, -2.49f, 2.01f, 0.5f, 2.0f, new CubeDeformation(0.51f)).m_171514_(60, 55).m_171488_(2.745f, -7.315f, -2.745f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.255f)), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        definition.m_171599_("rightarm", CubeListBuilder.m_171558_().m_171514_(40, 16).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)).m_171514_(0, 60).m_171488_(-3.24f, -3.78f, -2.24f, 3.0f, 0.02f, 3.0f, new CubeDeformation(0.76f)).m_171514_(0, 57).m_171488_(-3.49f, -5.55f, -2.49f, 2.01f, 0.5f, 2.0f, new CubeDeformation(0.51f)).m_171514_(0, 55).m_171488_(-3.745f, -7.315f, -2.745f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.255f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        definition.m_171599_("leftleg", CubeListBuilder.m_171558_().m_171514_(32, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)1.9f, (float)24.0f, (float)0.0f));
        definition.m_171599_("rightleg", CubeListBuilder.m_171558_().m_171514_(16, 32).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)24.0f, (float)0.0f));
        definition.m_171599_("leftfoot", CubeListBuilder.m_171558_().m_171514_(16, 48).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        definition.m_171599_("rightfoot", CubeListBuilder.m_171558_().m_171514_(0, 16).m_171488_(-2.0f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)mesh, (int)64, (int)64);
    }

    public void m_7695_(PoseStack matrixStackIn, VertexConsumer bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.head.m_104315_(this.f_102808_);
        this.headoverlay.m_104315_(this.f_102809_);
        this.body.m_104315_(this.f_102810_);
        this.leftarm.m_104315_(this.f_102812_);
        this.rightarm.m_104315_(this.f_102811_);
        this.leftleg.m_104315_(this.f_102814_);
        this.rightleg.m_104315_(this.f_102813_);
        this.leftfoot.m_104315_(this.f_102814_);
        this.rightfoot.m_104315_(this.f_102813_);
        this.parts.forEach(part -> part.m_104306_(matrixStackIn, bufferIn, this.fullbright || RegUtil.renderingArmorOverlay ? 0xF000F0 : packedLightIn, packedOverlayIn, red, green, blue, alpha));
    }

    public ModelPart m_5585_() {
        return this.head;
    }
}

