/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client.ui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.event.TickEvent;
import tamaized.voidscape.Voidscape;
import tamaized.voidscape.capability.Insanity;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.client.ClientUtil;
import tamaized.voidscape.client.Shaders;
import tamaized.voidscape.client.StencilBufferUtil;

public class RenderTurmoil {
    public static final int STENCIL_INDEX = 10;
    public static final ResourceLocation TEXTURE_MASK = new ResourceLocation("voidscape", "textures/ui/mask.png");
    static final ResourceLocation TEXTURE_VOIDICINFUSION = new ResourceLocation("voidscape", "textures/ui/voidicinfusion.png");
    static final ResourceLocation TEXTURE_WATCHINGYOU = new ResourceLocation("voidscape", "textures/ui/watchingyou.png");
    private static float deltaTick;
    private static float lastDeltaTick;
    private static float lastTeleportTick;

    public static void tick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().m_91104_() || Minecraft.m_91087_().f_91073_ == null) {
            return;
        }
        lastDeltaTick = deltaTick;
        ++ClientUtil.tick;
        if (Minecraft.m_91087_().f_91074_ != null) {
            Minecraft.m_91087_().f_91074_.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> {
                if ((float)data.getTeleportTick() >= lastTeleportTick + 20.0f || lastTeleportTick == 0.0f && data.getTeleportTick() > 0) {
                    Minecraft.m_91087_().f_91074_.m_5496_(SoundEvents.f_11822_, 4.0f, 1.0f);
                    lastTeleportTick = data.getTeleportTick();
                }
                if ((float)data.getTeleportTick() < lastTeleportTick) {
                    lastTeleportTick = data.getTeleportTick();
                }
                if ((float)data.getTeleportTick() > deltaTick) {
                    deltaTick += 1.0f;
                } else if ((float)data.getTeleportTick() < deltaTick) {
                    deltaTick -= 1.0f;
                }
            }));
        }
    }

    public static void render(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("turmoil", (gui, poseStack, partialTick, width, height) -> {
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            if (world != null && Minecraft.m_91087_().f_91074_ != null) {
                Minecraft.m_91087_().f_91074_.getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(Voidscape.subCapInsanity).ifPresent(data -> {
                    RenderTurmoil.renderInsanity(data, poseStack.m_280168_(), partialTick);
                    float perc = Mth.m_14036_((float)(Mth.m_14179_((float)partialTick, (float)lastDeltaTick, (float)deltaTick) / 200.0f), (float)0.0f, (float)1.0f);
                    if (perc > 0.0f) {
                        RenderSystem.enableBlend();
                        Window window = Minecraft.m_91087_().m_91268_();
                        float x = 0.0f;
                        float y = 0.0f;
                        float w = window.m_85445_();
                        float h = window.m_85446_();
                        float z = 401.0f;
                        ClientUtil.bindTexture(TEXTURE_MASK);
                        Color24.INSTANCE.set(1.0f, 1.0f, 1.0f, 1.0f).apply(true, x, y, z, w, h);
                        StencilBufferUtil.setup(10, () -> Shaders.OPTIMAL_ALPHA_LESSTHAN_POS_TEX_COLOR.invokeThenEndTesselator(perc));
                        Color24.INSTANCE.set(0.0f, 0.0f, 0.0f, 1.0f).apply(false, x, y, z, w, h);
                        StencilBufferUtil.renderAndFlush(10, () -> Shaders.WRAPPED_POS_COLOR.invokeThenEndTesselator());
                        RenderSystem.disableBlend();
                    }
                }));
            }
        });
    }

    private static void renderInsanity(Insanity insanity, PoseStack matrixStack, float partialTicks) {
        RenderTurmoil.renderInfusion(insanity, matrixStack, partialTicks);
        RenderTurmoil.renderParanoia(insanity, matrixStack, partialTicks);
    }

    private static void renderParanoia(Insanity insanity, PoseStack matrixStack, float partialTicks) {
        if (insanity.getParanoia() < 500.0f) {
            return;
        }
        float perc = (insanity.getParanoia() - 500.0f) / 90.0f;
        perc = Mth.m_14036_((float)perc, (float)0.0f, (float)1.0f);
        perc *= 0.25f;
        float endPerc = (insanity.getParanoia() - 590.0f) / 10.0f;
        endPerc = Mth.m_14036_((float)endPerc, (float)0.0f, (float)1.0f);
        perc += (endPerc *= 0.15f);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        ClientUtil.bindTexture(TEXTURE_WATCHINGYOU);
        float w = Minecraft.m_91087_().m_91268_().m_85445_();
        float h = Minecraft.m_91087_().m_91268_().m_85446_();
        buffer.m_5483_(0.0, (double)h, 0.0).m_7421_(0.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_((double)w, (double)h, 0.0).m_7421_(1.0f, 1.0f).m_85950_(1.0f, 1.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_((double)w, 0.0, 0.0).m_7421_(1.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, perc).m_5752_();
        RenderSystem.enableBlend();
        Shaders.OPTIMAL_ALPHA_GREATERTHAN_POS_TEX_COLOR.invokeThenEndTesselator(0.0f);
        RenderSystem.disableBlend();
    }

    private static void renderInfusion(Insanity insanity, PoseStack matrixStack, float partialTicks) {
        if (insanity.getInfusion() <= 0.0f) {
            return;
        }
        float perc = insanity.getInfusion() / 600.0f;
        perc = Mth.m_14036_((float)perc, (float)0.0f, (float)1.0f);
        BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
        buffer.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85819_);
        ClientUtil.bindTexture(TEXTURE_VOIDICINFUSION);
        float w = Minecraft.m_91087_().m_91268_().m_85445_();
        float h = Minecraft.m_91087_().m_91268_().m_85446_();
        buffer.m_5483_(0.0, (double)h, 0.0).m_7421_(0.0f, 1.0f).m_85950_(0.4f, 0.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_((double)w, (double)h, 0.0).m_7421_(1.0f, 1.0f).m_85950_(0.4f, 0.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_((double)w, 0.0, 0.0).m_7421_(1.0f, 0.0f).m_85950_(0.4f, 0.0f, 1.0f, perc).m_5752_();
        buffer.m_5483_(0.0, 0.0, 0.0).m_7421_(0.0f, 0.0f).m_85950_(0.4f, 0.0f, 1.0f, perc).m_5752_();
        RenderSystem.enableBlend();
        Shaders.OPTIMAL_ALPHA_GREATERTHAN_POS_TEX_COLOR.invokeThenEndTesselator(0.0f);
        RenderSystem.disableBlend();
    }

    public static class Color24 {
        public static final Color24 INSTANCE = new Color24();
        public int bit24;
        public int bit16;
        public int bit8;
        public int bit0;

        private Color24() {
        }

        public static float asFloat(int value) {
            return (float)value / 255.0f;
        }

        public static int asInt(float value) {
            return (int)(value * 255.0f);
        }

        public int packed() {
            return this.bit24 << 24 | this.bit16 << 16 | this.bit8 << 8 | this.bit0;
        }

        public Color24 unpack(int packed) {
            return this.set(packed >> 24 & 0xFF, packed >> 16 & 0xFF, packed >> 8 & 0xFF, packed & 0xFF);
        }

        public Color24 apply(boolean tex, float x, float y, float z, float w, float h) {
            BufferBuilder buffer = Tesselator.m_85913_().m_85915_();
            buffer.m_166779_(VertexFormat.Mode.QUADS, tex ? DefaultVertexFormat.f_85819_ : DefaultVertexFormat.f_85815_);
            float r = Color24.asFloat(this.bit24);
            float g = Color24.asFloat(this.bit16);
            float b = Color24.asFloat(this.bit8);
            float a = Color24.asFloat(this.bit0);
            buffer.m_5483_((double)x, (double)(y + h), (double)z);
            if (tex) {
                buffer.m_7421_(0.0f, 1.0f);
            }
            buffer.m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(x + w), (double)(y + h), (double)z);
            if (tex) {
                buffer.m_7421_(1.0f, 1.0f);
            }
            buffer.m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)(x + w), (double)y, (double)z);
            if (tex) {
                buffer.m_7421_(1.0f, 0.0f);
            }
            buffer.m_85950_(r, g, b, a).m_5752_();
            buffer.m_5483_((double)x, (double)y, (double)z);
            if (tex) {
                buffer.m_7421_(0.0f, 0.0f);
            }
            buffer.m_85950_(r, g, b, a).m_5752_();
            return this;
        }

        public void endTesselator() {
            Tesselator.m_85913_().m_85914_();
        }

        public Color24 set(int b24, int b16, int b8, int b0) {
            this.bit0 = b0;
            this.bit8 = b8;
            this.bit16 = b16;
            this.bit24 = b24;
            return this;
        }

        public Color24 set(float b24, float b16, float b8, float b0) {
            this.set(Color24.asInt(b24), Color24.asInt(b16), Color24.asInt(b8), Color24.asInt(b0));
            return this;
        }
    }
}

