/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape.client;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ModelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;
import tamaized.voidscape.registry.ModArmors;
import tamaized.voidscape.registry.ModTools;
import tamaized.voidscape.regutil.RegUtil;

@Mod.EventBusSubscriber(modid="voidscape", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ModelBakeListener {
    private static final Map<ResourceLocation, ResourceLocation> REMAPPER = new HashMap<ResourceLocation, ResourceLocation>();

    @SubscribeEvent
    public static void modelBake(ModelEvent.ModifyBakingResult event) {
        ModelBakeListener.impBroken((Item)ModTools.VOIDIC_CRYSTAL_SWORD.get());
        ModelBakeListener.impBroken((Item)ModTools.VOIDIC_CRYSTAL_AXE.get());
        ModelBakeListener.impBroken((Item)ModTools.VOIDIC_CRYSTAL_BOW.get());
        ModelBakeListener.impBroken((Item)ModTools.VOIDIC_CRYSTAL_XBOW.get());
        ModelBakeListener.impBroken((Item)ModTools.VOIDIC_CRYSTAL_PICKAXE.get());
        ModelBakeListener.impBroken((Item)ModArmors.VOIDIC_CRYSTAL_HELMET.get());
        ModelBakeListener.impBroken((Item)ModArmors.VOIDIC_CRYSTAL_CHEST.get());
        ModelBakeListener.impBroken((Item)ModArmors.VOIDIC_CRYSTAL_LEGS.get());
        ModelBakeListener.impBroken((Item)ModArmors.VOIDIC_CRYSTAL_BOOTS.get());
        ModelBakeListener.impBroken((Item)ModTools.CHARRED_WARHAMMER.get());
        ModelBakeListener.impBroken((Item)ModTools.CORRUPT_SWORD.get());
        ModelBakeListener.impBroken((Item)ModTools.CORRUPT_AXE.get());
        ModelBakeListener.impBroken((Item)ModTools.CORRUPT_BOW.get());
        ModelBakeListener.impBroken((Item)ModTools.CORRUPT_XBOW.get());
        ModelBakeListener.impBroken((Item)ModArmors.CORRUPT_HELMET.get());
        ModelBakeListener.impBroken((Item)ModArmors.CORRUPT_CHEST.get());
        ModelBakeListener.impBroken((Item)ModArmors.CORRUPT_LEGS.get());
        ModelBakeListener.impBroken((Item)ModArmors.CORRUPT_BOOTS.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_SWORD.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_AXE.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_PICKAXE.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_HOE.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_BOW.get());
        ModelBakeListener.impBroken((Item)ModTools.TITANITE_XBOW.get());
        ModelBakeListener.impBroken((Item)ModArmors.TITANITE_HELMET.get());
        ModelBakeListener.impBroken((Item)ModArmors.TITANITE_CHEST.get());
        ModelBakeListener.impBroken((Item)ModArmors.TITANITE_LEGS.get());
        ModelBakeListener.impBroken((Item)ModArmors.TITANITE_BOOTS.get());
        ModelBakeListener.impBroken((Item)ModTools.ICHOR_SWORD.get());
        ModelBakeListener.impBroken((Item)ModTools.ICHOR_AXE.get());
        ModelBakeListener.impBroken((Item)ModTools.ICHOR_PICKAXE.get());
        ModelBakeListener.impBroken((Item)ModTools.ICHOR_BOW.get());
        ModelBakeListener.impBroken((Item)ModTools.ICHOR_XBOW.get());
        ModelBakeListener.impBroken((Item)ModArmors.ICHOR_HELMET.get());
        ModelBakeListener.impBroken((Item)ModArmors.ICHOR_CHEST.get());
        ModelBakeListener.impBroken((Item)ModArmors.ICHOR_LEGS.get());
        ModelBakeListener.impBroken((Item)ModArmors.ICHOR_BOOTS.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_SWORD.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_AXE.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_PICKAXE.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_SHOVEL.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_BOW.get());
        ModelBakeListener.impBroken((Item)ModTools.ASTRAL_XBOW.get());
        ModelBakeListener.impBroken((Item)ModArmors.ASTRAL_HELMET.get());
        ModelBakeListener.impBroken((Item)ModArmors.ASTRAL_CHEST.get());
        ModelBakeListener.impBroken((Item)ModArmors.ASTRAL_LEGS.get());
        ModelBakeListener.impBroken((Item)ModArmors.ASTRAL_BOOTS.get());
        ModelBakeListener.impBow((Item)ModTools.VOIDIC_CRYSTAL_BOW.get());
        ModelBakeListener.impBow((Item)ModTools.CORRUPT_BOW.get());
        ModelBakeListener.impBow((Item)ModTools.TITANITE_BOW.get());
        ModelBakeListener.impBow((Item)ModTools.ICHOR_BOW.get());
        ModelBakeListener.impBow((Item)ModTools.ASTRAL_BOW.get());
        ModelBakeListener.impXBow((Item)ModTools.VOIDIC_CRYSTAL_XBOW.get());
        ModelBakeListener.impXBow((Item)ModTools.CORRUPT_XBOW.get());
        ModelBakeListener.impXBow((Item)ModTools.TITANITE_XBOW.get());
        ModelBakeListener.impXBow((Item)ModTools.ICHOR_XBOW.get());
        ModelBakeListener.impXBow((Item)ModTools.ASTRAL_XBOW.get());
        ModelBakeListener.impShield((Item)ModTools.VOIDIC_CRYSTAL_SHIELD.get());
    }

    private static void impBroken(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("broken"), (stack, level, entity, prop) -> RegUtil.ToolAndArmorHelper.isBroken(stack) ? 1.0f : 0.0f);
    }

    private static void impBow(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (stack, level, entity, prop) -> entity == null ? 0.0f : (entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f));
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (stack, level, entity, prop) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    private static void impXBow(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pull"), (stack, level, entity, prop) -> entity == null ? 0.0f : (CrossbowItem.m_40932_((ItemStack)stack) ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / (float)CrossbowItem.m_40939_((ItemStack)stack)));
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("pulling"), (stack, level, entity, prop) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack && !CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("charged"), (stack, level, entity, prop) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("firework"), (stack, level, entity, prop) -> entity != null && CrossbowItem.m_40932_((ItemStack)stack) && CrossbowItem.m_40871_((ItemStack)stack, (Item)Items.f_42688_) ? 1.0f : 0.0f);
    }

    private static void impShield(Item item) {
        ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("blocking"), (stack, level, entity, prop) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
    }

    public static void redirectModels(ModelBakery bakery) {
        ModelBakeListener.redirectModelLocation(bakery, "voidic", "voidic_crystal_", ModTools.VOIDIC_CRYSTAL_AXE, ModTools.VOIDIC_CRYSTAL_PICKAXE, ModTools.VOIDIC_CRYSTAL_SWORD, ModTools.VOIDIC_CRYSTAL_SHIELD, ModTools.VOIDIC_CRYSTAL_BOW, ModTools.VOIDIC_CRYSTAL_XBOW, ModArmors.VOIDIC_CRYSTAL_HELMET, ModArmors.VOIDIC_CRYSTAL_CHEST, ModArmors.VOIDIC_CRYSTAL_LEGS, ModArmors.VOIDIC_CRYSTAL_BOOTS);
        ModelBakeListener.redirectModelLocation(bakery, "charred", "charred_", ModTools.CHARRED_WARHAMMER);
        ModelBakeListener.redirectModelLocation(bakery, "corrupt", "corrupt_", ModTools.CORRUPT_AXE, ModTools.CORRUPT_SWORD, ModTools.CORRUPT_BOW, ModTools.CORRUPT_XBOW, ModArmors.CORRUPT_HELMET, ModArmors.CORRUPT_CHEST, ModArmors.CORRUPT_LEGS, ModArmors.CORRUPT_BOOTS);
        ModelBakeListener.redirectModelLocation(bakery, "titanite", "titanite_", ModTools.TITANITE_AXE, ModTools.TITANITE_PICKAXE, ModTools.TITANITE_HOE, ModTools.TITANITE_SWORD, ModTools.TITANITE_BOW, ModTools.TITANITE_XBOW, ModArmors.TITANITE_HELMET, ModArmors.TITANITE_CHEST, ModArmors.TITANITE_LEGS, ModArmors.TITANITE_BOOTS);
        ModelBakeListener.redirectModelLocation(bakery, "ichor", "ichor_", ModTools.ICHOR_SWORD, ModTools.ICHOR_AXE, ModTools.ICHOR_PICKAXE, ModTools.ICHOR_BOW, ModTools.ICHOR_XBOW, ModArmors.ICHOR_HELMET, ModArmors.ICHOR_CHEST, ModArmors.ICHOR_LEGS, ModArmors.ICHOR_BOOTS);
        ModelBakeListener.redirectModelLocation(bakery, "astral", "astral_", ModTools.ASTRAL_SWORD, ModTools.ASTRAL_AXE, ModTools.ASTRAL_PICKAXE, ModTools.ASTRAL_SHOVEL, ModTools.ASTRAL_BOW, ModTools.ASTRAL_XBOW, ModArmors.ASTRAL_HELMET, ModArmors.ASTRAL_CHEST, ModArmors.ASTRAL_LEGS, ModArmors.ASTRAL_BOOTS);
    }

    @SafeVarargs
    private static void redirectModelLocation(ModelBakery bakery, String subfolder, String remove, RegistryObject<Item> ... items) {
        for (RegistryObject<Item> item : items) {
            ResourceLocation location = item.getId();
            if (location == null) continue;
            ModelResourceLocation oldMrl = new ModelResourceLocation(location, "inventory");
            ResourceLocation rl = new ResourceLocation(location.m_135827_(), subfolder.concat("/").concat(location.m_135815_().replaceFirst(remove, "")));
            ModelResourceLocation mrl = new ModelResourceLocation(rl, "inventory");
            REMAPPER.put(location, rl);
            bakery.m_119306_(mrl);
            bakery.f_119212_.put(oldMrl, (UnbakedModel)bakery.f_119212_.get(mrl));
            Minecraft.m_91087_().m_91291_().m_115103_().m_109396_((Item)item.get(), mrl);
        }
    }

    public static void clearOldModels(ModelBakery bakery) {
        REMAPPER.keySet().forEach(location -> {
            ModelResourceLocation oldMrl = new ModelResourceLocation(location, "inventory");
            bakery.f_119212_.remove(oldMrl);
            bakery.f_119214_.remove(oldMrl);
        });
    }
}

