/*
 * Decompiled with CFR 0.152.
 */
package tamaized.voidscape;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import java.nio.file.Path;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.PathPackResources;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.ConfigScreenHandler;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import tamaized.voidscape.Config;
import tamaized.voidscape.VoidCommands;
import tamaized.voidscape.asm.ASMHooks;
import tamaized.voidscape.capability.DonatorData;
import tamaized.voidscape.capability.Insanity;
import tamaized.voidscape.capability.SubCapability;
import tamaized.voidscape.client.ClientInitiator;
import tamaized.voidscape.client.ConfigScreen;
import tamaized.voidscape.entity.IEthereal;
import tamaized.voidscape.network.DonatorHandler;
import tamaized.voidscape.network.NetworkMessages;
import tamaized.voidscape.registry.ModAdvancementTriggers;
import tamaized.voidscape.registry.ModArmors;
import tamaized.voidscape.registry.ModAttributes;
import tamaized.voidscape.registry.ModBiomes;
import tamaized.voidscape.registry.ModBlockEntities;
import tamaized.voidscape.registry.ModBlocks;
import tamaized.voidscape.registry.ModCreativeTabs;
import tamaized.voidscape.registry.ModDamageSource;
import tamaized.voidscape.registry.ModDataSerializers;
import tamaized.voidscape.registry.ModEffects;
import tamaized.voidscape.registry.ModEntities;
import tamaized.voidscape.registry.ModFeatures;
import tamaized.voidscape.registry.ModFluids;
import tamaized.voidscape.registry.ModItems;
import tamaized.voidscape.registry.ModNoiseGeneratorSettings;
import tamaized.voidscape.registry.ModPOIs;
import tamaized.voidscape.registry.ModParticles;
import tamaized.voidscape.registry.ModSounds;
import tamaized.voidscape.registry.ModStructures;
import tamaized.voidscape.registry.ModSurfaceRules;
import tamaized.voidscape.registry.ModTools;
import tamaized.voidscape.regutil.RegUtil;
import tamaized.voidscape.world.VoidChunkGenerator;
import tamaized.voidscape.world.VoidscapeLayeredBiomeProvider;

@Mod(value="voidscape")
public class Voidscape {
    public static final String MODID = "voidscape";
    public static final Logger LOGGER = LogManager.getLogger((String)"voidscape");
    public static final SimpleChannel NETWORK = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("voidscape", "voidscape")).clientAcceptedVersions(s -> true).serverAcceptedVersions(s -> true).networkProtocolVersion(() -> "1").simpleChannel();
    public static final SubCapability.ISubCap.SubCapKey<Insanity> subCapInsanity = SubCapability.AttachedSubCap.register(Insanity.class, Insanity::new);
    public static final SubCapability.ISubCap.SubCapKey<DonatorData> subCapDonatorData = SubCapability.AttachedSubCap.register(DonatorData.class, DonatorData::new);
    public static final ResourceKey<Level> WORLD_KEY_VOID = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("voidscape", "void"));

    public Voidscape() {
        DistExecutor.safeRunWhenOn((Dist)Dist.CLIENT, () -> ClientInitiator::call);
        DonatorHandler.start();
        IEventBus busMod = FMLJavaModLoadingContext.get().getModEventBus();
        IEventBus busForge = MinecraftForge.EVENT_BUS;
        ModLoadingContext.get().registerExtensionPoint(ConfigScreenHandler.ConfigScreenFactory.class, () -> new ConfigScreenHandler.ConfigScreenFactory(ConfigScreen::new));
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Config.Client::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)specPairClient.getRight());
        Config.CLIENT_CONFIG = (Config.Client)specPairClient.getLeft();
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Config.Common::new);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)specPairCommon.getRight());
        Config.COMMON_CONFIG = (Config.Common)specPairCommon.getLeft();
        RegUtil.setup(MODID, busMod, ModAdvancementTriggers::new, ModArmors::new, ModAttributes::new, ModBiomes::new, ModBlocks::new, ModBlockEntities::new, ModCreativeTabs::new, ModDamageSource::new, ModDataSerializers::new, ModEffects::new, ModEntities::new, ModFeatures::new, ModFluids::new, ModItems::new, ModNoiseGeneratorSettings::new, ModParticles::new, ModPOIs::new, ModSounds::new, ModStructures::new, ModSurfaceRules::new, ModTools::new);
        busMod.addListener(event -> {
            if (event.getPackType() == PackType.SERVER_DATA && ModList.get().isLoaded("aether")) {
                Path resourcePath = ModList.get().getModFileById(MODID).getFile().findResource(new String[]{"data", "minecraft", "datapacks", "voidscape_aether_compat"});
                Pack pack = Pack.m_245429_((String)"voidscape_aether_compat", (Component)Component.m_237113_((String)"Voidscape Aether Integration"), (boolean)true, name -> new PathPackResources(name, resourcePath, false), (PackType)PackType.SERVER_DATA, (Pack.Position)Pack.Position.TOP, (PackSource)PackSource.f_244201_);
                event.addRepositorySource(packConsumer -> packConsumer.accept(pack));
            }
        });
        busMod.addListener(event -> {
            if (!Objects.equals(event.getForgeRegistry(), ForgeRegistries.RECIPE_SERIALIZERS)) {
                return;
            }
            Registry.m_122965_((Registry)BuiltInRegistries.f_256737_, (ResourceLocation)new ResourceLocation(MODID, "biomeprovider"), VoidscapeLayeredBiomeProvider.CODEC);
            Registry.m_122965_((Registry)BuiltInRegistries.f_256914_, (ResourceLocation)new ResourceLocation(MODID, "void"), VoidChunkGenerator.codec);
        });
        SubCapability.init(busMod);
        busMod.addListener(event -> NetworkMessages.register(NETWORK));
        busForge.addListener(event -> event.getServer().m_129892_().m_82094_().register((LiteralArgumentBuilder)LiteralArgumentBuilder.literal((String)MODID).then(VoidCommands.Debug.register())));
        busForge.addListener(event -> {
            if (event.player.m_9236_() != null && !event.player.m_5833_() && Voidscape.checkForVoidDimension(event.player.m_9236_())) {
                BlockPos dest;
                Supplier<Integer> exec;
                int rad;
                int dist;
                if ((!event.player.m_9236_().m_5776_() || event.player.getCapability(SubCapability.CAPABILITY).map(cap -> cap.get(subCapInsanity).map(data -> data.getParanoia() / 600.0f > 0.25f).orElse(false)).orElse(false).booleanValue()) && event.player.f_19797_ % 30 == 0 && event.player.m_217043_().m_188501_() <= 0.2f) {
                    dist = 64;
                    rad = 32;
                    exec = () -> event.player.m_217043_().m_188503_(64) - 32;
                    dest = event.player.m_20183_().m_7918_(exec.get().intValue(), exec.get().intValue(), exec.get().intValue());
                    if (event.player.m_9236_().m_8055_(dest).equals(Blocks.f_50752_.m_49966_())) {
                        event.player.m_9236_().m_46597_(dest, ((Block)ModBlocks.VOIDIC_CRYSTAL_ORE.get()).m_49966_());
                    }
                }
                if (!event.player.m_9236_().m_5776_() && event.player.f_19797_ % 15 == 0 && event.player.m_217043_().m_188501_() <= 0.15f) {
                    dist = 64;
                    rad = 32;
                    exec = () -> event.player.m_217043_().m_188503_(64) - 32;
                    dest = event.player.m_20183_().m_7918_(exec.get().intValue(), exec.get().intValue(), exec.get().intValue());
                    if (event.player.m_9236_().m_8055_(dest).m_60795_() && ((Block)ModBlocks.ETHEREAL_FRUIT_VOID.get()).m_49966_().m_60710_((LevelReader)event.player.m_9236_(), dest)) {
                        Level level = event.player.m_9236_();
                        level.m_46597_(dest, switch (event.player.m_9236_().m_204166_(dest).m_203543_().map(ResourceKey::m_135782_).orElse(new ResourceLocation("")).m_135815_()) {
                            default -> ((Block)ModBlocks.ETHEREAL_FRUIT_VOID.get()).m_49966_();
                            case "null" -> ((Block)ModBlocks.ETHEREAL_FRUIT_NULL.get()).m_49966_();
                            case "overworld" -> ((Block)ModBlocks.ETHEREAL_FRUIT_OVERWORLD.get()).m_49966_();
                            case "nether" -> ((Block)ModBlocks.ETHEREAL_FRUIT_NETHER.get()).m_49966_();
                            case "end" -> ((Block)ModBlocks.ETHEREAL_FRUIT_END.get()).m_49966_();
                        });
                    }
                }
            }
        });
        busForge.addListener(event -> {
            if (event.getEntity().m_6084_() && event.getSource().m_276093_(ModDamageSource.VOIDIC)) {
                event.getEntity().f_19802_ = 0;
            }
        });
        busForge.addListener(event -> {
            Boolean arrow;
            if (!event.getSource().m_276093_(ModDamageSource.VOIDIC) && (arrow = Voidscape.meleeOrArrowSource(event.getSource())) != null) {
                Entity patt10720$temp;
                Entity e;
                if (event.getEntity().m_21223_() <= event.getAmount()) {
                    return;
                }
                Entity entity = e = event.getSource().m_269014_() ? event.getSource().m_7639_() : event.getSource().m_7640_();
                if (e instanceof LivingEntity) {
                    float dmg;
                    LivingEntity attacker = (LivingEntity)e;
                    if (!arrow.booleanValue() && (dmg = (float)(attacker.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey(ModAttributes.VOIDIC_DMG.get()) ? attacker.m_21133_((Attribute)ModAttributes.VOIDIC_DMG.get()) : 0.0) * (attacker instanceof Player ? ASMHooks.PlayerEntity_getAttackStrengthScale : 1.0f)) > 0.0f) {
                        event.getEntity().f_19802_ = 0;
                        event.getEntity().m_6469_(ModDamageSource.getEntityDamageSource(event.getEntity().m_9236_(), ModDamageSource.VOIDIC, (Entity)attacker), dmg);
                    }
                }
                if ((patt10720$temp = event.getSource().m_7640_()) instanceof AbstractArrow) {
                    AbstractArrow arrowEntity = (AbstractArrow)patt10720$temp;
                    arrowEntity.getCapability(SubCapability.CAPABILITY_VOIDICARROW).ifPresent(data -> {
                        float voidic = data.getDamage();
                        if (voidic > 0.0f) {
                            if (event.getEntity().m_21223_() <= event.getAmount()) {
                                return;
                            }
                            event.getEntity().f_19802_ = 0;
                            event.getEntity().m_6469_(ModDamageSource.getEntityDamageSource(arrowEntity.m_9236_(), ModDamageSource.VOIDIC, arrowEntity.m_19749_()), voidic);
                        }
                    });
                }
            } else if (event.getSource().m_276093_(ModDamageSource.VOIDIC)) {
                if (event.getEntity().m_21023_((MobEffect)ModEffects.ICHOR.get())) {
                    event.setAmount(event.getAmount() * 2.0f);
                }
                if (event.getEntity().m_21023_((MobEffect)ModEffects.FORTIFIED.get())) {
                    event.setAmount(event.getAmount() * 0.25f);
                    if (event.getEntity().m_217043_().m_188503_(4) == 0) {
                        event.getEntity().m_21195_((MobEffect)ModEffects.FORTIFIED.get());
                    }
                }
            }
        });
        busForge.addListener(event -> {
            AbstractArrow arrow;
            Entity entity;
            Entity patt11741$temp = event.getEntity();
            if (patt11741$temp instanceof AbstractArrow && (entity = (arrow = (AbstractArrow)patt11741$temp).m_19749_()) instanceof LivingEntity) {
                LivingEntity shooter = (LivingEntity)entity;
                if (shooter.m_21205_().m_41619_() || !shooter.m_21205_().m_41638_(EquipmentSlot.MAINHAND).containsKey(ModAttributes.VOIDIC_ARROW_DMG.get())) {
                    return;
                }
                float voidic = (float)shooter.m_21133_((Attribute)ModAttributes.VOIDIC_ARROW_DMG.get());
                if (voidic > 0.0f) {
                    arrow.getCapability(SubCapability.CAPABILITY_VOIDICARROW).ifPresent(data -> data.setDamage(voidic));
                }
            }
        });
        busForge.addListener(event -> {
            if (event.getSpawnType() == MobSpawnType.NATURAL && Voidscape.checkForVoidDimension((Level)event.getLevel().m_6018_()) && event.getLevel().m_7146_(event.getPos()) <= 7) {
                event.setResult(Event.Result.ALLOW);
            }
        });
        busForge.addListener(event -> {
            if (event.getSpawnType() == MobSpawnType.NATURAL && Voidscape.checkForVoidDimension((Level)event.getLevel().m_6018_())) {
                Player player = event.getLevel().m_45924_(event.getX(), event.getY(), event.getZ(), -1.0, false);
                if (player != null && Voidscape.isValidPositionForMob(event.getLevel().m_6018_(), event.getEntity(), player.m_20275_(event.getX(), event.getY(), event.getZ()), BlockPos.m_274561_((double)event.getX(), (double)event.getY(), (double)event.getZ()))) {
                    event.setResult(Event.Result.ALLOW);
                } else {
                    event.setResult(Event.Result.DENY);
                }
            }
        });
        busForge.addListener(event -> {
            if (event.getSpawnType() == MobSpawnType.NATURAL && !(event.getEntity() instanceof IEthereal) && Voidscape.checkForVoidDimension(event.getEntity().m_9236_())) {
                event.getEntity().getCapability(SubCapability.CAPABILITY).ifPresent(cap -> cap.get(subCapInsanity).ifPresent(data -> data.setInfusion(event.getEntity().m_217043_().m_188503_(200) + 100)));
            }
        });
    }

    private static boolean isValidPositionForMob(ServerLevel serverWorld_, Mob mobEntity_, double double_, BlockPos pos) {
        if (double_ > (double)(mobEntity_.m_6095_().m_20674_().m_21611_() * mobEntity_.m_6095_().m_20674_().m_21611_()) && mobEntity_.m_6785_(double_)) {
            return false;
        }
        return mobEntity_.m_6914_((LevelReader)serverWorld_) && (!(mobEntity_ instanceof Zoglin) || NaturalSpawner.canSpawnAtBody((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)serverWorld_, (BlockPos)pos, (EntityType)mobEntity_.m_6095_()));
    }

    @Nullable
    private static Boolean meleeOrArrowSource(DamageSource source) {
        if (source.m_276093_(DamageTypes.f_268464_) || source.m_276093_(DamageTypes.f_268566_)) {
            return false;
        }
        if (source.m_276093_(DamageTypes.f_268739_)) {
            return true;
        }
        return null;
    }

    public static boolean checkForVoidDimension(@Nullable Level level) {
        if (level == null) {
            return false;
        }
        return level.m_46472_().m_135782_().equals((Object)WORLD_KEY_VOID.m_135782_());
    }

    public static Optional<ServerLevel> getLevel(Level level, ResourceKey<Level> dest) {
        return Optional.ofNullable(Objects.requireNonNull(level.m_7654_()).m_129880_(dest));
    }

    public static Optional<ServerLevel> getPlayersSpawnLevel(ServerPlayer player) {
        return Voidscape.getLevel(player.m_9236_(), (ResourceKey<Level>)player.m_8963_());
    }

    public static HitResult getHitResultFromEyes(LivingEntity entity, Predicate<Entity> predicate, double range) {
        return Voidscape.getHitResultFromEyes(entity, predicate, range, 0.0, 0.0);
    }

    public static HitResult getHitResultFromEyes(LivingEntity entity, Predicate<Entity> predicate, double range, double inflateXZ, double inflateY) {
        EntityHitResult ray;
        Vec3 vector3d = entity.m_20299_(1.0f);
        Vec3 vector3d1 = entity.m_20252_(1.0f);
        Vec3 vector3d2 = vector3d.m_82520_(vector3d1.f_82479_ * range, vector3d1.f_82480_ * range, vector3d1.f_82481_ * range);
        AABB axisalignedbb = entity.m_20191_().m_82369_(vector3d1.m_82490_(range)).m_82377_(1.0, 1.0, 1.0);
        BlockHitResult raytraceresult = entity.m_9236_().m_45547_(new ClipContext(vector3d, vector3d2, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity));
        if (raytraceresult.m_6662_() != HitResult.Type.MISS) {
            vector3d2 = raytraceresult.m_82450_();
        }
        return (ray = Voidscape.getEntityHitResult((Entity)entity, vector3d, vector3d2, axisalignedbb, predicate, range * range, inflateXZ, inflateY)) == null ? raytraceresult : ray;
    }

    @Nullable
    private static EntityHitResult getEntityHitResult(Entity shooter, Vec3 startVec, Vec3 endVec, AABB boundingBox, Predicate<Entity> filter, double distance, double inflateXZ, double inflateY) {
        Level world = shooter.m_9236_();
        double d0 = distance;
        Entity entity = null;
        Vec3 vector3d = null;
        for (Entity entity1 : world.m_6249_(shooter, boundingBox, filter)) {
            Vec3 vector3d1;
            double d1;
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_()).m_82377_(inflateXZ, inflateY, inflateXZ);
            Optional optional = axisalignedbb.m_82371_(startVec, endVec);
            if (axisalignedbb.m_82390_(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.m_82557_(vector3d1 = (Vec3)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.m_20201_() == shooter.m_20201_() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityHitResult(entity, vector3d);
    }
}

