/*
 * Decompiled with CFR 0.152.
 */
package de.melanx.utilitix.network;

import de.melanx.utilitix.content.experiencecrystal.ScreenExperienceCrystal;
import de.melanx.utilitix.content.experiencecrystal.TileExperienceCrystal;
import de.melanx.utilitix.util.XPUtils;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.network.NetworkEvent;
import org.moddingx.libx.network.PacketHandler;
import org.moddingx.libx.network.PacketSerializer;

public record ClickScreenButton(BlockPos pos, ScreenExperienceCrystal.Button button) {
    private static void normalizeAddition(Player player, TileExperienceCrystal tile) {
        int transfer = (int)(player.f_36080_ * (float)player.m_36323_());
        int i = tile.addXp(transfer);
        player.m_6756_(-i);
    }

    private static void normalizeSubtraction(Player player, TileExperienceCrystal tile, int levels) {
        int newV = XPUtils.getExpPoints(player.f_36078_ + levels, 0.0f);
        int oldV = XPUtils.getExpPoints(player.f_36078_, player.f_36080_);
        int xp = newV - oldV;
        int i = tile.subtractXp(xp);
        player.m_6756_(i);
        if (Math.round(player.f_36080_) == 1) {
            i = tile.subtractXp(1);
            player.m_6756_(i);
        }
    }

    public static class Serializer
    implements PacketSerializer<ClickScreenButton> {
        public Class<ClickScreenButton> messageClass() {
            return ClickScreenButton.class;
        }

        public void encode(ClickScreenButton msg, FriendlyByteBuf buffer) {
            buffer.m_130064_(msg.pos);
            buffer.m_130068_((Enum)msg.button);
        }

        public ClickScreenButton decode(FriendlyByteBuf buffer) {
            return new ClickScreenButton(buffer.m_130135_(), (ScreenExperienceCrystal.Button)buffer.m_130066_(ScreenExperienceCrystal.Button.class));
        }
    }

    public static class Handler
    implements PacketHandler<ClickScreenButton> {
        public PacketHandler.Target target() {
            return PacketHandler.Target.MAIN_THREAD;
        }

        public boolean handle(ClickScreenButton msg, Supplier<NetworkEvent.Context> ctx) {
            ServerPlayer player = ctx.get().getSender();
            if (player == null) {
                return true;
            }
            ServerLevel level = (ServerLevel)player.m_9236_();
            ScreenExperienceCrystal.Button button = msg.button;
            BlockEntity be = level.m_7702_(msg.pos);
            if (be instanceof TileExperienceCrystal) {
                TileExperienceCrystal tile = (TileExperienceCrystal)be;
                int playerXP = XPUtils.getExpPoints(player.f_36078_, player.f_36080_);
                switch (button) {
                    case ADD_ONE: {
                        ClickScreenButton.normalizeAddition((Player)player, tile);
                        int xp = XPUtils.getXpBarCap(player.f_36078_ - 1);
                        int i = tile.addXp(xp);
                        player.m_6756_(-i);
                        break;
                    }
                    case ADD_TEN: {
                        int i;
                        ClickScreenButton.normalizeAddition((Player)player, tile);
                        int xp = 0;
                        for (i = 0; i < 10; ++i) {
                            xp += XPUtils.getXpBarCap(player.f_36078_ - 1 - i);
                        }
                        i = tile.addXp(xp);
                        player.m_6756_(-i);
                        break;
                    }
                    case ADD_ALL: {
                        int xp = tile.addXp(playerXP);
                        player.m_6756_(-xp);
                        break;
                    }
                    case SUB_ONE: {
                        ClickScreenButton.normalizeSubtraction((Player)player, tile, 1);
                        break;
                    }
                    case SUB_TEN: {
                        ClickScreenButton.normalizeSubtraction((Player)player, tile, 10);
                        break;
                    }
                    case SUB_ALL: {
                        int xp = tile.subtractXp(Integer.MAX_VALUE);
                        player.m_6756_(xp);
                    }
                }
            }
            return true;
        }
    }
}

