/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.compat.curios;

import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.capability.ITravelersBackpack;
import com.tiviacz.travelersbackpack.compat.curios.TravelersBackpackCurio;
import com.tiviacz.travelersbackpack.inventory.TravelersBackpackContainer;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class TravelersBackpackCurios {
    public static ICurio createBackpackProvider() {
        return new TravelersBackpackCurio(ItemStack.f_41583_);
    }

    public static Optional<ImmutableTriple<String, Integer, ItemStack>> getCurioTravelersBackpack(LivingEntity livingEntity) {
        Predicate<ItemStack> backpack = stack -> stack.m_41720_() instanceof TravelersBackpackItem;
        return CuriosApi.getCuriosHelper().findEquippedCurio(backpack, livingEntity);
    }

    public static ItemStack getCurioTravelersBackpackStack(Player player) {
        if (TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).isPresent()) {
            return (ItemStack)TravelersBackpackCurios.getCurioTravelersBackpack((LivingEntity)player).get().getRight();
        }
        return ItemStack.f_41583_;
    }

    public static TravelersBackpackContainer getCurioTravelersBackpackInventory(Player player) {
        TravelersBackpackContainer curioContainer = CapabilityUtils.getCapability(player).map(ITravelersBackpack::getContainer).orElse(null);
        if (curioContainer.getItemStack() != TravelersBackpackCurios.getCurioTravelersBackpackStack(player)) {
            curioContainer.setStack(TravelersBackpackCurios.getCurioTravelersBackpackStack(player));
            curioContainer.loadAllData(TravelersBackpackCurios.getCurioTravelersBackpackStack(player).m_41784_());
        }
        return curioContainer;
    }
}

