/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.common.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.tiviacz.travelersbackpack.items.TravelersBackpackItem;
import javax.annotation.Nullable;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;

public class ShapelessBackpackRecipe
extends ShapelessRecipe {
    public ShapelessBackpackRecipe(ResourceLocation idIn, String groupIn, CraftingBookCategory category, ItemStack recipeOutputIn, NonNullList<Ingredient> recipeItemsIn) {
        super(idIn, groupIn, category, recipeOutputIn, recipeItemsIn);
    }

    public ItemStack m_5874_(CraftingContainer inv, RegistryAccess registryAccess) {
        ItemStack output = super.m_5874_(inv, registryAccess);
        if (!output.m_41619_()) {
            for (int i = 0; i < inv.m_6643_(); ++i) {
                ItemStack ingredient = inv.m_8020_(i);
                if (ingredient.m_41619_() || !(ingredient.m_41720_() instanceof TravelersBackpackItem)) continue;
                CompoundTag compound = ingredient.m_41783_();
                output.m_41751_(compound);
                break;
            }
        }
        return output;
    }

    private ItemStack damageShears(ItemStack stack) {
        Player craftingPlayer = ForgeHooks.getCraftingPlayer();
        if (stack.m_220157_(1, craftingPlayer == null ? RandomSource.m_216327_() : craftingPlayer.m_9236_().f_46441_, craftingPlayer instanceof ServerPlayer ? (ServerPlayer)craftingPlayer : null)) {
            ForgeEventFactory.onPlayerDestroyItem((Player)craftingPlayer, (ItemStack)stack, null);
            return ItemStack.f_41583_;
        }
        return stack;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inventoryCrafting) {
        NonNullList remainingItems = NonNullList.m_122780_((int)inventoryCrafting.m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < remainingItems.size(); ++i) {
            ItemStack itemstack = inventoryCrafting.m_8020_(i);
            if (!itemstack.m_41619_() && itemstack.m_41720_() instanceof ShearsItem) {
                remainingItems.set(i, (Object)this.damageShears(itemstack.m_41777_()));
                continue;
            }
            remainingItems.set(i, (Object)ForgeHooks.getCraftingRemainingItem((ItemStack)itemstack));
        }
        return remainingItems;
    }

    public RecipeSerializer<?> m_7707_() {
        return Serializer.INSTANCE;
    }

    public RecipeType<?> m_6671_() {
        return RecipeType.f_44107_;
    }

    public static class Serializer
    implements RecipeSerializer<ShapelessBackpackRecipe> {
        public static final Serializer INSTANCE = new Serializer();

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)ingredientArray.get(i));
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public ShapelessBackpackRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String s = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)CraftingBookCategory.f_244644_.m_262792_(GsonHelper.m_13851_((JsonObject)json, (String)"category", (String)null), (Enum)CraftingBookCategory.MISC);
            NonNullList<Ingredient> nonnulllist = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            if (nonnulllist.isEmpty()) {
                throw new JsonParseException("No ingredients for shapeless recipe");
            }
            if (nonnulllist.size() > 9) {
                throw new JsonParseException("Too many ingredients for shapeless recipe the max is 9");
            }
            ItemStack itemstack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            return new ShapelessBackpackRecipe(recipeId, s, craftingbookcategory, itemstack, nonnulllist);
        }

        @Nullable
        public ShapelessBackpackRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String s = buffer.m_130136_(Short.MAX_VALUE);
            CraftingBookCategory craftingbookcategory = (CraftingBookCategory)buffer.m_130066_(CraftingBookCategory.class);
            int i = buffer.m_130242_();
            NonNullList nonnulllist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < nonnulllist.size(); ++j) {
                nonnulllist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack itemstack = buffer.m_130267_();
            return new ShapelessBackpackRecipe(recipeId, s, craftingbookcategory, itemstack, (NonNullList<Ingredient>)nonnulllist);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapelessBackpackRecipe recipe) {
            buffer.m_130070_(recipe.m_6076_());
            buffer.m_130068_((Enum)recipe.m_245232_());
            buffer.m_130130_(recipe.m_7527_().size());
            for (Ingredient ingredient : recipe.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.writeItemStack(recipe.f_44243_, false);
        }
    }
}

