/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.client.screens;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tiviacz.travelersbackpack.TravelersBackpack;
import com.tiviacz.travelersbackpack.capability.CapabilityUtils;
import com.tiviacz.travelersbackpack.client.screens.ScreenImageButton;
import com.tiviacz.travelersbackpack.client.screens.TankScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.ControlTab;
import com.tiviacz.travelersbackpack.client.screens.widgets.CraftingWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.MemoryWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SettingsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.SortWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.TankSlotWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.ToolSlotsWidget;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.common.BackpackAbilities;
import com.tiviacz.travelersbackpack.common.ServerActions;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.handlers.ModClientEventsHandler;
import com.tiviacz.travelersbackpack.inventory.ITravelersBackpackContainer;
import com.tiviacz.travelersbackpack.inventory.Tiers;
import com.tiviacz.travelersbackpack.inventory.menu.TravelersBackpackBaseMenu;
import com.tiviacz.travelersbackpack.inventory.menu.slot.ToolSlotItemHandler;
import com.tiviacz.travelersbackpack.network.ServerboundAbilitySliderPacket;
import com.tiviacz.travelersbackpack.network.ServerboundEquipBackpackPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSleepingBagPacket;
import com.tiviacz.travelersbackpack.network.ServerboundSpecialActionPacket;
import com.tiviacz.travelersbackpack.util.BackpackUtils;
import java.util.ArrayList;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.MenuAccess;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TravelersBackpackScreen
extends AbstractContainerScreen<TravelersBackpackBaseMenu>
implements MenuAccess<TravelersBackpackBaseMenu> {
    public static final ResourceLocation LEATHER_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/leather_travelers_backpack.png");
    public static final ResourceLocation IRON_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/iron_travelers_backpack.png");
    public static final ResourceLocation GOLD_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/gold_travelers_backpack.png");
    public static final ResourceLocation DIAMOND_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/diamond_travelers_backpack.png");
    public static final ResourceLocation NETHERITE_SCREEN_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/netherite_travelers_backpack.png");
    public static final ResourceLocation SETTINGS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_settings.png");
    public static final ResourceLocation EXTRAS_TRAVELERS_BACKPACK = new ResourceLocation("travelersbackpack", "textures/gui/travelers_backpack_extras.png");
    private final ScreenImageButton BED_BUTTON_BORDER;
    private final ScreenImageButton BED_BUTTON;
    private final ScreenImageButton EQUIP_BUTTON;
    private final ScreenImageButton UNEQUIP_BUTTON;
    private final ScreenImageButton ABILITY_SLIDER;
    public ControlTab controlTab;
    public ToolSlotsWidget toolSlotsWidget;
    public SettingsWidget settingsWidget;
    public SortWidget sortWidget;
    public MemoryWidget memoryWidget;
    public TankSlotWidget leftTankSlotWidget;
    public TankSlotWidget rightTankSlotWidget;
    public CraftingWidget craftingWidget;
    public final ITravelersBackpackContainer container;
    private final byte screenID;
    private final TankScreen tankLeft;
    private final TankScreen tankRight;

    public TravelersBackpackScreen(TravelersBackpackBaseMenu screenContainer, Inventory inventory, Component component) {
        super((AbstractContainerMenu)screenContainer, inventory, component);
        this.container = screenContainer.container;
        this.screenID = screenContainer.container.getScreenID();
        this.f_97735_ = 0;
        this.f_97736_ = 0;
        this.f_97726_ = 248;
        this.f_97727_ = screenContainer.container.getTier().getImageHeight();
        this.BED_BUTTON_BORDER = new ScreenImageButton(5, 42 + screenContainer.container.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.BED_BUTTON = new ScreenImageButton(6, 43 + screenContainer.container.getTier().getMenuSlotPlacementFactor(), 16, 16);
        this.EQUIP_BUTTON = new ScreenImageButton(5, 42 + screenContainer.container.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.UNEQUIP_BUTTON = new ScreenImageButton(5, 42 + screenContainer.container.getTier().getMenuSlotPlacementFactor(), 18, 18);
        this.ABILITY_SLIDER = new ScreenImageButton(5, screenContainer.container.getTier().getAbilitySliderRenderPos(), 18, 11);
        this.tankLeft = new TankScreen(this.container.getLeftTank(), 25, 7, this.container.getTier().getTankRenderPos(), 16);
        this.tankRight = new TankScreen(this.container.getRightTank(), 207, 7, this.container.getTier().getTankRenderPos(), 16);
    }

    public Font getFont() {
        return this.f_96547_;
    }

    protected void m_7856_() {
        super.m_7856_();
        this.initControlTab();
        this.initToolSlotsWidget();
        this.initSettingsTab();
        this.initTankSlotWidgets();
        this.initCraftingWidget();
    }

    public void initTankSlotWidgets() {
        if (this.container.getTier().getOrdinal() <= 1) {
            this.leftTankSlotWidget = new TankSlotWidget(this, this.f_97735_, this.f_97736_, 28, 60);
            this.m_7787_(this.leftTankSlotWidget);
            this.rightTankSlotWidget = new TankSlotWidget(this, this.f_97735_ + 220, this.f_97736_, 28, 60);
            this.m_7787_(this.rightTankSlotWidget);
        }
    }

    public void initControlTab() {
        this.controlTab = new ControlTab(this, this.f_97735_ + 61, this.f_97736_ - 10, 50, 13);
        this.m_7787_(this.controlTab);
    }

    public void initToolSlotsWidget() {
        this.toolSlotsWidget = new ToolSlotsWidget(this, this.f_97735_ + 5, this.f_97736_ - 15, 18, 15);
        this.m_7787_(this.toolSlotsWidget);
    }

    public void initSettingsTab() {
        this.settingsWidget = new SettingsWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 10, 15, 18);
        this.m_7787_(this.settingsWidget);
        this.sortWidget = new SortWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 29, 15, 18);
        this.m_7787_(this.sortWidget);
        this.memoryWidget = new MemoryWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 48, 15, 18);
        this.m_7787_(this.memoryWidget);
    }

    public void initCraftingWidget() {
        this.craftingWidget = new CraftingWidget(this, this.f_97735_ + this.f_97726_, this.f_97736_ + 29, 15, 18);
        this.m_7787_(this.craftingWidget);
    }

    protected void m_280003_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
    }

    public void m_88315_(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.m_280273_(guiGraphics);
        this.craftingWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        super.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (!this.container.getLeftTank().isEmpty()) {
            this.tankLeft.drawScreenFluidBar(this, guiGraphics);
        }
        if (!this.container.getRightTank().isEmpty()) {
            this.tankRight.drawScreenFluidBar(this, guiGraphics);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (this.container.hasBlockEntity()) {
            if (this.BED_BUTTON_BORDER.inButton(this, mouseX, mouseY)) {
                this.BED_BUTTON_BORDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 19, 0);
                this.BED_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, this.getBedIconX(this.container.getSleepingBagColor()), this.getBedIconY(this.container.getSleepingBagColor()));
            } else {
                this.BED_BUTTON_BORDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 0, 0);
                this.BED_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, this.getBedIconX(this.container.getSleepingBagColor()), this.getBedIconY(this.container.getSleepingBagColor()));
            }
            if (BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack()) && !this.container.getSettingsManager().showToolSlots()) {
                if (this.ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                    if (this.container.getAbilityValue()) {
                        this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 114, 0);
                    } else {
                        this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 114, 12);
                    }
                } else if (this.container.getAbilityValue()) {
                    this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 95, 0);
                } else {
                    this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 95, 12);
                }
            }
        } else {
            if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 1) {
                if (this.EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    this.EQUIP_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 57, 0);
                } else {
                    this.EQUIP_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 38, 0);
                }
            }
            if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2) {
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.container.getItemStack()) && !this.container.getSettingsManager().showToolSlots()) {
                    if (this.ABILITY_SLIDER.inButton(this, mouseX, mouseY)) {
                        if (this.container.getAbilityValue()) {
                            this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 114, 0);
                        } else {
                            this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 114, 12);
                        }
                    } else if (this.container.getAbilityValue()) {
                        this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 95, 0);
                    } else {
                        this.ABILITY_SLIDER.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 95, 12);
                    }
                }
                if (this.UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                    this.UNEQUIP_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 57, 19);
                } else {
                    this.UNEQUIP_BUTTON.draw(guiGraphics, this, EXTRAS_TRAVELERS_BACKPACK, 38, 19);
                }
            }
        }
        this.controlTab.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.toolSlotsWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        if (this.container.getTier().getOrdinal() <= 1) {
            this.leftTankSlotWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
            this.rightTankSlotWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        }
        this.settingsWidget.m_88315_(guiGraphics, mouseX, mouseY, partialTicks);
        this.m_6702_().stream().filter(w -> w instanceof WidgetBase).filter(w -> ((WidgetBase)w).isSettingsChild() && ((WidgetBase)w).isVisible()).forEach(w -> ((WidgetBase)w).m_88315_(guiGraphics, mouseX, mouseY, partialTicks));
        this.m_280072_(guiGraphics, mouseX, mouseY);
    }

    protected void m_280072_(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        super.m_280072_(guiGraphics, mouseX, mouseY);
        if (this.tankLeft.inTank(this, mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, this.tankLeft.getTankTooltip(), mouseX, mouseY);
        }
        if (this.tankRight.inTank(this, mouseX, mouseY)) {
            guiGraphics.m_280666_(this.f_96547_, this.tankRight.getTankTooltip(), mouseX, mouseY);
        }
        if (!(this.screenID != 3 && this.screenID != 2 || !BackpackAbilities.isOnList(this.screenID == 2 ? BackpackAbilities.ITEM_ABILITIES_LIST : BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack()) || !this.ABILITY_SLIDER.inButton(this, mouseX, mouseY) || this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) || this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget) || this.container.getSettingsManager().showToolSlots())) {
            if (this.container.getAbilityValue()) {
                ArrayList<FormattedCharSequence> list = new ArrayList<FormattedCharSequence>();
                list.add(Component.m_237115_((String)"screen.travelersbackpack.ability_enabled").m_7532_());
                if (BackpackAbilities.isOnList(BackpackAbilities.ITEM_TIMER_ABILITIES_LIST, this.container.getItemStack()) || BackpackAbilities.isOnList(BackpackAbilities.BLOCK_TIMER_ABILITIES_LIST, this.container.getItemStack())) {
                    list.add(this.container.getLastTime() == 0 ? Component.m_237115_((String)"screen.travelersbackpack.ability_ready").m_7532_() : Component.m_237115_((String)BackpackUtils.getConvertedTime(this.container.getLastTime())).m_7532_());
                }
                guiGraphics.m_280245_(this.f_96547_, list, mouseX, mouseY);
            } else if (!TravelersBackpackConfig.enableBackpackAbilities || !BackpackAbilities.ALLOWED_ABILITIES.contains(this.container.getItemStack().m_41720_())) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled_config"), mouseX, mouseY);
            } else {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.travelersbackpack.ability_disabled"), mouseX, mouseY);
            }
        }
        if (TravelersBackpack.enableCurios() && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget)) {
            if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2 && this.UNEQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.travelersbackpack.unequip_integration"), mouseX, mouseY);
            }
            if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 1 && this.EQUIP_BUTTON.inButton(this, mouseX, mouseY)) {
                guiGraphics.m_280557_(this.f_96547_, (Component)Component.m_237115_((String)"screen.travelersbackpack.equip_integration"), mouseX, mouseY);
            }
        }
        this.craftingWidget.renderTooltip(guiGraphics, mouseX, mouseY);
    }

    public boolean isWidgetVisible(Tiers.Tier tier, TankSlotWidget widget) {
        return this.container.getTier().getOrdinal() == tier.getOrdinal() && widget.isVisible();
    }

    protected void m_7286_(GuiGraphics guiGraphics, float partialTicks, int mouseX, int mouseY) {
        int i2;
        int x = (this.f_96543_ - this.f_97726_) / 2;
        int y = (this.f_96544_ - this.f_97727_) / 2;
        guiGraphics.m_280218_(this.getScreenTexture(this.container.getTier()), x, y, 0, 0, this.f_97726_, this.f_97727_);
        if (!this.container.getSettingsManager().renderOverlay() || TravelersBackpackConfig.disableCrafting) {
            for (i2 = 0; i2 < 3; ++i2) {
                for (int j = 0; j < 3; ++j) {
                    guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 151 + j * 18, this.getGuiTop() + (6 + this.container.getTier().getMenuSlotPlacementFactor()) + i2 * 18, 213, 0, 18, 18);
                }
            }
        }
        if (TravelersBackpackConfig.disableCrafting) {
            guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 205, this.getGuiTop() + this.container.getTier().getMenuSlotPlacementFactor() + 42, 213, 19, 38, 18);
        }
        if (this.container.getSettingsManager().showToolSlots()) {
            for (i2 = 0; i2 < this.container.getTier().getToolSlots(); ++i2) {
                boolean disabled = false;
                Slot slot = ((TravelersBackpackBaseMenu)this.f_97732_).m_38853_(this.container.getTier().getStorageSlotsWithCrafting() + i2 + 1);
                if (slot instanceof ToolSlotItemHandler) {
                    ToolSlotItemHandler toolSlot = (ToolSlotItemHandler)slot;
                    disabled = !toolSlot.canAccessPlace() || !toolSlot.canAccessPickup();
                }
                guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + 5, this.getGuiTop() + 6 + 18 * i2, 232, disabled ? 38 : 0, 18, 18);
            }
        }
        if (!this.container.getSlotManager().getUnsortableSlots().isEmpty() && !this.container.getSlotManager().isSelectorActive((byte)1)) {
            this.container.getSlotManager().getUnsortableSlots().forEach(i -> guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + this.getX((int)i), this.getGuiTop() + this.getY((int)i), 77, 20, 16, 16));
        }
        if (!this.container.getSlotManager().getMemorySlots().isEmpty()) {
            this.container.getSlotManager().getMemorySlots().forEach(pair -> {
                if (this.container.getSlotManager().isSelectorActive((byte)1)) {
                    guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()), 115, 24, 16, 16);
                    if (!((TravelersBackpackBaseMenu)this.f_97732_).m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41619_()) {
                        this.drawMemoryOverlay(guiGraphics, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
                    }
                }
                if (!((TravelersBackpackBaseMenu)this.f_97732_).m_38853_((Integer)pair.getFirst() + 1).m_7993_().m_41619_()) {
                    return;
                }
                ItemStack itemstack = (ItemStack)pair.getSecond();
                guiGraphics.m_280168_().m_85836_();
                RenderSystem.enableDepthTest();
                guiGraphics.m_280203_(itemstack, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
                guiGraphics.m_280168_().m_85849_();
                this.drawMemoryOverlay(guiGraphics, this.getGuiLeft() + this.getX((Integer)pair.getFirst()), this.getGuiTop() + this.getY((Integer)pair.getFirst()));
            });
        }
    }

    public void drawMemoryOverlay(GuiGraphics guiGraphics, int x, int y) {
        guiGraphics.m_280168_().m_85836_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        guiGraphics.m_280218_(EXTRAS_TRAVELERS_BACKPACK, x, y, 96, 24, 16, 16);
        guiGraphics.m_280168_().m_85849_();
    }

    public boolean m_6348_(double pMouseX, double pMouseY, int pButton) {
        int i = this.f_97735_;
        int j = this.f_97736_;
        boolean flag = this.m_7467_(pMouseX, pMouseY, i, j, pButton);
        if (flag && !((TravelersBackpackBaseMenu)this.f_97732_).m_142621_().m_41619_()) {
            for (GuiEventListener widget : this.m_6702_()) {
                WidgetBase base;
                if (!(widget instanceof WidgetBase) || !(base = (WidgetBase)widget).m_5953_(pMouseX, pMouseY)) continue;
                return false;
            }
        }
        return super.m_6348_(pMouseX, pMouseY, pButton);
    }

    protected void m_6597_(Slot slot, int slotId, int button, ClickType type) {
        super.m_6597_(slot, slotId, button, type);
        if (slotId >= 1 && slotId <= this.container.getTier().getStorageSlotsWithCrafting() && this.container.getSlotManager().isSelectorActive((byte)0)) {
            this.container.getSlotManager().setUnsortableSlot(slotId - 1);
        }
        if (slotId >= 1 && slotId <= this.container.getTier().getStorageSlotsWithCrafting() && this.container.getSlotManager().isSelectorActive((byte)1) && (!slot.m_7993_().m_41619_() || slot.m_7993_().m_41619_() && this.container.getSlotManager().isSlot((byte)1, slotId - 1))) {
            this.container.getSlotManager().setMemorySlot(slotId - 1, slot.m_7993_());
        }
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        if (this.container.getSlotManager().isSelectorActive((byte)0) && !this.sortWidget.m_5953_(mouseX, mouseY) || this.container.getSlotManager().isSelectorActive((byte)1) && !this.memoryWidget.m_5953_(mouseX, mouseY)) {
            return super.m_6375_(mouseX, mouseY, button);
        }
        if (!this.container.getLeftTank().isEmpty() && this.tankLeft.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 1.0));
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(1.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.m_58904_(), this.container.getScreenID());
            }
        }
        if (!this.container.getRightTank().isEmpty() && this.tankRight.inTank(this, (int)mouseX, (int)mouseY) && BackpackUtils.isShiftPressed()) {
            TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSpecialActionPacket(this.container.getScreenID(), 3, 2.0));
            if (this.container.getScreenID() == 1) {
                ServerActions.emptyTank(2.0, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, this.container.m_58904_(), this.container.getScreenID());
            }
        }
        if (this.container.hasBlockEntity()) {
            if (this.BED_BUTTON_BORDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundSleepingBagPacket(this.container.getPosition()));
                return true;
            }
            if (!this.container.getSettingsManager().showToolSlots() && BackpackAbilities.isOnList(BackpackAbilities.BLOCK_ABILITIES_LIST, this.container.getItemStack()) && this.ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && !this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundAbilitySliderPacket(this.screenID, !this.container.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        if (!this.container.hasBlockEntity()) {
            if (!TravelersBackpack.enableCurios()) {
                if (!CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 1 && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && this.EQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundEquipBackpackPacket(true));
                    return true;
                }
                if (CapabilityUtils.isWearingBackpack(((TravelersBackpackBaseMenu)this.m_6262_()).inventory.f_35978_) && this.screenID == 2 && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && this.UNEQUIP_BUTTON.inButton(this, (int)mouseX, (int)mouseY)) {
                    TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundEquipBackpackPacket(false));
                    return true;
                }
            }
            if (!this.container.getSettingsManager().showToolSlots() && BackpackAbilities.isOnList(BackpackAbilities.ITEM_ABILITIES_LIST, this.container.getItemStack()) && this.ABILITY_SLIDER.inButton(this, (int)mouseX, (int)mouseY) && !this.isWidgetVisible(Tiers.LEATHER, this.leftTankSlotWidget) && !this.isWidgetVisible(Tiers.IRON, this.leftTankSlotWidget)) {
                TravelersBackpack.NETWORK.sendToServer((Object)new ServerboundAbilitySliderPacket(this.screenID, !this.container.getAbilityValue()));
                this.playUIClickSound();
                return true;
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void playUIClickSound() {
        ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.m_9236_().m_5594_(((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_, ((TravelersBackpackBaseMenu)this.f_97732_).inventory.f_35978_.m_20183_(), (SoundEvent)SoundEvents.f_12490_.get(), SoundSource.MASTER, 0.25f, 1.0f);
    }

    public boolean m_7933_(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        if (ModClientEventsHandler.OPEN_INVENTORY.isActiveAndMatches(InputConstants.m_84827_((int)p_keyPressed_1_, (int)p_keyPressed_2_))) {
            LocalPlayer playerEntity = this.getMinecraft().f_91074_;
            if (playerEntity != null) {
                this.m_7379_();
            }
            return true;
        }
        return super.m_7933_(p_keyPressed_1_, p_keyPressed_2_, p_keyPressed_3_);
    }

    public ResourceLocation getScreenTexture(Tiers.Tier tier) {
        if (tier == Tiers.LEATHER) {
            return LEATHER_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.IRON) {
            return IRON_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.GOLD) {
            return GOLD_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.DIAMOND) {
            return DIAMOND_SCREEN_TRAVELERS_BACKPACK;
        }
        if (tier == Tiers.NETHERITE) {
            return NETHERITE_SCREEN_TRAVELERS_BACKPACK;
        }
        return LEATHER_SCREEN_TRAVELERS_BACKPACK;
    }

    public int getY(int slot) {
        if (this.container.getTier() == Tiers.LEATHER) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
        }
        if (this.container.getTier() == Tiers.IRON) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
        }
        if (this.container.getTier() == Tiers.GOLD) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
        }
        if (this.container.getTier() == Tiers.DIAMOND) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
            if (slot <= 53) {
                return 97;
            }
        }
        if (this.container.getTier() == Tiers.NETHERITE) {
            if (slot <= 8) {
                return 7;
            }
            if (slot <= 17) {
                return 25;
            }
            if (slot <= 26) {
                return 43;
            }
            if (slot <= 35) {
                return 61;
            }
            if (slot <= 44) {
                return 79;
            }
            if (slot <= 53) {
                return 97;
            }
            if (slot <= 62) {
                return 115;
            }
        }
        return 0;
    }

    public int getX(int slot) {
        if (this.container.getTier() == Tiers.LEATHER) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
        }
        if (this.container.getTier() == Tiers.IRON) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
        }
        if (this.container.getTier() == Tiers.GOLD) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
        }
        if (this.container.getTier() == Tiers.DIAMOND) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
            if (slot >= 45 && slot <= 53) {
                return 44 + 18 * (slot - 45);
            }
        }
        if (this.container.getTier() == Tiers.NETHERITE) {
            if (slot >= 0 && slot <= 8) {
                return 44 + 18 * slot;
            }
            if (slot >= 9 && slot <= 17) {
                return 44 + 18 * (slot - 9);
            }
            if (slot >= 18 && slot <= 26) {
                return 44 + 18 * (slot - 18);
            }
            if (slot >= 27 && slot <= 35) {
                return 44 + 18 * (slot - 27);
            }
            if (slot >= 36 && slot <= 44) {
                return 44 + 18 * (slot - 36);
            }
            if (slot >= 45 && slot <= 53) {
                return 44 + 18 * (slot - 45);
            }
            if (slot >= 54 && slot <= 62) {
                return 44 + 18 * (slot - 54);
            }
        }
        return 0;
    }

    public int getBedIconX(int colorId) {
        return 1 + (colorId <= 7 ? 0 : 19);
    }

    public int getBedIconY(int colorId) {
        return 19 + colorId % 8 * 17;
    }
}

