/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermal_extra;

import cofh.core.client.event.CoreClientEvents;
import java.util.concurrent.CompletableFuture;
import mrthomas20121.thermal_extra.client.screens.AdvancedItemFilterScreen;
import mrthomas20121.thermal_extra.client.screens.DynamoFrostScreen;
import mrthomas20121.thermal_extra.datagen.ExtraBlockstateGen;
import mrthomas20121.thermal_extra.datagen.ExtraLangGen;
import mrthomas20121.thermal_extra.datagen.ExtraModelGen;
import mrthomas20121.thermal_extra.datagen.ExtraRecipeGen;
import mrthomas20121.thermal_extra.datagen.ExtraTagGen;
import mrthomas20121.thermal_extra.filter.AdvancedFilter;
import mrthomas20121.thermal_extra.init.ThermalExtraBlockEntities;
import mrthomas20121.thermal_extra.init.ThermalExtraBlocks;
import mrthomas20121.thermal_extra.init.ThermalExtraContainers;
import mrthomas20121.thermal_extra.init.ThermalExtraCreativeTabs;
import mrthomas20121.thermal_extra.init.ThermalExtraFluids;
import mrthomas20121.thermal_extra.init.ThermalExtraItems;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeManagers;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeSerializers;
import mrthomas20121.thermal_extra.init.ThermalExtraRecipeTypes;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.world.inventory.MenuType;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="thermal_extra")
@Mod.EventBusSubscriber(modid="thermal_extra", bus=Mod.EventBusSubscriber.Bus.MOD)
public class ThermalExtra {
    public static final String MOD_ID = "thermal_extra";
    public static final Logger LOGGER = LogManager.getLogger();

    public ThermalExtra() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        ThermalExtraItems.ITEMS.register(bus);
        ThermalExtraBlocks.BLOCKS.register(bus);
        ThermalExtraFluids.FLUIDS.register(bus);
        ThermalExtraFluids.FLUID_TYPES.register(bus);
        ThermalExtraBlockEntities.BLOCK_ENTITIES.register(bus);
        ThermalExtraContainers.CONTAINERS.register(bus);
        ThermalExtraRecipeTypes.RECIPE_TYPES.register(bus);
        ThermalExtraRecipeSerializers.RECIPE_SERIALIZERS.register(bus);
        ThermalExtraCreativeTabs.CREATIVE_TABS.register(bus);
        AdvancedFilter.init();
        ThermalExtraRecipeManagers.register();
    }

    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator gen = event.getGenerator();
        ExistingFileHelper fileHelper = event.getExistingFileHelper();
        PackOutput packOutput = gen.getPackOutput();
        CompletableFuture lookupProvider = event.getLookupProvider();
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraRecipeGen(packOutput));
        ExtraTagGen.BlockTags blockTags = new ExtraTagGen.BlockTags(packOutput, lookupProvider, fileHelper);
        gen.addProvider(event.includeServer(), (DataProvider)blockTags);
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraTagGen.ItemTags(packOutput, lookupProvider, blockTags.m_274426_(), fileHelper));
        gen.addProvider(event.includeServer(), (DataProvider)new ExtraTagGen.FluidTags(packOutput, lookupProvider, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraModelGen(packOutput, fileHelper));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraLangGen(packOutput));
        gen.addProvider(event.includeClient(), (DataProvider)new ExtraBlockstateGen(packOutput, fileHelper));
    }

    @SubscribeEvent
    public static void clientEvents(FMLClientSetupEvent event) {
        event.enqueueWork(() -> CoreClientEvents.addNamespace((String)MOD_ID));
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.DYNAMO_FROST_CONTAINER.get()), DynamoFrostScreen::new);
            MenuScreens.m_96206_((MenuType)((MenuType)ThermalExtraContainers.ADVANCED_ITEM_FILTER_CONTAINER.get()), AdvancedItemFilterScreen::new);
        });
    }
}

