/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.registry;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.data.worldgen.placement.MiscOverworldPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.Music;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientAdditionsSettings;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraftforge.registries.RegistryObject;
import quek.undergarden.registry.UGConfiguredCarvers;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPlacedFeatures;
import quek.undergarden.registry.UGSoundEvents;

public class UGBiomes {
    public static final ResourceKey<Biome> ANCIENT_SEA = UGBiomes.create("ancient_sea");
    public static final ResourceKey<Biome> BARREN_ABYSS = UGBiomes.create("barren_abyss");
    public static final ResourceKey<Biome> BLOOD_MUSHROOM_BOG = UGBiomes.create("blood_mushroom_bog");
    public static final ResourceKey<Biome> DEAD_SEA = UGBiomes.create("dead_sea");
    public static final ResourceKey<Biome> DENSE_FOREST = UGBiomes.create("dense_forest");
    public static final ResourceKey<Biome> FORGOTTEN_FIELD = UGBiomes.create("forgotten_field");
    public static final ResourceKey<Biome> FROSTFIELDS = UGBiomes.create("frostfields");
    public static final ResourceKey<Biome> GRONGLEGROWTH = UGBiomes.create("gronglegrowth");
    public static final ResourceKey<Biome> ICY_SEA = UGBiomes.create("icy_sea");
    public static final ResourceKey<Biome> INDIGO_MUSHROOM_BOG = UGBiomes.create("indigo_mushroom_bog");
    public static final ResourceKey<Biome> INK_MUSHROOM_BOG = UGBiomes.create("ink_mushroom_bog");
    public static final ResourceKey<Biome> SMOGSTEM_FOREST = UGBiomes.create("smogstem_forest");
    public static final ResourceKey<Biome> SMOG_SPIRES = UGBiomes.create("smog_spires");
    public static final ResourceKey<Biome> VEIL_MUSHROOM_BOG = UGBiomes.create("veil_mushroom_bog");
    public static final ResourceKey<Biome> WIGGLEWOOD_FOREST = UGBiomes.create("wigglewood_forest");

    private static ResourceKey<Biome> create(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)new ResourceLocation("undergarden", name));
    }

    public static void bootstrap(BootstapContext<Biome> context) {
        HolderGetter featureGetter = context.m_255420_(Registries.f_256988_);
        HolderGetter carverGetter = context.m_255420_(Registries.f_257003_);
        context.m_255272_(ANCIENT_SEA, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLITTERKELP_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIB.get(), 10, 1, 1)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIBLING.get(), 5, 3, 6)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4477507), UGSoundEvents.SEA_AMBIENCE, UGSoundEvents.SEA_AMBIENT_ADDITION).m_48018_()).m_47592_());
        context.m_255272_(BARREN_ABYSS, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.2f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.ABYSS_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.118093334f)).m_48018_()).m_47592_());
        context.m_255272_(BLOOD_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_BLOOD_MUSHROOM).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1248522, 6180396), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.118093334f)).m_48018_()).m_47592_());
        context.m_255272_(DEAD_SEA, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.ABYSS_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).m_48018_()).m_47592_());
        context.m_255272_(DENSE_FOREST, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIGGLEWOOD_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SMOGSTEM_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_WIGGLEWOOD_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4224322), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.DENSE_FOREST_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.025f)).m_48018_()).m_47592_());
        context.m_255272_(FORGOTTEN_FIELD, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 0x5B755B), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.FIELDS_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.025f)).m_48018_()).m_47592_());
        context.m_255272_(FROSTFIELDS, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.ICE_PILLAR).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.ICE_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.FROSTSTEEL_ORE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.FROZEN_DEEPTURF_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.14f).m_47599_(Biome.TemperatureModifier.FROZEN).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 14609908), UGSoundEvents.FROST_MOOD, UGSoundEvents.FROST_AMBIENCE, UGSoundEvents.FROSTFIELDS_AMBIENT_ADDITION, 0.002775).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.118093334f)).m_48018_()).m_47592_());
        context.m_255272_(GRONGLEGROWTH, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.GRONGLEGROWTH_DELTA).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GRONGLE_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMALL_GRONGLE_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GRONGLE_BUSH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1186057, 4103962), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.GRONGLEGROWTH_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)UGParticleTypes.GRONGLE_SPORE.get(), 0.05f)).m_48018_()).m_47592_());
        context.m_255272_(ICY_SEA, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, MiscOverworldPlacements.f_195263_).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.ICE_PILLAR).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.ICE_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.FROSTSTEEL_ORE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLITTERKELP_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.FROZEN_DEEPTURF_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIB.get(), 10, 1, 1)).m_48376_(MobCategory.WATER_AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GWIBLING.get(), 5, 3, 6)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.14f).m_47599_(Biome.TemperatureModifier.FROZEN).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 14609908), UGSoundEvents.FROST_MOOD, UGSoundEvents.SEA_AMBIENCE, UGSoundEvents.FROSTFIELDS_AMBIENT_ADDITION, 0.002775).m_48018_()).m_47592_());
        context.m_255272_(INDIGO_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.TALL_DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INDIGO_MUSHROOM).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_BUSH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 8, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 2432083, 4212845), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.05f)).m_48018_()).m_47592_());
        context.m_255272_(INK_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INK_MUSHROOM).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x190919, 4075847), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.05f)).m_48018_()).m_47592_());
        context.m_255272_(SMOG_SPIRES, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SMOG_VENT).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.ASHEN_DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BLISTERBERRY_BUSH_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 8, 8)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(2.0f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 0x272727, 0x737C77), UGSoundEvents.SPIRES_AMBIENCE, UGSoundEvents.SPIRES_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.118093334f)).m_48018_()).m_47592_());
        context.m_255272_(SMOGSTEM_FOREST, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.DEPTHROCK_ROCK).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SMOGSTEM_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_INDIGO_MUSHROOM_SMOGSTEM_FOREST).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIDE_SMOGSTEM_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.AMOROUS_BRISTLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 595225, 5928296), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.SMOGSTEM_FOREST_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.025f)).m_48018_()).m_47592_());
        context.m_255272_(VEIL_MUSHROOM_BOG, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.SURFACE_STRUCTURES, UGPlacedFeatures.BOG_DELTA).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.HUGE_VEIL_MUSHROOM).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 8, 8)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1643784, 7696730), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.BOG_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.05f)).m_48018_()).m_47592_());
        context.m_255272_(WIGGLEWOOD_FOREST, (Object)new Biome.BiomeBuilder().m_47601_(UGBiomes.addOresAndCaves(UGBiomes.addShroomPatches(new BiomeGenerationSettings.Builder(featureGetter, carverGetter))).m_255155_(GenerationStep.Decoration.LOCAL_MODIFICATIONS, UGPlacedFeatures.SHIVERSTONE_ROCK).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEEPTURF_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.SHIMMERWEED_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DEPTHROCK_PEBBLE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.UNDERBEAN_BUSH_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DITCHBULB_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.DROOPVINE_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.GLOOMGOURD_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.WIGGLEWOOD_TREE).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.MISERABELL_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BUTTERBUNCH_PATCH).m_255380_()).m_47605_(UGBiomes.addRotspawn(UGBiomes.addCaveMobs(new MobSpawnSettings.Builder())).m_48368_(0.5f).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.STONEBORN.get(), 100, 1, 3)).m_48376_(MobCategory.AMBIENT, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SCINTLING.get(), 5, 4, 8)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.GLOOMPER.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.BRUTE.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MOG.get(), 100, 4, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.DWELLER.get(), 100, 4, 4)).m_48381_()).m_264558_(false).m_47611_(0.0f).m_47609_(0.8f).m_47603_(UGBiomes.addMusicAndAmbience(UGBiomes.generateColors(new BiomeSpecialEffects.Builder(), 1643784, 7304538), UGSoundEvents.UNDERGARDEN_AMBIENCE, UGSoundEvents.WIGGLEWOOD_FOREST_AMBIENT_ADDITION).m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.025f)).m_48018_()).m_47592_());
    }

    private static BiomeGenerationSettings.Builder addOresAndCaves(BiomeGenerationSettings.Builder builder) {
        return builder.m_255308_(GenerationStep.Carving.AIR, UGConfiguredCarvers.UNDERGARDEN_CAVE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.DEEPSOIL_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.SEDIMENT_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.SHIVERSTONE_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.COAL_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.IRON_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.GOLD_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.DIAMOND_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.CLOGGRUM_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.UTHERIUM_ORE).m_255155_(GenerationStep.Decoration.UNDERGROUND_ORES, UGPlacedFeatures.REGALIUM_ORE);
    }

    private static BiomeGenerationSettings.Builder addShroomPatches(BiomeGenerationSettings.Builder builder) {
        return builder.m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.BLOOD_MUSHROOM_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.INDIGO_MUSHROOM_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.INK_MUSHROOM_PATCH).m_255155_(GenerationStep.Decoration.VEGETAL_DECORATION, UGPlacedFeatures.VEIL_MUSHROOM_PATCH);
    }

    private static MobSpawnSettings.Builder addCaveMobs(MobSpawnSettings.Builder builder) {
        return builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.NARGOYLE.get(), 50, 1, 1)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.MUNCHER.get(), 50, 1, 1)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.SPLOOGIE.get(), 50, 1, 1));
    }

    private static MobSpawnSettings.Builder addRotspawn(MobSpawnSettings.Builder builder) {
        return builder.m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTLING.get(), 100, 2, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTWALKER.get(), 100, 4, 4)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData((EntityType)UGEntityTypes.ROTBEAST.get(), 100, 1, 2));
    }

    private static BiomeSpecialEffects.Builder addMusicAndAmbience(BiomeSpecialEffects.Builder builder, RegistryObject<SoundEvent> ambient, RegistryObject<SoundEvent> addition) {
        return UGBiomes.addMusicAndAmbience(builder, UGSoundEvents.MOOD, ambient, addition, 0.00555);
    }

    private static BiomeSpecialEffects.Builder addMusicAndAmbience(BiomeSpecialEffects.Builder builder, RegistryObject<SoundEvent> mood, RegistryObject<SoundEvent> ambient, RegistryObject<SoundEvent> addition, double additionInterval) {
        return builder.m_48025_(new AmbientAdditionsSettings((Holder)addition.getHolder().get(), additionInterval)).m_48027_(new AmbientMoodSettings((Holder)mood.getHolder().get(), 6000, 8, 2.0)).m_48023_((Holder)ambient.getHolder().get()).m_48021_(new Music((Holder)UGSoundEvents.UNDERGARDEN_MUSIC.getHolder().get(), 12000, 24000, true));
    }

    private static BiomeSpecialEffects.Builder generateColors(BiomeSpecialEffects.Builder builder, int skyFog, int grass) {
        return builder.m_48040_(1186057).m_48019_(skyFog).m_48034_(342306).m_48037_(332810).m_48045_(grass).m_48043_(grass);
    }

    public static BiomeSource buildBiomeSource(HolderGetter<Biome> biomes) {
        return MultiNoiseBiomeSource.m_274596_((Climate.ParameterList)new Climate.ParameterList((List)ImmutableList.of((Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(FORGOTTEN_FIELD)), (Object)Pair.of((Object)Climate.m_186788_((float)-1.0f, (float)-0.4f, (float)-0.9f, (float)-0.7f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(FROSTFIELDS)), (Object)Pair.of((Object)Climate.m_186788_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(SMOGSTEM_FOREST)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)-0.4f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(WIGGLEWOOD_FOREST)), (Object)Pair.of((Object)Climate.m_186788_((float)1.0f, (float)0.4f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(DENSE_FOREST)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.9f, (float)0.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(GRONGLEGROWTH)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(BARREN_ABYSS)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)-2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(SMOG_SPIRES)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0f), (Object)biomes.m_255043_(INK_MUSHROOM_BOG)), (Object)Pair.of((Object)Climate.m_186788_((float)1.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)1.0f, (float)0.0f), (Object)biomes.m_255043_(INDIGO_MUSHROOM_BOG)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-2.0f, (float)-1.0f, (float)0.0f), (Object)biomes.m_255043_(VEIL_MUSHROOM_BOG)), (Object)Pair.of((Object)Climate.m_186788_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7f, (float)-2.0f, (float)-1.0f, (float)0.0f), (Object)biomes.m_255043_(BLOOD_MUSHROOM_BOG)), (Object[])new Pair[]{Pair.of((Object)Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186822_((float)0.0f, (float)1.0f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.0f, (float)0.4f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.0f, (float)0.9f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186820_((float)2.0f), (Climate.Parameter)Climate.Parameter.m_186822_((float)-1.0f, (float)1.0f), (float)0.0f), (Object)biomes.m_255043_(ANCIENT_SEA)), Pair.of((Object)Climate.m_186798_((Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (Climate.Parameter)Climate.Parameter.m_186822_((float)0.7f, (float)1.0f), (Climate.Parameter)Climate.Parameter.m_186820_((float)2.0f), (Climate.Parameter)Climate.Parameter.m_186820_((float)0.0f), (float)0.0f), (Object)biomes.m_255043_(DEAD_SEA)), Pair.of((Object)Climate.m_186788_((float)-0.7f, (float)-0.7f, (float)-0.7f, (float)0.0f, (float)2.0f, (float)0.0f, (float)0.0f), (Object)biomes.m_255043_(ICY_SEA))})));
    }
}

