/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.network.NetworkHooks;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGBoat
extends Boat {
    private static final EntityDataAccessor<Integer> BOAT_TYPE = SynchedEntityData.m_135353_(UGBoat.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public UGBoat(EntityType<? extends Boat> type, Level level) {
        super(type, level);
        this.f_19850_ = true;
    }

    public UGBoat(Level level, double x, double y, double z) {
        this((EntityType<? extends Boat>)((EntityType)UGEntityTypes.BOAT.get()), level);
        this.m_6034_(x, y, z);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
    }

    public Type getUGBoatType() {
        return Type.byId((Integer)this.m_20088_().m_135370_(BOAT_TYPE));
    }

    public Item m_38369_() {
        return switch (this.getUGBoatType()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.SMOGSTEM -> (Item)UGItems.SMOGSTEM_BOAT.get();
            case Type.WIGGLEWOOD -> (Item)UGItems.WIGGLEWOOD_BOAT.get();
            case Type.GRONGLE -> (Item)UGItems.GRONGLE_BOAT.get();
        };
    }

    public void setUGBoatType(Type boatType) {
        this.m_20088_().m_135381_(BOAT_TYPE, (Object)boatType.ordinal());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(BOAT_TYPE, (Object)Type.SMOGSTEM.ordinal());
    }

    protected void m_7380_(CompoundTag compound) {
        compound.m_128359_("Type", this.getUGBoatType().getName());
    }

    protected void m_7378_(CompoundTag compound) {
        if (compound.m_128425_("Type", 8)) {
            this.setUGBoatType(Type.getTypeFromString(compound.m_128461_("Type")));
        }
    }

    public Packet<ClientGamePacketListener> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public static enum Type {
        SMOGSTEM((Block)UGBlocks.SMOGSTEM_PLANKS.get(), "smogstem"),
        WIGGLEWOOD((Block)UGBlocks.WIGGLEWOOD_PLANKS.get(), "wigglewood"),
        GRONGLE((Block)UGBlocks.GRONGLE_PLANKS.get(), "grongle");

        private final String name;
        private final Block block;

        private Type(Block block, String name) {
            this.name = name;
            this.block = block;
        }

        public String getName() {
            return this.name;
        }

        public Block asPlank() {
            return this.block;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int id) {
            Type[] aUGBoatEntity$type = Type.values();
            if (id < 0 || id >= aUGBoatEntity$type.length) {
                id = 0;
            }
            return aUGBoatEntity$type[id];
        }

        public static Type getTypeFromString(String nameIn) {
            Type[] boatTypeArray;
            for (Type type : boatTypeArray = Type.values()) {
                if (!type.getName().equals(nameIn)) continue;
                return type;
            }
            return boatTypeArray[0];
        }
    }
}

