/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.data;

import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.data.loot.EntityLootSubProvider;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.loot.LootTableSubProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.ApplyExplosionDecay;
import net.minecraft.world.level.storage.loot.functions.EnchantRandomlyFunction;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LimitCount;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootingEnchantFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.functions.SmeltItemFunction;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.predicates.BonusLevelTableCondition;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LocationCheck;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemEntityPropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemKilledByPlayerCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.predicates.MatchTool;
import net.minecraft.world.level.storage.loot.providers.number.BinomialDistributionGenerator;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import quek.undergarden.block.BlisterberryBushBlock;
import quek.undergarden.block.DepthrockPebblesBlock;
import quek.undergarden.block.DitchbulbBlock;
import quek.undergarden.block.Droopvine;
import quek.undergarden.block.UnderbeanBushBlock;
import quek.undergarden.data.provider.UGBlockLootTableProvider;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;

public class UGLootTables
extends LootTableProvider {
    private static final LootItemCondition.Builder SHEARS = MatchTool.m_81997_((ItemPredicate.Builder)ItemPredicate.Builder.m_45068_().m_151445_(new ItemLike[]{Items.f_42574_}));
    private static final Set<Item> IMMUNE_TO_EXPLOSIONS = (Set)Stream.of(net.minecraft.world.level.block.Blocks.f_50260_, net.minecraft.world.level.block.Blocks.f_50273_, net.minecraft.world.level.block.Blocks.f_50569_, net.minecraft.world.level.block.Blocks.f_50310_, net.minecraft.world.level.block.Blocks.f_50312_, net.minecraft.world.level.block.Blocks.f_50316_, net.minecraft.world.level.block.Blocks.f_50314_, net.minecraft.world.level.block.Blocks.f_50318_, net.minecraft.world.level.block.Blocks.f_50320_, net.minecraft.world.level.block.Blocks.f_50456_, net.minecraft.world.level.block.Blocks.f_50525_, net.minecraft.world.level.block.Blocks.f_50521_, net.minecraft.world.level.block.Blocks.f_50522_, net.minecraft.world.level.block.Blocks.f_50466_, net.minecraft.world.level.block.Blocks.f_50464_, net.minecraft.world.level.block.Blocks.f_50523_, net.minecraft.world.level.block.Blocks.f_50460_, net.minecraft.world.level.block.Blocks.f_50465_, net.minecraft.world.level.block.Blocks.f_50462_, net.minecraft.world.level.block.Blocks.f_50459_, net.minecraft.world.level.block.Blocks.f_50458_, net.minecraft.world.level.block.Blocks.f_50463_, net.minecraft.world.level.block.Blocks.f_50520_, net.minecraft.world.level.block.Blocks.f_50524_, net.minecraft.world.level.block.Blocks.f_50457_, net.minecraft.world.level.block.Blocks.f_50461_).map(ItemLike::m_5456_).collect(ImmutableSet.toImmutableSet());
    private static final float[] DEFAULT_SAPLING_DROP_RATES = new float[]{0.05f, 0.0625f, 0.083333336f, 0.1f};

    public UGLootTables(PackOutput output) {
        super(output, Set.of(), List.of(new LootTableProvider.SubProviderEntry(Blocks::new, LootContextParamSets.f_81421_), new LootTableProvider.SubProviderEntry(Chests::new, LootContextParamSets.f_81411_), new LootTableProvider.SubProviderEntry(Entities::new, LootContextParamSets.f_81415_)));
    }

    protected void validate(Map<ResourceLocation, LootTable> map, ValidationContext validationtracker) {
    }

    private static LootTable.Builder droopvine(Block block) {
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DROOPFRUIT.get()))).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67703_((Property)Droopvine.GLOWY, true))));
    }

    private static LootTable.Builder tallGrassDrop(Block originalBlock, Block newBlock) {
        LootPoolEntryContainer.Builder builder = LootItem.m_79579_((ItemLike)newBlock).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79080_(SHEARS);
        return LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79076_(builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)originalBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{originalBlock}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, 1, 0)))).m_79161_(LootPool.m_79043_().m_79076_(builder).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)originalBlock).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.UPPER))).m_79080_(LocationCheck.m_81727_((LocationPredicate.Builder)LocationPredicate.Builder.m_52651_().m_52652_(BlockPredicate.Builder.m_17924_().m_146726_(new Block[]{originalBlock}).m_17929_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)DoublePlantBlock.f_52858_, (Comparable)DoubleBlockHalf.LOWER).m_67706_()).m_17931_()), (BlockPos)new BlockPos(0, -1, 0))));
    }

    private static LootTable.Builder dropSeedsForStem(Block stem, Item stemSeed) {
        return LootTable.m_79147_().m_79161_((LootPool.Builder)UGLootTables.withExplosionDecay((ItemLike)stem, LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)stemSeed).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)BinomialDistributionGenerator.m_165659_((int)3, (float)0.53333336f))))));
    }

    protected static <T extends FunctionUserBuilder<T>> T withExplosionDecay(ItemLike item, FunctionUserBuilder<T> function) {
        return (T)(!IMMUNE_TO_EXPLOSIONS.contains(item.m_5456_()) ? function.m_79078_((LootItemFunction.Builder)ApplyExplosionDecay.m_80037_()) : function.m_79073_());
    }

    public static class Chests
    implements LootTableSubProvider {
        public void m_245126_(BiConsumer<ResourceLocation, LootTable.Builder> consumer) {
            consumer.accept(new ResourceLocation("undergarden", "chests/catacombs"), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)8.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.MAMMOTH_DISC.get())).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.RELICT_DISC.get())).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.FORGOTTEN_UPGRADE_TEMPLATE.get())).m_79707_(5)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).m_79707_(1)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.GLOOMGOURD_PIE.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.REGALIUM_CRYSTAL.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.GLOOMGOURD_PIE.get())).m_79707_(40).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)8.0f))).m_79707_(40)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_SWORD.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_165191_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_PICKAXE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_165191_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_AXE.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_165191_())).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_SHOVEL.get())).m_79707_(10).m_79078_((LootItemFunction.Builder)EnchantRandomlyFunction.m_165191_()))));
        }
    }

    public static class Entities
    extends EntityLootSubProvider {
        public Entities() {
            super(FeatureFlags.f_244280_.m_247355_());
        }

        public void m_246942_() {
            this.m_245309_((EntityType)UGEntityTypes.ROTLING.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()))));
            this.m_245309_((EntityType)UGEntityTypes.ROTWALKER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()))));
            this.m_245309_((EntityType)UGEntityTypes.ROTBEAST.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_(LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UTHERIC_SHARD.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)8.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79080_(LootItemKilledByPlayerCondition.m_81901_()))));
            this.m_245309_((EntityType)UGEntityTypes.DWELLER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.RAW_DWELLER_MEAT.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.GWIBLING.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.RAW_GWIBLING.get())).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_)))).m_79080_(LootItemKilledByPlayerCondition.m_81901_())).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42499_)).m_79080_(LootItemRandomChanceCondition.m_81927_((float)0.05f))));
            this.m_245309_((EntityType)UGEntityTypes.BRUTE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.BRUTE_TUSK.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.SCINTLING.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.GOO_BALL.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.GLOOMPER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)Items.f_42454_).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.RAW_GLOOMPER_LEG.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)SmeltItemFunction.m_81271_().m_79080_(LootItemEntityPropertyCondition.m_81864_((LootContext.EntityTarget)LootContext.EntityTarget.THIS, (EntityPredicate.Builder)f_244460_))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.STONEBORN.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.NARGOYLE.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)UGEntityTypes.MUNCHER.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)3.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.CLOGGRUM_NUGGET.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.FROSTSTEEL_NUGGET.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)3.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.SPLOOGIE.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.GWIB.get(), LootTable.m_79147_());
            this.m_245309_((EntityType)UGEntityTypes.MOG.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)3.0f, (float)6.0f))).m_79078_((LootItemFunction.Builder)LootingEnchantFunction.m_165229_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.MOGMOSS.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))))));
            this.m_245309_((EntityType)UGEntityTypes.FORGOTTEN_GUARDIAN.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.FORGOTTEN_NUGGET.get())).m_79080_(LootItemKilledByPlayerCondition.m_81901_())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)4.0f, (float)16.0f))))));
        }

        protected Stream<EntityType<?>> getKnownEntityTypes() {
            return UGEntityTypes.ENTITIES.getEntries().stream().map(Supplier::get);
        }
    }

    public static class Blocks
    extends UGBlockLootTableProvider {
        protected void m_245660_() {
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEEPSOIL);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPSOIL_FARMLAND, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.m_247577_((Block)UGBlocks.UNDERBEAN_BUSH.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)UnderbeanBushBlock.AGE, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.UNDERBEAN_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)UnderbeanBushBlock.AGE, 2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.UNDERBEANS.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))));
            this.m_247577_((Block)UGBlocks.BLISTERBERRY_BUSH.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlisterberryBushBlock.AGE, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)3.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlisterberryBushBlock.AGE, 2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlisterberryBushBlock.AGE, 3))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))).m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.BLISTERBERRY_BUSH.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)BlisterberryBushBlock.AGE, 2))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)0.0f, (float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))));
            this.m_247577_((Block)UGBlocks.DITCHBULB_PLANT.get(), LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)((Block)UGBlocks.DITCHBULB_PLANT.get())).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)DitchbulbBlock.AGE, 1))).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DITCHBULB.get()))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f))).m_79078_((LootItemFunction.Builder)ApplyBonusCount.m_79939_((Enchantment)Enchantments.f_44987_))));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.m_246481_((Block)UGBlocks.TALL_DEEPTURF.get(), block -> UGLootTables.tallGrassDrop(block, (Block)UGBlocks.DEEPTURF.get()));
            this.m_246481_((Block)UGBlocks.TALL_SHIMMERWEED.get(), block -> UGLootTables.tallGrassDrop(block, (Block)UGBlocks.SHIMMERWEED.get()));
            this.m_246481_((Block)UGBlocks.DEEPTURF.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)UGBlocks.SHIMMERWEED.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)UGBlocks.ASHEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SAPLING);
            this.m_246481_((Block)UGBlocks.SMOGSTEM_LEAVES.get(), leaves -> this.m_246047_((Block)leaves, (Block)UGBlocks.SMOGSTEM_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SAPLING);
            this.m_246481_((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), leaves -> Blocks.m_246160_((Block)leaves, (LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)this.m_247733_((ItemLike)leaves, (ConditionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get())))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])DEFAULT_SAPLING_DROP_RATES))).m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_(f_244248_).m_79076_(((LootPoolSingletonContainer.Builder)this.m_246108_((ItemLike)leaves, (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.TWISTYTWIG.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)2.0f))))).m_79080_(BonusLevelTableCondition.m_81517_((Enchantment)Enchantments.f_44987_, (float[])new float[]{0.02f, 0.022222223f, 0.025f, 0.033333335f, 0.1f})))));
            this.m_246481_((Block)UGBlocks.GRONGLE_LEAVES.get(), leaves -> this.m_246047_((Block)leaves, (Block)UGBlocks.GRONGLE_SAPLING.get(), DEFAULT_SAPLING_DROP_RATES));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CARVED_GLOOMGOURD);
            this.m_246481_((Block)UGBlocks.DEPTHROCK_PEBBLES.get(), pebble -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)UGBlocks.DEPTHROCK_PEBBLES.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pebble).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)DepthrockPebblesBlock.PEBBLES, 1)))).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)ConstantValue.m_165692_((float)2.0f)).m_79080_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)pebble).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67694_((Property)DepthrockPebblesBlock.PEBBLES, 2))))))));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GLOOM_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_O_LANTERN);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.DEPTHROCK_BRICK_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SMOGSTEM_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.WIGGLEWOOD_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.UTHERIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_BARS);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP, (ItemLike)UGItems.GLITTERKELP.get());
            this.dropOther((Supplier<? extends Block>)UGBlocks.GLITTERKELP_PLANT, (ItemLike)UGItems.GLITTERKELP.get());
            this.m_246481_((Block)UGBlocks.SMOGSTEM_DOOR.get(), block -> this.m_245178_((Block)block, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
            this.m_246481_((Block)UGBlocks.WIGGLEWOOD_DOOR.get(), block -> this.m_245178_((Block)block, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_TRAPDOOR);
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.SMOG_VENT, (Supplier<? extends ItemLike>)UGBlocks.DEPTHROCK);
            this.m_246481_((Block)UGBlocks.GOO.get(), goo -> this.m_245142_((Block)goo, (ItemLike)UGItems.GOO_BALL.get(), (NumberProvider)UniformGenerator.m_165780_((float)1.0f, (float)4.0f)));
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.ASHEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICKS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.SHIVERSTONE_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BRICK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.REGALIUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHARD_TORCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SHARD_WALL_TORCH, (ItemLike)UGBlocks.SHARD_TORCH.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_FENCE_GATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.COARSE_DEEPSOIL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SAPLING);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PLANKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.GRONGLE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_FENCE_GATE);
            this.m_246481_((Block)UGBlocks.GRONGLE_DOOR.get(), block -> this.m_245178_((Block)block, (Property)DoorBlock.f_52730_, (Comparable)DoubleBlockHalf.LOWER));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_TRAPDOOR);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_LOG);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_SMOGSTEM_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.STRIPPED_GRONGLE_WOOD);
            this.m_246481_((Block)UGBlocks.GLOOMGOURD_STEM.get(), stem -> this.m_247642_((Block)stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.m_246481_((Block)UGBlocks.GLOOMGOURD_STEM_ATTACHED.get(), stem -> UGLootTables.dropSeedsForStem(stem, (Item)UGItems.GLOOMGOURD_SEEDS.get()));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CRACKED_SHIVERSTONE_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_WALL);
            this.m_246481_((Block)UGBlocks.BLOOD_MUSHROOM_CAP.get(), mushroom -> this.m_245079_((Block)mushroom, (ItemLike)UGBlocks.BLOOD_MUSHROOM.get()));
            this.m_246481_((Block)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), block -> LootTable.m_79147_().m_79161_(LootPool.m_79043_().m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)((LootPoolSingletonContainer.Builder)LootItem.m_79579_((ItemLike)((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get())).m_79080_(f_243678_)).m_7170_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)UGItems.BLOOD_GLOBULE.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)2.0f, (float)6.0f))))).m_142719_((LootPoolEntryContainer.Builder)this.m_246108_((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get(), (FunctionUserBuilder)LootItem.m_79579_((ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM.get())).m_79078_((LootItemFunction.Builder)SetItemCountFunction.m_165412_((NumberProvider)UniformGenerator.m_165780_((float)-6.0f, (float)2.0f))).m_79078_((LootItemFunction.Builder)LimitCount.m_165215_((IntRange)IntRange.m_165026_((int)0))))))));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.BLOOD_MUSHROOM_STEM);
            this.m_246481_((Block)UGBlocks.INDIGO_MUSHROOM_CAP.get(), mushroom -> this.m_245079_((Block)mushroom, (ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INDIGO_MUSHROOM_STEM);
            this.m_246481_((Block)UGBlocks.VEIL_MUSHROOM_CAP.get(), mushroom -> this.m_245079_((Block)mushroom, (ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.VEIL_MUSHROOM_STEM);
            this.m_246481_((Block)UGBlocks.INK_MUSHROOM_CAP.get(), mushroom -> this.m_245079_((Block)mushroom, (ItemLike)UGBlocks.INK_MUSHROOM.get()));
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.INK_MUSHROOM_STEM);
            this.m_246481_((Block)UGBlocks.SEEPING_INK.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.FORGOTTEN_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_DEPTHROCK_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_SHIVERSTONE_BRICKS);
            this.m_246535_((Block)UGBlocks.POTTED_SMOGSTEM_SAPLING.get());
            this.m_246535_((Block)UGBlocks.POTTED_WIGGLEWOOD_SAPLING.get());
            this.m_246535_((Block)UGBlocks.POTTED_SHIMMERWEED.get());
            this.m_246535_((Block)UGBlocks.POTTED_INDIGO_MUSHROOM.get());
            this.m_246535_((Block)UGBlocks.POTTED_VEIL_MUSHROOM.get());
            this.m_246535_((Block)UGBlocks.POTTED_INK_MUSHROOM.get());
            this.m_246535_((Block)UGBlocks.POTTED_BLOOD_MUSHROOM.get());
            this.m_246535_((Block)UGBlocks.POTTED_GRONGLE_SAPLING.get());
            this.m_246535_((Block)UGBlocks.POTTED_AMOROUS_BRISTLE.get());
            this.m_246535_((Block)UGBlocks.POTTED_MISERABELL.get());
            this.m_246535_((Block)UGBlocks.POTTED_BUTTERBUNCH.get());
            this.dropWithSilk((Supplier<? extends Block>)UGBlocks.FROZEN_DEEPTURF_BLOCK, (Supplier<? extends ItemLike>)UGBlocks.DEEPSOIL);
            this.m_246481_((Block)UGBlocks.FROZEN_DEEPTURF.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CHISELED_TREMBLECRUST_BRICKS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_STAIRS);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_SLAB);
            this.slab((Supplier<? extends SlabBlock>)UGBlocks.TREMBLECRUST_BRICK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BRICK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_BUTTON);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_PRESSURE_PLATE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_SIGN, (ItemLike)UGBlocks.SMOGSTEM_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_SIGN, (ItemLike)UGBlocks.GRONGLE_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SMOGSTEM_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.SMOGSTEM_WALL_HANGING_SIGN, (ItemLike)UGBlocks.SMOGSTEM_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.WIGGLEWOOD_WALL_HANGING_SIGN, (ItemLike)UGBlocks.WIGGLEWOOD_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLE_HANGING_SIGN);
            this.dropOther((Supplier<? extends Block>)UGBlocks.GRONGLE_WALL_HANGING_SIGN, (ItemLike)UGBlocks.GRONGLE_HANGING_SIGN.get());
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GOO_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.SEDIMENT);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS);
            this.dropAsSilk((Supplier<? extends Block>)UGBlocks.SEDIMENT_GLASS_PANE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_TILE_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILES);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.DEPTHROCK_TILE_SLAB);
            this.m_246481_((Block)UGBlocks.DEPTHROCK_BED.get(), bed -> this.m_245178_((Block)bed, (Property)BedBlock.f_49440_, (Comparable)BedPart.HEAD));
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MOGMOSS_RUG);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_COAL_ORE, Items.f_42413_);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_COAL_ORE, Items.f_42413_);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_IRON_ORE, Items.f_42749_);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_IRON_ORE, Items.f_42749_);
            this.nuggetOre((Supplier<? extends Block>)UGBlocks.DEPTHROCK_GOLD_ORE, Items.f_42587_);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_DIAMOND_ORE, Items.f_42415_);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_DIAMOND_ORE, Items.f_42415_);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_CLOGGRUM_ORE, (Supplier<? extends Item>)UGItems.RAW_CLOGGRUM);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_FROSTSTEEL_ORE, (Supplier<? extends Item>)UGItems.RAW_FROSTSTEEL);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.TREMBLECRUST_UTHERIUM_ORE, (Supplier<? extends Item>)UGItems.UTHERIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.DEPTHROCK_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.ore((Supplier<? extends Block>)UGBlocks.SHIVERSTONE_REGALIUM_ORE, (Supplier<? extends Item>)UGItems.REGALIUM_CRYSTAL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_CLOGGRUM_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.RAW_FROSTSTEEL_BLOCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.CLOGGRUM_LANTERN);
            this.m_246481_((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
            this.m_246481_((Block)UGBlocks.DROOPVINE.get(), UGLootTables::droopvine);
            this.m_246481_((Block)UGBlocks.DROOPVINE_PLANT.get(), UGLootTables::droopvine);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.GRONGLET);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BOOMGOURD);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_STAIRS);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_SLAB);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.POLISHED_DEPTHROCK_WALL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.AMOROUS_BRISTLE);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.MISERABELL);
            this.dropSelf((Supplier<? extends Block>)UGBlocks.BUTTERBUNCH);
            this.dropOther((Supplier<? extends Block>)UGBlocks.VIRULENT_MIX_CAULDRON, (ItemLike)Items.f_42544_);
            this.m_246481_((Block)UGBlocks.MUSHROOM_VEIL.get(), x$0 -> BlockLootSubProvider.m_245929_((ItemLike)x$0));
        }

        protected Iterable<Block> getKnownBlocks() {
            return UGBlocks.BLOCKS.getEntries().stream().map(Supplier::get).collect(Collectors.toList());
        }
    }
}

