/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity.animal;

import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.event.ForgeEventFactory;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGTags;

public class Scintling
extends Animal {
    public Scintling(EntityType<? extends Animal> type, Level level) {
        super(type, level);
        this.f_21364_ = 0;
        this.m_274367_(1.0f);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new AvoidEntityGoal((PathfinderMob)this, RotspawnMonster.class, 12.0f, 1.2, 1.4));
        this.f_21345_.m_25352_(1, (Goal)new TemptGoal((PathfinderMob)this, 1.5, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.BLISTERBERRY.get()}), false));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(1, (Goal)new FollowParentGoal((Animal)this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Animal.m_21552_().m_22268_(Attributes.f_22276_, 2.0).m_22268_(Attributes.f_22279_, 0.2);
    }

    public static boolean canScintlingSpawn(EntityType<? extends Animal> type, LevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return level.m_8055_(pos.m_7495_()).m_204336_(UGTags.Blocks.SCINTLING_SPAWNABLE_ON);
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)UGSoundEvents.SCINTLING_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.SCINTLING_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!ForgeEventFactory.getMobGriefingEvent((Level)this.m_9236_(), (Entity)this) || this.m_6162_()) {
            return;
        }
        BlockState goo = ((Block)UGBlocks.GOO.get()).m_49966_();
        for (int l = 0; l < 4; ++l) {
            int x = Mth.m_14107_((double)(this.m_20185_() + (double)((float)(l % 2 * 2 - 1) * 0.25f)));
            int y = Mth.m_14107_((double)this.m_20186_());
            int z = Mth.m_14107_((double)(this.m_20189_() + (double)((float)(l / 2 % 2 * 2 - 1) * 0.25f)));
            BlockPos blockpos = new BlockPos(x, y, z);
            if (!this.m_9236_().m_46859_(blockpos) || !goo.m_60710_((LevelReader)this.m_9236_(), blockpos)) continue;
            this.m_9236_().m_46597_(blockpos, goo);
        }
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel level, AgeableMob mob) {
        return (AgeableMob)((EntityType)UGEntityTypes.SCINTLING.get()).m_20615_(this.m_9236_());
    }

    public boolean m_6898_(ItemStack stack) {
        return Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)UGItems.BLISTERBERRY.get()}).test(stack);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_((SoundEvent)UGSoundEvents.SCINTLING_STEP.get(), 0.3f, 1.0f);
    }
}

