/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden.entity;

import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.AbstractSkeleton;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import quek.undergarden.entity.rotspawn.RotspawnMonster;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGSoundEvents;

public class Forgotten
extends AbstractSkeleton {
    public Forgotten(EntityType<? extends AbstractSkeleton> type, Level level) {
        super(type, level);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.25, false));
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, RotspawnMonster.class, true));
    }

    public static AttributeSupplier.Builder m_32166_() {
        return AbstractSkeleton.m_21552_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22281_, 2.0).m_22268_(Attributes.f_22284_, 2.0).m_22268_(Attributes.f_22279_, 0.25);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource source) {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_DEATH.get();
    }

    protected SoundEvent m_7878_() {
        return (SoundEvent)UGSoundEvents.FORGOTTEN_STEP.get();
    }

    protected void m_213945_(RandomSource random, DifficultyInstance difficulty) {
        if (random.m_188503_(50) == 0) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_BATTLEAXE.get()));
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)UGItems.FORGOTTEN_HELMET.get()));
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)UGItems.FORGOTTEN_CHESTPLATE.get()));
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)UGItems.FORGOTTEN_LEGGINGS.get()));
        } else {
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                Item item;
                ItemStack armorStack;
                if (slot.m_20743_() != EquipmentSlot.Type.ARMOR || !(armorStack = this.m_6844_(slot)).m_41619_() || (item = Forgotten.getEquipmentForSlot(slot)) == null || !random.m_188499_()) continue;
                this.m_8061_(slot, new ItemStack((ItemLike)item));
            }
            if (random.m_188499_()) {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_SWORD.get()));
            } else {
                this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)UGItems.CLOGGRUM_AXE.get()));
            }
        }
    }

    protected void m_7472_(DamageSource source, int looting, boolean recentlyHit) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            boolean doDrop;
            if (slot.m_20743_() != EquipmentSlot.Type.HAND) continue;
            ItemStack itemstack = this.m_6844_(slot);
            float dropChance = this.m_21519_(slot);
            boolean bl = doDrop = dropChance > 1.0f;
            if (!itemstack.m_41619_() && !EnchantmentHelper.m_44924_((ItemStack)itemstack) && (recentlyHit || doDrop) && Math.max(this.f_19796_.m_188501_() - (float)looting * 0.01f, 0.0f) < dropChance) {
                if (!doDrop && itemstack.m_41763_()) {
                    itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack.m_41776_() - 3, 1))));
                }
                this.m_19983_(itemstack);
                this.m_8061_(slot, ItemStack.f_41583_);
            }
            if (!itemstack.m_150930_((Item)UGItems.CLOGGRUM_BATTLEAXE.get()) || EnchantmentHelper.m_44924_((ItemStack)itemstack) || !recentlyHit) continue;
            if (itemstack.m_41763_()) {
                itemstack.m_41721_(itemstack.m_41776_() - this.f_19796_.m_188503_(1 + this.f_19796_.m_188503_(Math.max(itemstack.m_41776_() - 3, 1))));
            }
            this.m_19983_(itemstack);
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    @Nullable
    public static Item getEquipmentForSlot(EquipmentSlot slot) {
        return switch (slot) {
            case EquipmentSlot.HEAD -> (Item)UGItems.FORGOTTEN_HELMET.get();
            case EquipmentSlot.CHEST -> (Item)UGItems.FORGOTTEN_CHESTPLATE.get();
            case EquipmentSlot.LEGS -> (Item)UGItems.FORGOTTEN_LEGGINGS.get();
            default -> null;
        };
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return 1.9f;
    }

    protected boolean m_21527_() {
        return false;
    }
}

