/*
 * Decompiled with CFR 0.152.
 */
package quek.undergarden;

import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.DetectedVersion;
import net.minecraft.Util;
import net.minecraft.WorldVersion;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.dispenser.AbstractProjectileDispenseBehavior;
import net.minecraft.core.dispenser.DefaultDispenseItemBehavior;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.FireBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.StemGrownBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fluids.FluidInteractionRegistry;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import quek.undergarden.UndergardenConfig;
import quek.undergarden.capability.IUndergardenPortal;
import quek.undergarden.data.UGAdvancements;
import quek.undergarden.data.UGBiomeTags;
import quek.undergarden.data.UGBlockStates;
import quek.undergarden.data.UGBlockTags;
import quek.undergarden.data.UGDamageTypeTags;
import quek.undergarden.data.UGEntityTags;
import quek.undergarden.data.UGFluidTags;
import quek.undergarden.data.UGItemModels;
import quek.undergarden.data.UGItemTags;
import quek.undergarden.data.UGLang;
import quek.undergarden.data.UGLootTables;
import quek.undergarden.data.UGRecipes;
import quek.undergarden.data.UGRegistries;
import quek.undergarden.data.UGSoundDefinitions;
import quek.undergarden.entity.Boomgourd;
import quek.undergarden.entity.projectile.Blisterbomb;
import quek.undergarden.entity.projectile.slingshot.DepthrockPebble;
import quek.undergarden.entity.projectile.slingshot.GooBall;
import quek.undergarden.entity.projectile.slingshot.Gronglet;
import quek.undergarden.entity.projectile.slingshot.RottenBlisterberry;
import quek.undergarden.entity.projectile.slingshot.SlingshotProjectile;
import quek.undergarden.item.tool.slingshot.AbstractSlingshotAmmoBehavior;
import quek.undergarden.item.tool.slingshot.SlingshotItem;
import quek.undergarden.network.UGPacketHandler;
import quek.undergarden.registry.UGBlockEntities;
import quek.undergarden.registry.UGBlocks;
import quek.undergarden.registry.UGCarvers;
import quek.undergarden.registry.UGCauldronInteractions;
import quek.undergarden.registry.UGCreativeModeTabs;
import quek.undergarden.registry.UGCriteria;
import quek.undergarden.registry.UGEffects;
import quek.undergarden.registry.UGEnchantments;
import quek.undergarden.registry.UGEntityTypes;
import quek.undergarden.registry.UGFeatures;
import quek.undergarden.registry.UGFluids;
import quek.undergarden.registry.UGFoliagePlacers;
import quek.undergarden.registry.UGItems;
import quek.undergarden.registry.UGParticleTypes;
import quek.undergarden.registry.UGPointOfInterests;
import quek.undergarden.registry.UGPotions;
import quek.undergarden.registry.UGSoundEvents;
import quek.undergarden.registry.UGStructures;
import quek.undergarden.registry.UGTreeDecoratorTypes;
import quek.undergarden.registry.UGTrunkPlacerTypes;
import quek.undergarden.registry.UGWoodStuff;
import quek.undergarden.registry.UndergardenCapabilities;

@Mod(value="undergarden")
public class Undergarden {
    public static final String MODID = "undergarden";

    public Undergarden() {
        DeferredRegister[] registers;
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::clientSetup);
        bus.addListener(this::gatherData);
        MinecraftForge.EVENT_BUS.addListener(this::portalTick);
        for (DeferredRegister register : registers = new DeferredRegister[]{UGBlockEntities.BLOCK_ENTITIES, UGBlocks.BLOCKS, UGCarvers.CARVERS, UGEffects.EFFECTS, UGEnchantments.ENCHANTMENTS, UGEntityTypes.ENTITIES, UGFeatures.FEATURES, UGFluids.FLUIDS, UGFoliagePlacers.FOLIAGE_PLACERS, UGItems.ITEMS, UGParticleTypes.PARTICLES, UGPointOfInterests.POI, UGPotions.POTIONS, UGSoundEvents.SOUNDS, UGStructures.STRUCTURES, UGCreativeModeTabs.TABS, UGTreeDecoratorTypes.TREE_DECORATORS, UGTrunkPlacerTypes.TRUNK_PLACERS, UGFluids.TYPES}) {
            register.register(bus);
        }
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, (IConfigSpec)UndergardenConfig.COMMON_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)UndergardenConfig.CLIENT_SPEC);
    }

    public void setup(FMLCommonSetupEvent event) {
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.WATER_TYPE.get(), fluidState -> ((Block)UGBlocks.DEPTHROCK.get()).m_49966_()));
        FluidInteractionRegistry.addInteraction((FluidType)((FluidType)UGFluids.VIRULENT_MIX_TYPE.get()), (FluidInteractionRegistry.InteractionInformation)new FluidInteractionRegistry.InteractionInformation((FluidType)ForgeMod.LAVA_TYPE.get(), fluidState -> fluidState.m_76170_() ? Blocks.f_50080_.m_49966_() : ((Block)UGBlocks.SHIVERSTONE.get()).m_49966_()));
        event.enqueueWork(() -> {
            UGPacketHandler.init();
            UGCriteria.register();
            UGCauldronInteractions.register();
            DefaultDispenseItemBehavior bucketBehavior = new DefaultDispenseItemBehavior(){
                private final DefaultDispenseItemBehavior defaultBehavior = new DefaultDispenseItemBehavior();

                public ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    BucketItem bucketitem = (BucketItem)stack.m_41720_();
                    BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    ServerLevel world = source.m_7727_();
                    if (bucketitem.m_142073_(null, (Level)world, blockpos, null)) {
                        bucketitem.m_142131_(null, (Level)world, stack, blockpos);
                        return new ItemStack((ItemLike)Items.f_42446_);
                    }
                    return this.defaultBehavior.m_6115_(source, stack);
                }
            };
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.VIRULENT_MIX_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GWIBLING_BUCKET.get()), (DispenseItemBehavior)bucketBehavior);
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.DEPTHROCK_PEBBLE.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new DepthrockPebble(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.GOO_BALL.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new GooBall(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new RottenBlisterberry(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGItems.BLISTERBOMB.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new Blisterbomb(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGBlocks.GRONGLET.get()), (DispenseItemBehavior)new AbstractProjectileDispenseBehavior(){

                protected Projectile m_6895_(Level level, Position position, ItemStack stack) {
                    return (Projectile)Util.m_137469_((Object)((Object)new Gronglet(level, position.m_7096_(), position.m_7098_(), position.m_7094_())), entity -> entity.m_37446_(stack));
                }
            });
            DispenserBlock.m_52672_((ItemLike)((ItemLike)UGBlocks.BOOMGOURD.get()), (DispenseItemBehavior)new DefaultDispenseItemBehavior(){

                protected ItemStack m_7498_(BlockSource source, ItemStack stack) {
                    ServerLevel level = source.m_7727_();
                    BlockPos blockpos = source.m_7961_().m_121945_((Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_));
                    Boomgourd gourd = new Boomgourd((Level)level, (double)blockpos.m_123341_() + 0.5, blockpos.m_123342_(), (double)blockpos.m_123343_() + 0.5, null);
                    level.m_7967_((Entity)gourd);
                    level.m_6263_(null, gourd.m_20185_(), gourd.m_20186_(), gourd.m_20189_(), (SoundEvent)UGSoundEvents.BOOMGOURD_PRIMED.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    level.m_142346_(null, GameEvent.f_157810_, blockpos);
                    stack.m_41774_(1);
                    return stack;
                }
            });
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)UGItems.BLOOD_GLOBULE.get()), (Potion)((Potion)UGPotions.BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.BRITTLENESS.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_BRITTLENESS.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Block)UGBlocks.VEIL_MUSHROOM.get()).m_5456_(), (Potion)((Potion)UGPotions.FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.FEATHERWEIGHT.get()), (Item)Items.f_42525_, (Potion)((Potion)UGPotions.STRONG_FEATHERWEIGHT.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((StemGrownBlock)UGBlocks.GLOOMGOURD.get()).m_5456_(), (Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.VIRULENT_RESISTANCE.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_VIRULENT_RESISTANCE.get()));
            PotionBrewing.m_43513_((Potion)Potions.f_43602_, (Item)((Item)UGItems.DROOPFRUIT.get()), (Potion)((Potion)UGPotions.GLOWING.get()));
            PotionBrewing.m_43513_((Potion)((Potion)UGPotions.GLOWING.get()), (Item)Items.f_42451_, (Potion)((Potion)UGPotions.LONG_GLOWING.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.DROOPFRUIT.get()));
            ComposterBlock.m_51920_((float)0.1f, (ItemLike)((ItemLike)UGItems.UNDERBEANS.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.BLISTERBERRY.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get()));
            ComposterBlock.m_51920_((float)0.2f, (ItemLike)((ItemLike)UGItems.BLOOD_GLOBULE.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLOOMGOURD_SEEDS.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGItems.GLITTERKELP.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_LEAVES.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SMOGSTEM_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.WIGGLEWOOD_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.GRONGLE_SAPLING.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.3f, (ItemLike)((ItemLike)UGBlocks.SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_DEEPTURF.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGItems.DITCHBULB.get()));
            ComposterBlock.m_51920_((float)0.5f, (ItemLike)((ItemLike)UGBlocks.TALL_SHIMMERWEED.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.65f, (ItemLike)((ItemLike)UGBlocks.CARVED_GLOOMGOURD.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INDIGO_MUSHROOM_STEM.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.VEIL_MUSHROOM_STEM.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.INK_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.ENGORGED_BLOOD_MUSHROOM_CAP.get()));
            ComposterBlock.m_51920_((float)0.85f, (ItemLike)((ItemLike)UGBlocks.BLOOD_MUSHROOM_STEM.get()));
            FlowerPotBlock pot = (FlowerPotBlock)Blocks.f_50276_;
            pot.addPlant(UGBlocks.SMOGSTEM_SAPLING.getId(), UGBlocks.POTTED_SMOGSTEM_SAPLING);
            pot.addPlant(UGBlocks.WIGGLEWOOD_SAPLING.getId(), UGBlocks.POTTED_WIGGLEWOOD_SAPLING);
            pot.addPlant(UGBlocks.SHIMMERWEED.getId(), UGBlocks.POTTED_SHIMMERWEED);
            pot.addPlant(UGBlocks.INDIGO_MUSHROOM.getId(), UGBlocks.POTTED_INDIGO_MUSHROOM);
            pot.addPlant(UGBlocks.VEIL_MUSHROOM.getId(), UGBlocks.POTTED_VEIL_MUSHROOM);
            pot.addPlant(UGBlocks.INK_MUSHROOM.getId(), UGBlocks.POTTED_INK_MUSHROOM);
            pot.addPlant(UGBlocks.BLOOD_MUSHROOM.getId(), UGBlocks.POTTED_BLOOD_MUSHROOM);
            pot.addPlant(UGBlocks.GRONGLE_SAPLING.getId(), UGBlocks.POTTED_GRONGLE_SAPLING);
            pot.addPlant(UGBlocks.AMOROUS_BRISTLE.getId(), UGBlocks.POTTED_AMOROUS_BRISTLE);
            pot.addPlant(UGBlocks.MISERABELL.getId(), UGBlocks.POTTED_MISERABELL);
            pot.addPlant(UGBlocks.BUTTERBUNCH.getId(), UGBlocks.POTTED_BUTTERBUNCH);
            WoodType.m_61844_((WoodType)UGWoodStuff.SMOGSTEM_WOOD_TYPE);
            WoodType.m_61844_((WoodType)UGWoodStuff.WIGGLEWOOD_WOOD_TYPE);
            WoodType.m_61844_((WoodType)UGWoodStuff.GRONGLE_WOOD_TYPE);
            SlingshotItem.registerAmmo((ItemLike)UGItems.DEPTHROCK_PEBBLE.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new DepthrockPebble(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.ROTTEN_BLISTERBERRY.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new RottenBlisterberry(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGItems.GOO_BALL.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new GooBall(level, (LivingEntity)shooter);
                }
            });
            SlingshotItem.registerAmmo((ItemLike)UGBlocks.GRONGLET.get(), new AbstractSlingshotAmmoBehavior(){

                @Override
                public SlingshotProjectile getProjectile(Level level, BlockPos pos, Player shooter, ItemStack stack) {
                    return new Gronglet((LivingEntity)shooter, level);
                }

                @Override
                public SoundEvent getFiringSound() {
                    return (SoundEvent)UGSoundEvents.GRONGLET_SHOOT.get();
                }
            });
            FireBlock fire = (FireBlock)Blocks.f_50083_;
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_PLANKS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_SLAB.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_FENCE_GATE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_FENCE.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.GRONGLE_STAIRS.get(), 5, 20);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.GRONGLE_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_SMOGSTEM_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_WIGGLEWOOD_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_GRONGLE_LOG.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.GRONGLE_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_SMOGSTEM_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_WIGGLEWOOD_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.STRIPPED_GRONGLE_WOOD.get(), 5, 5);
            fire.m_53444_((Block)UGBlocks.SMOGSTEM_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.WIGGLEWOOD_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.GRONGLE_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.HANGING_GRONGLE_LEAVES.get(), 30, 60);
            fire.m_53444_((Block)UGBlocks.DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.FROZEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.SHIMMERWEED.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.TALL_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.TALL_SHIMMERWEED.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.UNDERBEAN_BUSH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.BLISTERBERRY_BUSH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.ASHEN_DEEPTURF.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.DITCHBULB_PLANT.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.DROOPVINE.get(), 15, 60);
            fire.m_53444_((Block)UGBlocks.DROOPVINE_PLANT.get(), 15, 60);
            fire.m_53444_((Block)UGBlocks.AMOROUS_BRISTLE.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.MISERABELL.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.BUTTERBUNCH.get(), 60, 100);
            fire.m_53444_((Block)UGBlocks.MOGMOSS_RUG.get(), 60, 20);
            fire.m_53444_((Block)UGBlocks.BLUE_MOGMOSS_RUG.get(), 60, 20);
            fire.m_53444_((Block)UGBlocks.BOOMGOURD.get(), 15, 100);
            fire.m_53444_((Block)UGBlocks.GRONGLET.get(), 100, 100);
        });
    }

    public void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)UGWoodStuff.SMOGSTEM_WOOD_TYPE);
            Sheets.addWoodType((WoodType)UGWoodStuff.WIGGLEWOOD_WOOD_TYPE);
            Sheets.addWoodType((WoodType)UGWoodStuff.GRONGLE_WOOD_TYPE);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, world, entity, seed) -> {
                if (entity == null) {
                    return 0.0f;
                }
                return entity.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - entity.m_21212_()) / 20.0f;
            });
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("rotten_blisterberry"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_((Item)UGItems.ROTTEN_BLISTERBERRY.get()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("goo_ball"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_((Item)UGItems.GOO_BALL.get()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("gronglet"), (stack, level, entity, seed) -> entity != null && entity.m_6298_(stack).m_150930_(((Block)UGBlocks.GRONGLET.get()).m_5456_()) ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("self_sling"), (stack, level, entity, seed) -> entity != null && stack.getEnchantmentLevel((Enchantment)UGEnchantments.SELF_SLING.get()) > 0 ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.SLINGSHOT.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
            ItemProperties.register((Item)((Item)UGItems.CLOGGRUM_SHIELD.get()), (ResourceLocation)new ResourceLocation("blocking"), (stack, world, entity, seed) -> entity != null && entity.m_6117_() && entity.m_21211_() == stack ? 1.0f : 0.0f);
        });
    }

    public void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture provider = event.getLookupProvider();
        ExistingFileHelper helper = event.getExistingFileHelper();
        generator.addProvider(event.includeClient(), (DataProvider)new UGBlockStates(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new UGItemModels(output, helper));
        generator.addProvider(event.includeClient(), (DataProvider)new UGLang(output));
        generator.addProvider(event.includeClient(), (DataProvider)new UGSoundDefinitions(output, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGRecipes(output));
        generator.addProvider(event.includeServer(), (DataProvider)new UGLootTables(output));
        UGBlockTags blockTags = new UGBlockTags(output, provider, helper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTags);
        generator.addProvider(event.includeServer(), (DataProvider)new UGItemTags(output, provider, blockTags.m_274426_(), helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGEntityTags(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGAdvancements(output, provider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGFluidTags(output, provider, helper));
        UGRegistries datapackProvider = new UGRegistries(output, provider);
        CompletableFuture lookupProvider = datapackProvider.getRegistryProvider();
        generator.addProvider(event.includeServer(), (DataProvider)datapackProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new UGBiomeTags(output, lookupProvider, helper));
        generator.addProvider(event.includeServer(), (DataProvider)new UGDamageTypeTags(output, lookupProvider, helper));
        generator.addProvider(true, (DataProvider)new PackMetadataGenerator(output).m_247300_(PackMetadataSection.f_243696_, (Object)new PackMetadataSection((Component)Component.m_237113_((String)"Undergarden resources"), DetectedVersion.f_132476_.m_264084_(PackType.CLIENT_RESOURCES), Arrays.stream(PackType.values()).collect(Collectors.toMap(Function.identity(), arg_0 -> ((WorldVersion)DetectedVersion.f_132476_).m_264084_(arg_0))))));
    }

    public void portalTick(LivingEvent.LivingTickEvent event) {
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            player.getCapability(UndergardenCapabilities.UNDERGARDEN_PORTAL_CAPABILITY).ifPresent(IUndergardenPortal::handleUndergardenPortal);
        }
    }
}

