/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.common.containermenu.ManagerContainerMenu;
import ca.teamdman.sfm.common.net.ClientboundLabelInspectionResultsPacket;
import ca.teamdman.sfm.common.net.ServerboundContainerExportsInspectionRequestPacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMItems;
import ca.teamdman.sfm.common.registry.SFMPackets;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.LevelAccessor;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public record ServerboundLabelInspectionRequestPacket(String label) {
    public static void encode(ServerboundLabelInspectionRequestPacket msg, FriendlyByteBuf friendlyByteBuf) {
        friendlyByteBuf.m_130072_(msg.label(), 256);
    }

    public static ServerboundLabelInspectionRequestPacket decode(FriendlyByteBuf friendlyByteBuf) {
        return new ServerboundLabelInspectionRequestPacket(friendlyByteBuf.m_130136_(256));
    }

    public static void handle(ServerboundLabelInspectionRequestPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        contextSupplier.get().enqueueWork(() -> {
            LabelPositionHolder labelPositionHolder;
            ServerPlayer player = ((NetworkEvent.Context)contextSupplier.get()).getSender();
            if (player == null) {
                return;
            }
            SFM.LOGGER.info("Received label inspection request packet from player " + player.m_20149_());
            AbstractContainerMenu patt1756$temp = player.f_36096_;
            if (patt1756$temp instanceof ManagerContainerMenu) {
                ManagerContainerMenu mcm = (ManagerContainerMenu)patt1756$temp;
                SFM.LOGGER.info("Player is using a manager container menu - will append additional info to payload");
                labelPositionHolder = LabelPositionHolder.from(mcm.CONTAINER.m_8020_(0));
            } else {
                labelPositionHolder = player.m_21205_().m_150930_((Item)SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.m_21205_()) : (player.m_21206_().m_150930_((Item)SFMItems.DISK_ITEM.get()) ? LabelPositionHolder.from(player.m_21206_()) : null);
            }
            if (labelPositionHolder == null) {
                SFM.LOGGER.info("Label holder wasn't found - aborting");
                return;
            }
            SFM.LOGGER.info("building payload");
            StringBuilder payload = new StringBuilder();
            payload.append("-- Positions for label \"").append(msg.label()).append("\" --\n");
            payload.append(labelPositionHolder.getPositions(msg.label()).size()).append(" assignments\n");
            payload.append("-- Summary --\n");
            labelPositionHolder.get().getOrDefault(msg.label(), Set.of()).forEach(pos -> {
                payload.append(pos.m_123341_()).append(",").append(pos.m_123342_()).append(",").append(pos.m_123343_());
                if (player.m_9236_().m_46749_(pos)) {
                    payload.append(" -- ").append(player.m_9236_().m_8055_(pos).m_60734_().m_49954_().getString());
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            });
            payload.append("\n\n\n-- Detailed --\n");
            for (BlockPos pos2 : labelPositionHolder.get().getOrDefault(msg.label(), Set.of())) {
                if (payload.length() > 20000) {
                    payload.append("... (truncated)");
                    break;
                }
                payload.append(pos2.m_123341_()).append(",").append(pos2.m_123342_()).append(",").append(pos2.m_123343_());
                if (player.m_9236_().m_46749_(pos2)) {
                    payload.append(" -- ").append(player.m_9236_().m_8055_(pos2).m_60734_().m_49954_().getString());
                    payload.append("\n").append(ServerboundContainerExportsInspectionRequestPacket.buildInspectionResults((LevelAccessor)player.m_9236_(), pos2).indent(1));
                } else {
                    payload.append(" -- chunk not loaded");
                }
                payload.append("\n");
            }
            SFM.LOGGER.info("Sending payload response length=" + payload.length() + " to player " + player.m_20149_());
            SFMPackets.INSPECTION_CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)new ClientboundLabelInspectionResultsPacket(payload.toString()));
        });
    }
}

