/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.item;

import ca.teamdman.sfm.client.ClientStuff;
import ca.teamdman.sfm.client.ProgramSyntaxHighlightingHelper;
import ca.teamdman.sfm.client.registry.SFMKeyMappings;
import ca.teamdman.sfm.common.Constants;
import ca.teamdman.sfm.common.blockentity.ManagerBlockEntity;
import ca.teamdman.sfm.common.net.ServerboundDiskItemSetProgramPacket;
import ca.teamdman.sfm.common.program.LabelPositionHolder;
import ca.teamdman.sfm.common.registry.SFMPackets;
import ca.teamdman.sfm.common.util.SFMUtils;
import ca.teamdman.sfml.ast.Program;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.jetbrains.annotations.NotNull;

public class DiskItem
extends Item {
    public DiskItem() {
        super(new Item.Properties());
    }

    public static String getProgram(ItemStack stack) {
        return stack.m_41784_().m_128461_("sfm:program");
    }

    public static Optional<Program> updateDetails(ItemStack stack, @Nullable ManagerBlockEntity manager) {
        AtomicReference<Object> rtn = new AtomicReference<Object>(null);
        Program.compile(DiskItem.getProgram(stack), (successProgram, builder) -> {
            DiskItem.setProgramName(stack, successProgram.name());
            DiskItem.setWarnings(stack, successProgram.gatherWarnings(stack, manager));
            DiskItem.setErrors(stack, Collections.emptyList());
            rtn.set(successProgram);
        }, failure -> {
            DiskItem.setWarnings(stack, Collections.emptyList());
            DiskItem.setErrors(stack, failure);
        });
        return Optional.ofNullable(rtn.get());
    }

    public static void setProgram(ItemStack stack, String program) {
        stack.m_41784_().m_128359_("sfm:program", program.replaceAll("\r", ""));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level pLevel, Player pPlayer, InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (pLevel.f_46443_) {
            ClientStuff.showProgramEditScreen(stack, programString -> SFMPackets.DISK_ITEM_CHANNEL.sendToServer((Object)new ServerboundDiskItemSetProgramPacket((String)programString, pUsedHand)));
        }
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.m_5776_());
    }

    public static void setErrors(ItemStack stack, List<TranslatableContents> errors) {
        stack.m_41784_().m_128365_("sfm:errors", (Tag)errors.stream().map(SFMUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static void setWarnings(ItemStack stack, List<TranslatableContents> warnings) {
        stack.m_41784_().m_128365_("sfm:warnings", (Tag)warnings.stream().map(SFMUtils::serializeTranslation).collect(ListTag::new, AbstractList::add, AbstractCollection::addAll));
    }

    public static List<TranslatableContents> getErrors(ItemStack stack) {
        return stack.m_41784_().m_128437_("sfm:errors", 10).stream().map(CompoundTag.class::cast).map(SFMUtils::deserializeTranslation).toList();
    }

    public static List<TranslatableContents> getWarnings(ItemStack stack) {
        return stack.m_41784_().m_128437_("sfm:warnings", 10).stream().map(CompoundTag.class::cast).map(SFMUtils::deserializeTranslation).collect(Collectors.toList());
    }

    public static String getProgramName(ItemStack stack) {
        return stack.m_41784_().m_128461_("sfm:name");
    }

    public static void setProgramName(ItemStack stack, String name) {
        if (stack.m_41720_() instanceof DiskItem) {
            stack.m_41784_().m_128359_("sfm:name", name);
        }
    }

    public Component m_7626_(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT && ClientStuff.isMoreInfoKeyDown()) {
            return super.m_7626_(stack);
        }
        String name = DiskItem.getProgramName(stack);
        if (name.isEmpty()) {
            return super.m_7626_(stack);
        }
        return Component.m_237113_((String)name).m_130940_(ChatFormatting.AQUA);
    }

    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag detail) {
        if (stack.m_41782_()) {
            boolean showProgram = (Boolean)DistExecutor.unsafeRunForDist(() -> ClientStuff::isMoreInfoKeyDown, () -> () -> false);
            if (!showProgram) {
                list.addAll(LabelPositionHolder.from(stack).asHoverText());
                DiskItem.getErrors(stack).stream().map(MutableComponent::m_237204_).map(line -> line.m_130940_(ChatFormatting.RED)).forEach(list::add);
                DiskItem.getWarnings(stack).stream().map(MutableComponent::m_237204_).map(line -> line.m_130940_(ChatFormatting.YELLOW)).forEach(list::add);
                list.add((Component)Constants.LocalizationKeys.GUI_ADVANCED_TOOLTIP_HINT.getComponent(((KeyMapping)SFMKeyMappings.MORE_INFO_TOOLTIP_KEY.get()).m_90863_()).m_130940_(ChatFormatting.AQUA));
            } else {
                String program = DiskItem.getProgram(stack);
                if (!program.isEmpty()) {
                    MutableComponent start = Component.m_237119_();
                    ChatFormatting[] rainbowColors = new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.RED, ChatFormatting.GOLD, ChatFormatting.YELLOW, ChatFormatting.DARK_GREEN, ChatFormatting.GREEN, ChatFormatting.DARK_AQUA, ChatFormatting.AQUA, ChatFormatting.DARK_BLUE, ChatFormatting.BLUE, ChatFormatting.DARK_PURPLE, ChatFormatting.LIGHT_PURPLE};
                    int rainbowColorsLength = rainbowColors.length;
                    int fullCycleLength = 2 * rainbowColorsLength - 2;
                    for (int i = 0; i < this.m_7626_(stack).getString().length() - 2; ++i) {
                        int cyclePosition = i % fullCycleLength;
                        int adjustedIndex = cyclePosition < rainbowColorsLength ? cyclePosition : fullCycleLength - cyclePosition;
                        ChatFormatting color = rainbowColors[adjustedIndex];
                        start = start.m_7220_((Component)Component.m_237113_((String)"=").m_130940_(color));
                    }
                    list.add((Component)start);
                    list.addAll(ProgramSyntaxHighlightingHelper.withSyntaxHighlighting(program, false));
                }
            }
        }
    }
}

